/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.lang.StringUtils;

public class StartEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        StartEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        StartEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("StartNoneEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartTimerEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartErrorEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartMessageEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartSignalEvent", StartEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(StartEvent.class, StartEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        Event event = (Event)baseElement;
        return SpecialPropertyUtil.getStartEventType(event);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        StartEvent startEvent = (StartEvent)baseElement;
        super.convertElementToJson(propertiesNode, startEvent);
        List<EventDefinition> eventDefinitions = startEvent.getEventDefinitions();
        if (!eventDefinitions.isEmpty() && eventDefinitions.get(0) instanceof TimerEventDefinition) {
            this.addTimerEventProperties(eventDefinitions, propertiesNode);
        } else {
            this.addEventProperties(startEvent, propertiesNode);
        }
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new StartEvent();
    }

    private void addTimerEventProperties(List<EventDefinition> eventDefinitions, ObjectNode propertiesNode) {
        ArrayNode timingConfigs = this.objectMapper.createArrayNode();
        for (EventDefinition eventDefinition : eventDefinitions) {
            TimerEventDefinition event = (TimerEventDefinition)eventDefinition;
            ObjectNode timingConfig = this.objectMapper.createObjectNode();
            timingConfig.put("timeDate", event.getTimeDate());
            timingConfig.put("timeDuration", event.getTimeDuration());
            timingConfig.put("timeCycle", event.getTimeCycle());
            timingConfig.put("startDate", event.getStartDate());
            timingConfig.put("endDate", event.getEndDate());
            timingConfigs.add((JsonNode)timingConfig);
        }
        propertiesNode.putIfAbsent("timingConfigs", (JsonNode)timingConfigs);
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement parentElement) {
        StartEvent startEvent = (StartEvent)super.convertJsonToElement(elementNode, modelNode, shapeMap, parentElement);
        startEvent.setInitiator("initiator");
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinitions(elementNode, startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            if (parentElement instanceof EventSubProcess) {
                String messageRef = ((EventSubProcess)parentElement).getOperation();
                this.convertJsonToMessageDefinition(startEvent, messageRef);
            } else {
                this.convertJsonToSignalDefinition(elementNode, startEvent);
            }
        }
        return startEvent;
    }

    private void convertJsonToTimerDefinitions(JsonNode objectNode, Event event) {
        JsonNode timingConfigs = this.getProperty("timingConfigs", objectNode);
        if (timingConfigs == null || timingConfigs.isNull()) {
            return;
        }
        for (JsonNode config : timingConfigs) {
            String timeDate = this.getValueAsString("timeDate", config);
            String timeDuration = this.getValueAsString("timeDuration", config);
            String timeCycle = this.getValueAsString("timeCycle", config);
            String startDate = this.getValueAsString("startDate", config);
            String endDate = this.getValueAsString("endDate", config);
            TimerEventDefinition eventDefinition = new TimerEventDefinition();
            if (WfUtils.isNotEmpty(timeDate)) {
                eventDefinition.setTimeDate(timeDate);
            } else if (WfUtils.isNotEmpty(timeCycle)) {
                eventDefinition.setTimeCycle(timeCycle);
            } else if (WfUtils.isNotEmpty(timeDuration)) {
                eventDefinition.setTimeDuration(timeDuration);
            }
            if (StringUtils.isNotEmpty((String)startDate)) {
                eventDefinition.setStartDate(startDate);
            }
            if (StringUtils.isNotEmpty((String)endDate)) {
                eventDefinition.setEndDate(endDate);
            }
            event.getEventDefinitions().add(eventDefinition);
        }
    }
}

