/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.Transaction;
import kd.bos.workflow.bpmn.model.ValuedDataObject;

public class SubProcessJsonConverter
extends BaseBpmnJsonConverter {
    private static final String ISTRANSACTION = "istransaction";

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SubProcess", SubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SubProcess.class, SubProcessJsonConverter.class);
        convertersToJsonMap.put(Transaction.class, SubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "SubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        SubProcess subProcess = (SubProcess)baseElement;
        propertiesNode.put("activitytype", "Sub-Process");
        propertiesNode.put("subprocesstype", "Embedded");
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(subProcess.getId());
        this.processor.processFlowElements(subProcess, this.model, subProcessShapesArrayNode, graphicInfo.getX(), graphicInfo.getY());
        this.flowElementNode.put("childShapes", (JsonNode)subProcessShapesArrayNode);
        if (subProcess instanceof Transaction) {
            propertiesNode.put(ISTRANSACTION, true);
        }
        BpmnJsonConverterUtil.convertDataPropertiesToJson(subProcess.getDataObjects(), propertiesNode);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        SubProcess subProcess = null;
        subProcess = this.getPropertyValueAsBoolean(ISTRANSACTION, elementNode) ? new Transaction() : new SubProcess();
        return subProcess;
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        SubProcess subProcess = null;
        subProcess = this.getPropertyValueAsBoolean(ISTRANSACTION, elementNode) ? new Transaction() : new SubProcess();
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, subProcess, shapeMap, this.model);
        JsonNode processDataPropertiesNode = elementNode.get("properties").get("dataproperties");
        if (processDataPropertiesNode != null) {
            List<ValuedDataObject> dataObjects = BpmnJsonConverterUtil.convertJsonToDataProperties(processDataPropertiesNode, subProcess);
            subProcess.setDataObjects(dataObjects);
            subProcess.getFlowElements().addAll(dataObjects);
        }
        return subProcess;
    }
}

