/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.ThrowEvent;

public class ThrowEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ThrowEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ThrowEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ThrowNoneEvent", ThrowEventJsonConverter.class);
        convertersToBpmnMap.put("ThrowSignalEvent", ThrowEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ThrowEvent.class, ThrowEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        ThrowEvent throwEvent = (ThrowEvent)baseElement;
        List<EventDefinition> eventDefinitions = throwEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "ThrowNoneEvent";
        }
        EventDefinition eventDefinition = eventDefinitions.get(0);
        if (eventDefinition instanceof SignalEventDefinition) {
            return "ThrowSignalEvent";
        }
        return "ThrowNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ThrowEvent throwEvent = (ThrowEvent)baseElement;
        this.addEventProperties(throwEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        ThrowEvent throwEvent = new ThrowEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("ThrowSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, throwEvent);
        }
        return throwEvent;
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new ThrowEvent();
    }
}

