/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BillSubjectModel;
import kd.bos.workflow.bpmn.model.Circulate;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;

public class UserTaskJsonConverter
extends BaseBpmnJsonConverter {
    private static final String FORMKEY = "formKey";
    private static final String MOBILFORMKEY = "mobilFormKey";
    private static final Set<String> USERS_NEED_IGNORE = new HashSet<String>(2);

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        UserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        UserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", UserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, UserTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "UserTask";
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new UserTask();
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        JsonNode properties = elementNode.get("properties");
        JsonNode subject = null;
        if (properties instanceof ObjectNode) {
            ObjectNode advAppSchemeJn;
            JsonNode taskListeners = properties.get("tasklisteners");
            if (taskListeners instanceof ObjectNode) {
                ((ObjectNode)properties).remove("tasklisteners");
            }
            if ((subject = properties.get("subject")) instanceof ObjectNode) {
                ((ObjectNode)properties).remove("subject");
            } else {
                JsonNode task = properties.get("task");
                if (task != null && (subject = task.get("subject")) != null) {
                    ((ObjectNode)properties).remove("task");
                }
            }
            JsonNode advAppSchemeModelJn = properties.get("advAppSchemeModel");
            if (advAppSchemeModelJn instanceof ObjectNode && (advAppSchemeJn = (ObjectNode)advAppSchemeModelJn.get("advAppScheme")) instanceof ObjectNode) {
                ObjectMapper objectMapper = new ObjectMapper();
                ArrayNode advAppSchemeArr = objectMapper.createArrayNode();
                advAppSchemeArr.add((JsonNode)advAppSchemeJn);
                ((ObjectNode)advAppSchemeModelJn).put("advAppSchemes", (JsonNode)advAppSchemeArr);
                ((ObjectNode)advAppSchemeModelJn).remove("advAppScheme");
            }
        }
        UserTask userTask = (UserTask)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        this.setupMacro(elementNode, rootElement, userTask);
        this.billSettingCompatible(userTask, rootElement);
        this.operationCompatible(userTask);
        this.messageCompatible(elementNode, userTask, rootElement);
        this.listenersCompatible(userTask);
        this.taskSubjectsCompatible(subject, userTask);
        this.userNameFormatCompatible(elementNode, userTask);
        String entraBill = userTask.getEntityNumber();
        if (WfUtils.isNotEmpty(entraBill)) {
            this.businessOrgFieldCompatible(userTask, rootElement);
        }
        if (WfUtils.isEmpty(userTask.getProcessingPage())) {
            userTask.setProcessingPage("wf_approvalbill");
        }
        if (WfUtils.isEmpty(userTask.getProcessingMobilePage())) {
            userTask.setProcessingMobilePage("wf_approvalbillmob");
        }
        return userTask;
    }

    private void businessOrgFieldCompatible(UserTask userTask, BaseElement rootElement) {
        List<ParticipantModelEntityImpl> participantModelList;
        ParticipatantModel participant = userTask.getParticipant();
        String entraBill = userTask.getEntityNumber();
        if (participant != null && WfUtils.isNotEmpty(entraBill) && (participantModelList = participant.getParticipant()) != null) {
            Map<String, LocaleString> fieldMap = null;
            Map<String, LocaleString> orgFieldMapWithoutProcExp = null;
            Map<String, LocaleString> personFieldMap = null;
            for (ParticipantModelEntityImpl participantModel : participantModelList) {
                if ("role".equals(participantModel.getType())) {
                    String businessOrgField = participantModel.getBusinessOrgField();
                    if (!WfUtils.isNotEmpty(businessOrgField) || WfUtils.isJSONObject(businessOrgField)) continue;
                    JSONObject obj = new JSONObject();
                    obj.put("parseInfo", (Object)businessOrgField);
                    obj.put("selectType", (Object)"2");
                    if (fieldMap == null) {
                        fieldMap = this.getExtractOrgItems(entraBill);
                    }
                    obj.put("showName", (Object)fieldMap.get(businessOrgField));
                    participantModel.setBusinessOrgField(obj.toJSONString());
                    continue;
                }
                if (!"relation".equals(participantModel.getType())) continue;
                this.partRelatioConverter(participantModel, entraBill, rootElement, orgFieldMapWithoutProcExp, personFieldMap);
            }
        }
    }

    private void partRelatioConverter(ParticipantModelEntityImpl participantModel, String entraBill, BaseElement rootElement, Map<String, LocaleString> orgFieldMap, Map<String, LocaleString> personFieldMap) {
        String referenceOrg;
        String referencePerson = participantModel.getReferencePerson();
        if (WfUtils.isNotEmpty(referencePerson) && (referencePerson.startsWith("ENTI_") || referencePerson.startsWith("ENTRY_") || referencePerson.startsWith("PROC_")) && WfUtils.isEmpty(participantModel.getReferencePersonShowValue())) {
            if (personFieldMap == null) {
                personFieldMap = this.getExtractPersonItems(entraBill, rootElement);
            }
            participantModel.setReferencePerson(this.formatExpression(referencePerson));
            participantModel.setReferencePersonShowValue(personFieldMap.get(referencePerson) != null ? personFieldMap.get(referencePerson).toString() : referencePerson);
        }
        if (WfUtils.isNotEmpty(referenceOrg = participantModel.getReferenceOrg()) && (referenceOrg.startsWith("ENTI_") || referenceOrg.startsWith("ENTRY_") || referenceOrg.startsWith("PROC_")) && WfUtils.isEmpty(participantModel.getReferenceOrgShowValue())) {
            if (orgFieldMap == null) {
                orgFieldMap = this.getExtractOrgItemsWithoutExp(entraBill);
            }
            String showValue = orgFieldMap.get(referenceOrg) != null ? orgFieldMap.get(referenceOrg).toString() : referenceOrg;
            JSONObject obj = new JSONObject();
            obj.put("parseInfo", (Object)referenceOrg);
            obj.put("selectType", (Object)"2");
            obj.put("showName", (Object)showValue);
            participantModel.setReferenceOrg(obj.toJSONString());
            participantModel.setReferenceOrgShowValue(showValue);
        }
    }

    private ExtensionAttribute buildExtensionAttribute(String name, String value, String type) {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName(name);
        extensionAttribute.setValue(value);
        extensionAttribute.setType(type);
        return extensionAttribute;
    }

    protected Map<String, LocaleString> getExtractPersonItems(String entraBill, BaseElement rootElement) {
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entraBill);
        List<ComboItem> userItems = this.extractUserItemsFromEntityCache((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRelationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        HashMap<String, LocaleString> fieldMap = new HashMap<String, LocaleString>(userItems.size());
        for (IDataEntityProperty prop : mainEntity.getProperties()) {
            if (!(prop instanceof EntryProp)) continue;
            userItems.addAll(this.extractUserItemsFromEntityCache(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
        }
        Process process = null;
        if (rootElement instanceof Process) {
            process = (Process)rootElement;
        } else if (rootElement instanceof SubProcess) {
            process = (Process)((SubProcess)rootElement).getParentContainer();
        }
        List<ComboItem> personsInProcess = this.extractUserItemsFromProcess(process);
        userItems.addAll(personsInProcess);
        for (ComboItem item : userItems) {
            fieldMap.put(item.getValue(), item.getCaption());
        }
        return fieldMap;
    }

    protected List<ComboItem> extractUserItemsFromProcess(Process process) {
        ArrayList<ComboItem> userItems = new ArrayList<ComboItem>();
        if (WfUtils.isNullObject(process)) {
            return userItems;
        }
        userItems.add(new ComboItem((LocaleString)WfUtils.getPromptWordLocaleString("\u6d41\u7a0b-\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba", "AbstractPartPlugin_3", "bos-wf-formplugin"), "PROC_currentParticipant"));
        for (Macro marco : process.getMacros()) {
            if (!"user".equals(marco.getDataType())) continue;
            String name = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b-%s", (String)"AbstractPartPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), marco.getDescription());
            String value = marco.getName();
            userItems.add(new ComboItem(new LocaleString(name), "PROC_" + value));
        }
        return userItems;
    }

    protected List<ComboItem> extractUserItemsFromEntityCache(DynamicObjectType entityType, String prefix) {
        ArrayList<ComboItem> userItems = new ArrayList<ComboItem>();
        String namePrefix = prefix;
        String valuePrefix = "ENTI_";
        if (entityType instanceof EntryType) {
            namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entityType.getName() + ".";
        }
        boolean isUserProp = false;
        String refPersonType = "bos_user";
        String baseEntityId = null;
        for (IDataEntityProperty item : entityType.getProperties()) {
            String value;
            baseEntityId = null;
            isUserProp = false;
            if (item instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)item).getBaseEntityId();
            }
            if (item instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)item).getBaseEntityId();
            }
            if (!(isUserProp = WfUtils.isNotEmpty(baseEntityId) && refPersonType.contains(baseEntityId)) || USERS_NEED_IGNORE.contains(value = item.getName())) continue;
            LocaleString name = item.getDisplayName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty(orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            userItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
        return userItems;
    }

    private Map<String, LocaleString> getExtractOrgItems(String entraBill) {
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entraBill);
        List<ComboItem> fieldItems = this.extractOrgItemsFromEntityCacheForPartRole((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRolePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        HashMap<String, LocaleString> fieldMap = new HashMap<String, LocaleString>(fieldItems.size());
        for (IDataEntityProperty prop : mainEntity.getProperties()) {
            if (!(prop instanceof EntryProp)) continue;
            fieldItems.addAll(this.extractOrgItemsFromEntityCacheForPartRole(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
        }
        for (ComboItem item : fieldItems) {
            fieldMap.put(item.getId(), item.getCaption());
        }
        return fieldMap;
    }

    private Map<String, LocaleString> getExtractOrgItemsWithoutExp(String entraBill) {
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entraBill);
        List<ComboItem> fieldItems = this.extractOrgItemsFromEntityCacheForPartRole((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRolePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        HashMap<String, LocaleString> fieldMap = new HashMap<String, LocaleString>(fieldItems.size());
        for (IDataEntityProperty prop : mainEntity.getProperties()) {
            if (!(prop instanceof EntryProp)) continue;
            fieldItems.addAll(this.extractOrgItemsFromEntityCacheForPartRole(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
        }
        this.addCustomOrgItems(fieldItems);
        for (ComboItem item : fieldItems) {
            fieldMap.put(item.getValue(), item.getCaption());
        }
        return fieldMap;
    }

    private List<ComboItem> addCustomOrgItems(List<ComboItem> orgItems) {
        List<Map<String, String>> customProps = ExpressionPropUtils.getCustomPropsByType("bos_org", "bos_org");
        ArrayList<ComboItem> newOrgItems = new ArrayList<ComboItem>(orgItems);
        for (Map<String, String> prop : customProps) {
            for (ComboItem item : orgItems) {
                String name = item.getCaption().getLocaleValue();
                String value = item.getValue();
                String newName = name + "-" + prop.get("name");
                String newValue = value + "." + prop.get("number");
                newOrgItems.add(new ComboItem(new LocaleString(newName), newValue));
            }
        }
        return newOrgItems;
    }

    private void userNameFormatCompatible(JsonNode elementNode, UserTask userTask) {
        ParticipatantModel participant = userTask.getParticipant();
        if (participant != null) {
            String displayInfo = participant.getDisplayInfo();
            boolean displaySetting = participant.isDisplaySetting();
            if (!displaySetting && WfUtils.isNotEmpty(displayInfo)) {
                participant.setDisplayInfo(null);
                userTask.setParticipant(participant);
            }
        }
    }

    private void taskSubjectsCompatible(JsonNode subject, UserTask userTask) {
        JsonNode customSubject;
        if (subject != null && subject.size() > 0 && (customSubject = subject.get("customSubject")) != null) {
            ArrayList<BillSubjectModel> taskSubjects = new ArrayList<BillSubjectModel>();
            BillSubjectModel billSubjectModel = new BillSubjectModel();
            billSubjectModel.setTiming("normal");
            billSubjectModel.setType("expression");
            billSubjectModel.setCustomSubject(customSubject.textValue());
            taskSubjects.add(billSubjectModel);
            userTask.setSubject(taskSubjects);
        }
    }

    private void listenersCompatible(UserTask userTask) {
        for (ActivitiListener listener : userTask.getExecutionListeners()) {
            if (!WfUtils.isEmpty(listener.getOperation())) continue;
            listener.setOperation("normal");
        }
        for (ActivitiListener listener : userTask.getTaskListeners()) {
            if (!WfUtils.isEmpty(listener.getOperation()) || !WfUtils.isNotEmpty(listener.getNumber())) continue;
            listener.setOperation(listener.getNumber());
        }
        CirculateModel circulateModel = userTask.getCirculateModel();
        if (circulateModel != null && circulateModel.getCirculate() != null) {
            Circulate circulate = circulateModel.getCirculate();
            String trigger = circulate.getTrigger();
            if (circulateModel.isCirculateWhenMatch() && StringUtils.isBlank((CharSequence)trigger)) {
                circulate.setTrigger("start");
            }
        }
    }

    private void operationCompatible(UserTask userTask) {
        String value = userTask.getAttributeValue("operation");
        if (WfUtils.isNotEmptyString(value)) {
            block5: {
                ArrayList<DecisionOption> decisionOperations = new ArrayList<DecisionOption>();
                try {
                    ArrayNode jsonNode = (ArrayNode)new ObjectMapper().readTree(value);
                    if (jsonNode != null && jsonNode.size() > 0) {
                        int n = jsonNode.size();
                        for (int i = 0; i < n; ++i) {
                            ObjectNode obj = (ObjectNode)jsonNode.get(i);
                            DecisionOption decisionOperation = new DecisionOption();
                            decisionOperation.setName(obj.get("name").textValue());
                            decisionOperation.setNumber(obj.get("number").textValue());
                            decisionOperations.add(decisionOperation);
                        }
                        userTask.setDecisionOptions(decisionOperations);
                    }
                }
                catch (Exception e) {
                    if (!(value instanceof String)) break block5;
                    DecisionOption decisionOperation = new DecisionOption();
                    decisionOperation.setNumber(value.toString());
                    decisionOperations.add(decisionOperation);
                    userTask.setDecisionOptions(decisionOperations);
                }
            }
            userTask.removeAttribute("operation");
        }
    }

    private void setupMacro(JsonNode elementNode, BaseElement rootElement, UserTask userTask) {
        List<Macro> macros = null;
        if (rootElement instanceof Process) {
            Process process = (Process)rootElement;
            macros = BpmnModelUtil.loadDefaultNodeMacro(userTask, process.getProcessType(), this.getStencilId(userTask));
            process.getMacros().addAll(macros);
        } else if (rootElement instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)rootElement;
            macros = BpmnModelUtil.loadDefaultNodeMacro(userTask, subProcess.getSubProcessType(), this.getStencilId(userTask));
            ((Process)subProcess.getParentContainer()).getMacros().addAll(macros);
        }
        userTask.removeAttribute("macros");
    }

    @Override
    protected void disposeExtensionAttribute(ExtensionAttribute attribute, ObjectNode propertiesNode) {
        super.disposeExtensionAttribute(attribute, propertiesNode);
    }

    protected void billSettingCompatible(UserTask userTask, BaseElement rootElement) {
        if (rootElement instanceof Process) {
            BillSetting billSetting = null;
            List<DynamicModelPartial> partials = ((Process)rootElement).getDynamicModelPartial().get("billSetting");
            if (partials != null && !partials.isEmpty()) {
                for (DynamicModelPartial partial : partials) {
                    if (userTask.getNumber() == null || !userTask.getNumber().equals(partial.getFlowElement().getNumber())) continue;
                    billSetting = (BillSetting)partial.getPartial();
                    break;
                }
            }
            if (billSetting == null) {
                billSetting = new BillSetting();
                DynamicModelPartial partial = new DynamicModelPartial();
                partial.setPartial(billSetting);
                partial.setFlowElement(userTask);
                partial.setPartialPropertyName("billSetting");
                ((Process)rootElement).addDynamicModelPartial(partial);
            }
            if (WfUtils.isEmpty(billSetting.getFormKey())) {
                billSetting.setFormKey(userTask.getAttributeValue(null, FORMKEY));
            }
            if (WfUtils.isEmpty(billSetting.getMobilFormKey())) {
                billSetting.setMobilFormKey(userTask.getAttributeValue(null, MOBILFORMKEY));
            }
            userTask.setBillSetting(billSetting);
        } else if (rootElement instanceof EventSubProcess) {
            BillSetting billSetting = new BillSetting();
            if (WfUtils.isEmpty(billSetting.getFormKey())) {
                billSetting.setFormKey(userTask.getAttributeValue(null, FORMKEY));
            }
            if (WfUtils.isEmpty(billSetting.getMobilFormKey())) {
                billSetting.setMobilFormKey(userTask.getAttributeValue(null, MOBILFORMKEY));
            }
            userTask.setBillSetting(billSetting);
        }
        userTask.removeAttribute(FORMKEY, MOBILFORMKEY);
    }

    protected List<ComboItem> extractOrgItemsFromEntityCacheForPartRole(DynamicObjectType entityType, String prefix) {
        DataEntityPropertyCollection properties;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (null != entityType && null != (properties = entityType.getProperties()) && properties.size() > 0) {
            String namePrefix = prefix;
            String valuePrefix = "ENTI_";
            if (entityType instanceof EntryType) {
                namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
                valuePrefix = "ENTRY_" + entityType.getName() + ".";
            }
            String newName = null;
            String newValue = null;
            boolean isOrgPropExist = false;
            boolean isBasedataPropForOrg = false;
            boolean isBasedataPropForUser = false;
            BasedataProp itemProp = null;
            String itemPropValue = null;
            LocaleString itemPropNameLocal = null;
            String itemPropName = null;
            String orgPropName = null;
            String orgPropValue = null;
            MainEntityType mainEntityForUser = null;
            DataEntityPropertyCollection propertiesForUser = null;
            EntryType typeForUser = null;
            DataEntityPropertyCollection propertiesForUserEntry = null;
            OrgProp orgPropForUser = null;
            for (IDataEntityProperty item : properties) {
                isOrgPropExist = false;
                itemPropValue = item.getName();
                boolean bl = isBasedataPropForOrg = item instanceof BasedataProp && "bos_org".equals(((BasedataProp)item).getBaseEntityId());
                if (item instanceof OrgProp || isBasedataPropForOrg) {
                    isOrgPropExist = true;
                    orgPropName = item.getDisplayName().getLocaleValue();
                    orgPropValue = item.getName();
                    newName = namePrefix + (WfUtils.isNotEmpty(orgPropName) ? orgPropName : "");
                    newValue = valuePrefix + orgPropValue;
                } else {
                    boolean bl2 = isBasedataPropForUser = item instanceof BasedataProp && "bos_user".equals(((BasedataProp)item).getBaseEntityId());
                    if (item instanceof UserProp || isBasedataPropForUser) {
                        if (USERS_NEED_IGNORE.contains(itemPropValue)) continue;
                        itemProp = (BasedataProp)item;
                        mainEntityForUser = EntityMetadataCache.getDataEntityType((String)itemProp.getBaseEntityId());
                        if (null != mainEntityForUser && null != (propertiesForUser = mainEntityForUser.getProperties()) && propertiesForUser.size() > 0) {
                            for (IDataEntityProperty prop : propertiesForUser) {
                                if (!(prop instanceof EntryProp) || null == (typeForUser = (EntryType)((EntryProp)prop).getDynamicCollectionItemPropertyType()) || null == (propertiesForUserEntry = typeForUser.getProperties()) || propertiesForUserEntry.size() <= 0) continue;
                                for (IDataEntityProperty propForEntry : propertiesForUserEntry) {
                                    if (!(propForEntry instanceof OrgProp) || null == (orgPropForUser = (OrgProp)propForEntry)) continue;
                                    isOrgPropExist = true;
                                    orgPropName = orgPropForUser.getDisplayName().getLocaleValue();
                                    orgPropValue = typeForUser.getName() + "." + orgPropForUser.getName();
                                }
                            }
                        }
                        if (isOrgPropExist) {
                            itemPropNameLocal = item.getDisplayName();
                            itemPropName = itemPropNameLocal.getLocaleValue();
                            newName = namePrefix + (WfUtils.isNotEmpty(itemPropName) ? itemPropName : "") + '.' + (WfUtils.isNotEmpty(orgPropName) ? orgPropName : "");
                            newValue = valuePrefix + itemPropValue + '.' + orgPropValue;
                        }
                    }
                }
                if (!isOrgPropExist) continue;
                items.add(new ComboItem(new LocaleString(newName), newValue));
            }
        }
        return items;
    }

    private String formatExpression(String exp) {
        if (exp.startsWith("ENTI_")) {
            return exp.replace("ENTI_", "model.");
        }
        if (exp.startsWith("ENTRY_")) {
            return exp.replace("ENTRY_", "model.");
        }
        if (exp.startsWith("PROC_")) {
            return exp.replace("PROC_", "proc.");
        }
        return exp;
    }

    static {
        USERS_NEED_IGNORE.add("modifier");
        USERS_NEED_IGNORE.add("auditor");
    }
}

