/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.AuditTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.MultiInstanceLoopCharacteristics;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;

public class YunzhijiaTaskJsonConverter
extends AuditTaskJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        YunzhijiaTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        YunzhijiaTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("YunzhijiaTask", YunzhijiaTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(YunzhijiaTask.class, YunzhijiaTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "YunzhijiaTask";
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        BaseElement elem = super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        YunzhijiaTask task = (YunzhijiaTask)elem;
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setInputDataItem("#{participantCalc.getParticpants}");
        multiInstanceLoopCharacteristics.setElementVariable("participant");
        multiInstanceLoopCharacteristics.setLoopCardinality("#{participantCalc.getParticpantCount}");
        multiInstanceLoopCharacteristics.setSequential("serialAudit".equalsIgnoreCase(task.getSignType()));
        multiInstanceLoopCharacteristics.setCompletionCondition("#{participantCalc.hasCompleted}");
        ((YunzhijiaTask)elem).setLoopCharacteristics(multiInstanceLoopCharacteristics);
        return elem;
    }

    private MultiInstanceLoopCharacteristics parseMultiInstanceLoop(YunzhijiaTask task) {
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        if ("parallelAudit".equalsIgnoreCase(task.getSignType())) {
            multiInstanceLoopCharacteristics.setSequential(false);
        } else {
            multiInstanceLoopCharacteristics.setSequential(true);
        }
        return multiInstanceLoopCharacteristics;
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new YunzhijiaTask();
    }
}

