/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter.field;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.field.ConvertField;
import kd.bos.workflow.bpmn.converter.field.TransIgnore;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import org.apache.commons.beanutils.PropertyUtils;

public class EntityConvertField
implements ConvertField {
    protected static Log logger = LogFactory.getLog(EntityConvertField.class);
    private Object obj;
    private String name;
    private Method getMethod;
    private Method setMethod;
    private boolean ignore = false;

    public EntityConvertField(Object obj, String name) {
        this.obj = obj;
        this.name = name;
        this.init();
    }

    @Override
    public Class<?> getType() {
        return this.getMethod != null ? this.getMethod.getReturnType() : null;
    }

    private Method init() {
        if (this.getMethod == null || this.setMethod == null) {
            boolean writable;
            PropertyDescriptor prop = null;
            boolean readable = PropertyUtils.isReadable((Object)this.obj, (String)this.name);
            if (readable) {
                try {
                    prop = PropertyUtils.getPropertyDescriptor((Object)this.obj, (String)this.name);
                    this.getMethod = PropertyUtils.getReadMethod((PropertyDescriptor)prop);
                    if (this.getMethod != null && this.getMethod.getAnnotation(TransIgnore.class) != null) {
                        this.ignore = true;
                        return null;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (writable = PropertyUtils.isWriteable((Object)this.obj, (String)this.name)) {
                try {
                    if (prop == null) {
                        prop = PropertyUtils.getPropertyDescriptor((Object)this.obj, (String)this.name);
                    }
                    this.setMethod = PropertyUtils.getWriteMethod((PropertyDescriptor)prop);
                    if (this.setMethod != null && this.setMethod.getAnnotation(TransIgnore.class) != null) {
                        this.ignore = true;
                        return null;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.getMethod == null || this.setMethod == null) {
                Method[] methods;
                for (Method method : methods = this.obj.getClass().getMethods()) {
                    SimplePropertyAttribute annotation;
                    if (!ReflectUtil.isGetter(method) || (annotation = method.getAnnotation(SimplePropertyAttribute.class)) == null || !this.name.equalsIgnoreCase(annotation.name())) continue;
                    try {
                        if (method.getAnnotation(TransIgnore.class) == null) {
                            this.getMethod = method;
                            String setMethodName = "set" + Character.toTitleCase(this.name.charAt(0)) + this.name.substring(1, this.name.length());
                            this.setMethod = this.obj.getClass().getMethod(setMethodName, this.getMethod.getReturnType());
                            break;
                        }
                        this.ignore = true;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return this.getMethod;
    }

    @Override
    public void setValue(Object value) {
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(this.obj, value);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getGenericType() {
        if (this.getMethod != null) {
            return this.getMethod.getGenericReturnType();
        }
        return null;
    }

    @Override
    public boolean exist() {
        return this.getMethod != null;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }
}

