/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.define.DomainModelTypeDefiner;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.metadata.domainmodel.define.Resource;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.domain.model.StencilElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.exception.WFException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ModelConfigUtil {
    public static final String NULL_VALUE = "NULL";
    private static final String MODIFYDATE = "modifydate";
    private static final String ID = "id";
    private static final String ISV = "isv";
    private static final String ISV_KINGDEE = "kingdee";
    private static final String STENCILTYPE = "stenciltype";
    private static final String APPID = "appid";
    private static final String CLOUDID = "cloudid";
    private static final String LIFECYCLECONFIG = "lifecycleconfig";
    private static final String MANDATORY = "mandatory";
    private static final String CUSTOMRUNTIMECONFIG = "customruntimeconfig";
    private static final String STENCIL_TYPE = "stencilType";
    private static Map<String, StencilElement> stencilRelMap = new HashMap<String, StencilElement>();
    private static Set<String> stencilTypes = new HashSet<String>();
    private static Map<String, Set<String>> extendStencilTypesMap = new HashMap<String, Set<String>>();
    private static final String KEY_DYNMODELCONFIG = "dynModelConfig";
    private static final String WORKFLOW_TEMPLATE_CONFIG_FILE = "/domainmodel/product/AbstractWorkflowTemplate.xml";
    private static final String AUDITFLOW_TEMPLATE_CONFIG_FILE = "/domainmodel/product/WorkflowTemplate.xml";
    private static final String BIZFLOW_TEMPLATE_CONFIG_FILE = "/domainmodel/product/BizFlowTemplate.xml";
    private static final String EVENTFLOW_TEMPLATE_CONFIG_FILE = "/domainmodel/product/EventFlowTemplate.xml";
    private static Log log = LogFactory.getLog(ModelConfigUtil.class);

    private static Set<String> getStencilTypes(String templateFile) throws DocumentException {
        HashSet<String> types = new HashSet<String>();
        SAXReader reader = ModelConfigUtil.getSAXReader();
        Document document = reader.read(ModelConfigUtil.class.getResource(templateFile));
        Element root = document.getRootElement();
        List styles = root.selectNodes("/Styles/Style[@Id][@style]");
        if (styles != null) {
            String id = null;
            for (Node node : styles) {
                Element style;
                if (!(node instanceof Element) || (id = (style = (Element)node).attributeValue("Id")) == null || id.endsWith("Model")) continue;
                types.add(id);
            }
        }
        return types;
    }

    public static Map<String, Object> getISVModelConfig(String isv, String stencilType) {
        String modelConfig = WfCacheHelper.getISVModelConfig(isv);
        if (WfUtils.isNotEmpty(modelConfig)) {
            JSONObject config = JSON.parseObject((String)modelConfig);
            return config.getJSONObject(stencilType);
        }
        String selectFields = "stenciltype,customdefconfig";
        QFilter[] filters = new QFilter[]{new QFilter(ISV, "=", (Object)isv)};
        DynamicObjectCollection configCollection = QueryServiceHelper.query((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])filters);
        if (configCollection != null && !configCollection.isEmpty()) {
            JSONObject isvConfigs = new JSONObject();
            for (DynamicObject customConfig : configCollection) {
                modelConfig = customConfig.getString("customdefconfig");
                if (WfUtils.isEmpty(modelConfig)) continue;
                JSONObject config = JSON.parseObject((String)modelConfig);
                isvConfigs.put(customConfig.getString(STENCILTYPE), (Object)config);
            }
            WfCacheHelper.putISVModelConfig(isv, JSON.toJSONString((Object)isvConfigs));
            return isvConfigs.getJSONObject(stencilType);
        }
        return null;
    }

    public static List<ActivitiListener> getListenersConfig(String entityNumber, String stencilType, boolean isTaskListener, Map<String, Map<String, UserTask>> configCache) {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        UserTask configTask = ModelConfigUtil.getConfigTask(entityNumber, stencilType, isTaskListener, configCache, listeners);
        if (configTask != null) {
            ModelConfigUtil.addUniqueListeners(listeners, isTaskListener ? configTask.getTaskListeners() : configTask.getExecutionListeners());
        }
        return listeners;
    }

    public static String getFormatRecordsPlugin(String stencilType, Map<String, Map<String, UserTask>> configCache) {
        UserTask configTask = ModelConfigUtil.getConfigTask(null, stencilType, false, configCache, new ArrayList<ActivitiListener>());
        if (configTask != null) {
            return configTask.getFlowRecordsFormatter();
        }
        return null;
    }

    private static UserTask getConfigTask(String entityNumber, String stencilType, boolean isTaskListener, Map<String, Map<String, UserTask>> configCache, List<ActivitiListener> listeners) {
        String updateTime;
        UserTask configTask = null;
        String builtInKey = ModelConfigUtil.getBuiltInDynConfigKey();
        Map<String, UserTask> dynConfig = configCache.get(builtInKey);
        if (dynConfig == null) {
            dynConfig = ModelConfigUtil.getBuiltInDynModelConfig();
            configCache.put(builtInKey, dynConfig);
            log.debug("@-$-@\uff1a\u9996\u6b21\u83b7\u53d6\u5185\u7f6e\u914d\u7f6e\uff01");
        }
        if ((configTask = dynConfig.get(stencilType)) == null) {
            configTask = ModelConfigUtil.getDynModelConfig(dynConfig, stencilType);
            if (configTask != null) {
                dynConfig.put(stencilType, configTask);
                log.debug("@-$-@\uff1a\u83b7\u53d6\u5185\u7f6e " + stencilType + " \u914d\u7f6e\uff01");
            } else {
                log.debug(String.format("@-$-@\uff1a%s \u8282\u70b9\u6ca1\u6709\u9ed8\u8ba4\u76d1\u542c\uff01", stencilType));
            }
        }
        if (configTask != null) {
            listeners.addAll(isTaskListener ? configTask.getTaskListeners() : configTask.getExecutionListeners());
        }
        if (entityNumber == null) {
            return configTask;
        }
        String appId = WfCacheHelper.getAppIdByEntityNumber(entityNumber);
        String configKey = ModelConfigUtil.getAppDynConfigKey(appId);
        if (appId == null) {
            return configTask;
        }
        String mandatoryKey = ModelConfigUtil.getMandatoryDynConfigKey(appId);
        Map<String, UserTask> mandatoryConfig = configCache.get(mandatoryKey);
        if (mandatoryConfig == null) {
            mandatoryConfig = ModelConfigUtil.getMandatoryDynModelConfig(appId);
            configCache.put(mandatoryKey, mandatoryConfig);
            log.debug("@-$-@\uff1a\u52a0\u8f7d\u5fc5\u9009\u914d\u7f6e\u5e76\u8bbe\u7f6e\u5230\u7f13\u5b58\u4e2d\u3002");
        }
        if (!mandatoryConfig.isEmpty()) {
            String typeKey = String.format("%s_", stencilType);
            for (Map.Entry<String, UserTask> entry : mandatoryConfig.entrySet()) {
                String key = entry.getKey();
                UserTask config = entry.getValue();
                if (!key.startsWith(typeKey) || config == null) continue;
                ModelConfigUtil.addUniqueListeners(listeners, isTaskListener ? config.getTaskListeners() : config.getExecutionListeners());
            }
        }
        if ((updateTime = WfCacheHelper.getDynModelConfig(configKey, stencilType)) == null) {
            configTask = ModelConfigUtil.getDynModelConfig(appId, stencilType);
            WfCacheHelper.putDynModelConfig(configKey, stencilType, configTask.getAttributeValue(MODIFYDATE));
        } else {
            dynConfig = configCache.get(configKey);
            if (dynConfig == null) {
                log.debug(String.format("@-$-@\uff1a[\u5b9e\u4f8b\u7f13\u5b58]\u9996\u6b21\u83b7\u53d6 %s - %s \u914d\u7f6e\uff01", appId, stencilType));
                dynConfig = ModelConfigUtil.getDynModelConfig(appId);
                configCache.put(configKey, dynConfig);
                configTask = dynConfig.get(stencilType);
            } else {
                configTask = dynConfig.get(stencilType);
                if (configTask != null && updateTime.equals(configTask.getAttributeValue(MODIFYDATE))) {
                    log.debug(String.format("@-$-@\uff1a \u4ece[\u5b9e\u4f8b\u7f13\u5b58]\u4e2d\u83b7\u53d6%s - %s \u914d\u7f6e\u6210\u529f\uff01", appId, stencilType));
                } else {
                    configTask = ModelConfigUtil.getDynModelConfig(appId, stencilType);
                    dynConfig.put(stencilType, configTask);
                    log.debug(String.format("@-$-@\uff1a %s - %s \u914d\u7f6e\u6700\u540e\u4fee\u6539\u65f6\u95f4\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u91cd\u65b0\u7f13\u5b58\uff01", appId, stencilType));
                }
            }
        }
        return configTask;
    }

    private static UserTask getDynModelConfig(Map<String, UserTask> configMap, String stencilType) {
        UserTask task = configMap.get(stencilType);
        if (task != null) {
            return task;
        }
        if (stencilRelMap.isEmpty()) {
            ModelConfigUtil.initStencilRelationMap();
        }
        return ModelConfigUtil.getLatestParentDynConfig(configMap, stencilType);
    }

    public static Set<String> getBuiltInStencilTypes() {
        if (stencilTypes.isEmpty()) {
            ModelConfigUtil.initBuiltInStencilTypes();
        }
        return stencilTypes;
    }

    private static synchronized void initBuiltInStencilTypes() {
        try {
            stencilTypes.addAll(ModelConfigUtil.getStencilTypes(WORKFLOW_TEMPLATE_CONFIG_FILE));
            stencilTypes.addAll(ModelConfigUtil.getStencilTypes(AUDITFLOW_TEMPLATE_CONFIG_FILE));
            stencilTypes.addAll(ModelConfigUtil.getStencilTypes(BIZFLOW_TEMPLATE_CONFIG_FILE));
            stencilTypes.addAll(ModelConfigUtil.getStencilTypes(EVENTFLOW_TEMPLATE_CONFIG_FILE));
        }
        catch (Exception e) {
            throw new WFException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5185\u7f6e\u8282\u70b9\u7c7b\u578b\u5931\u8d25\u3002", (String)"ModelConfigUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), e);
        }
    }

    public static Set<String> getExtendedStencilTypes(String modelId) {
        if (extendStencilTypesMap.isEmpty()) {
            ModelConfigUtil.initExtendStencilTypesMap();
        }
        return extendStencilTypesMap.get(modelId);
    }

    public static Set<String> getAllExtendedStencilTypes() {
        if (extendStencilTypesMap.isEmpty()) {
            ModelConfigUtil.initExtendStencilTypesMap();
        }
        HashSet<String> types = new HashSet<String>();
        if (!extendStencilTypesMap.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : extendStencilTypesMap.entrySet()) {
                types.addAll((Collection<String>)entry.getValue());
            }
        }
        return types;
    }

    private static synchronized void initExtendStencilTypesMap() {
        String[] modelIds;
        String extModel = GraphCodecUtils.getExtendedModel("WorkflowModel");
        if (extModel == null) {
            log.debug("no extModel! init finish!");
            return;
        }
        for (String modelId : modelIds = extModel.split(";")) {
            DomainModelType domainModel = GraphCodecUtils.getDomainType(modelId);
            if (domainModel == null) {
                log.debug(String.format("%s model can not found!", modelId));
                continue;
            }
            Map elements = domainModel.getElementTypes();
            if (elements == null || elements.isEmpty()) {
                log.debug(String.format("%s model no elements!", modelId));
                continue;
            }
            extendStencilTypesMap.put(modelId, elements.keySet());
        }
    }

    public static Map<String, UserTask> getBuiltInDynModelConfig() {
        Map<String, UserTask> map = ModelConfigUtil.getDynModelConfig(new QFilter[]{new QFilter("builtin", "=", (Object)Boolean.TRUE), new QFilter(ISV, "=", (Object)ISV_KINGDEE)});
        if (stencilRelMap.isEmpty()) {
            ModelConfigUtil.initStencilRelationMap();
        }
        ConcurrentHashMap<String, UserTask> configMap = new ConcurrentHashMap<String, UserTask>();
        UserTask task = null;
        UserTask parent = null;
        String stencilType = null;
        for (Map.Entry<String, UserTask> entry : map.entrySet()) {
            String key = entry.getKey();
            task = entry.getValue();
            stencilType = key;
            ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>(16);
            ArrayList<ActivitiListener> taskListeners = new ArrayList<ActivitiListener>(16);
            while ((parent = ModelConfigUtil.getLatestParentDynConfig(map, stencilType)) != null) {
                ArrayList<ActivitiListener> tempExecutionListeners = new ArrayList<ActivitiListener>(parent.getExecutionListeners());
                ModelConfigUtil.addUniqueListeners(tempExecutionListeners, executionListeners);
                executionListeners = tempExecutionListeners;
                ArrayList<ActivitiListener> tempTaskListeners = new ArrayList<ActivitiListener>(parent.getTaskListeners());
                ModelConfigUtil.addUniqueListeners(tempTaskListeners, taskListeners);
                taskListeners = tempTaskListeners;
                stencilType = parent.getType();
            }
            ModelConfigUtil.addUniqueListeners(executionListeners, task.getExecutionListeners());
            task.setExecutionListeners(executionListeners);
            ModelConfigUtil.addUniqueListeners(taskListeners, task.getTaskListeners());
            task.setTaskListeners(taskListeners);
            configMap.put(key, task);
        }
        return configMap;
    }

    private static UserTask getLatestParentDynConfig(Map<String, UserTask> configMap, String stencilType) {
        UserTask task = null;
        StencilElement stencil = null;
        String type = stencilType;
        while (task == null && (stencil = stencilRelMap.get(type)) != null && WfUtils.isNotEmpty(type = stencil.getParentId())) {
            task = configMap.get(type);
        }
        return task;
    }

    public static Map<String, UserTask> getBuiltInDynModelConfig(String app) {
        QFilter[] filters = new QFilter[]{new QFilter(APPID, "=", (Object)app), new QFilter("builtin", "=", (Object)"1")};
        return ModelConfigUtil.getDynModelConfig(filters);
    }

    private static Map<String, UserTask> getDynModelConfig(QFilter[] filters) {
        String selectFields = "stenciltype,customruntimeconfig,modifydate";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])filters);
        ConcurrentHashMap<String, UserTask> map = new ConcurrentHashMap<String, UserTask>();
        if (collection != null && !collection.isEmpty()) {
            String stencilType = null;
            for (DynamicObject dynObj : collection) {
                stencilType = dynObj.getString(STENCILTYPE);
                String runtimeConfig = dynObj.getString(CUSTOMRUNTIMECONFIG);
                if (WfUtils.isNotEmpty(runtimeConfig)) {
                    map.put(stencilType, ModelConfigUtil.createDynConfigByDynObj(stencilType, dynObj));
                    continue;
                }
                log.debug(String.format("%s \u7684\u81ea\u5b9a\u4e49\u8fd0\u884c\u65f6\u914d\u7f6e\u4e3a\u7a7a\uff01", stencilType));
            }
        }
        return map;
    }

    private static UserTask getUserTask(String stencilType) {
        UserTask task = new UserTask();
        task.setType(stencilType);
        ExtensionAttribute date = new ExtensionAttribute();
        date.setName(MODIFYDATE);
        date.setValue(NULL_VALUE);
        task.addAttribute(date);
        return task;
    }

    private static UserTask createDynConfigByDynObj(String stencilType, DynamicObject dynObj) {
        String runConfig;
        if (dynObj == null) {
            return ModelConfigUtil.getUserTask(stencilType);
        }
        UserTask task = new UserTask();
        task.setType(stencilType);
        ExtensionAttribute date = new ExtensionAttribute();
        date.setName(MODIFYDATE);
        Timestamp time = (Timestamp)dynObj.get(MODIFYDATE);
        if (time != null) {
            date.setValue(new Date(time.getTime()).toString());
            task.addAttribute(date);
        }
        if (WfUtils.isNotEmpty(runConfig = dynObj.getString(CUSTOMRUNTIMECONFIG))) {
            JSONObject config = (JSONObject)SerializationUtils.fromJsonString((String)runConfig, JSONObject.class);
            ModelConfigUtil.parseListeners(task, config);
        }
        return task;
    }

    private static void parseListeners(UserTask task, JSONObject config) {
        JSONArray taskListeners;
        JSONObject properties = config.getJSONObject("properties");
        JSONArray executionListeners = properties.getJSONArray("executionListeners");
        if (executionListeners != null && !executionListeners.isEmpty()) {
            task.getExecutionListeners().addAll(ModelConfigUtil.getListenersFromJSON(executionListeners));
        }
        if ((taskListeners = properties.getJSONArray("taskListeners")) != null && !taskListeners.isEmpty()) {
            task.getTaskListeners().addAll(ModelConfigUtil.getListenersFromJSON(taskListeners));
        }
        task.setFlowRecordsFormatter(properties.getString("flowRecordsFormatter"));
    }

    private static List<ActivitiListener> getListenersFromJSON(JSONArray listeners) {
        int size = listeners.size();
        ArrayList<ActivitiListener> activitiListeners = new ArrayList<ActivitiListener>(size);
        JSONObject json = null;
        ActivitiListener listener = null;
        for (int i = 0; i < size; ++i) {
            json = listeners.getJSONObject(i);
            listener = new ActivitiListener();
            listener.setEvent(json.getString("event"));
            listener.setImplementationType(json.getString("implementationtype"));
            listener.setImplementation(json.getString("implementation"));
            String ud = json.getString("userDefinied");
            if (WfUtils.isNotEmpty(ud) && "true".equalsIgnoreCase(ud)) {
                listener.setUserDefinied(Boolean.TRUE);
            }
            activitiListeners.add(listener);
        }
        return activitiListeners;
    }

    public static Map<String, UserTask> getDynModelConfig(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter(APPID, "=", (Object)appId)};
        return ModelConfigUtil.getDynModelConfig(filters);
    }

    private static UserTask getDynModelConfig(String appId, String stencilType) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String isv = ISVService.getISVInfo().getId();
        String cloudId = appInfo.getCloudId();
        String appNumber = appInfo.getNumber();
        QFilter[] filters = new QFilter[]{new QFilter(STENCILTYPE, "=", (Object)stencilType), new QFilter(APPID, "in", (Object)new String[]{"*", appNumber}).or(new QFilter(CLOUDID, "like", (Object)String.format("%%%s%%", cloudId))), new QFilter(MANDATORY, "=", (Object)false)};
        String selectFields = "appid,cloudid,stenciltype,customruntimeconfig,modifydate,isv";
        DynamicObject config = null;
        DynamicObject optimalConfig = null;
        DynamicObject sameAppConfig = null;
        DynamicObject sameCloudConfig = null;
        DynamicObject currencyConfig = null;
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])filters, (String)"id asc");
        if (configs != null && !configs.isEmpty()) {
            for (DynamicObject cfg : configs) {
                String number = cfg.getString(APPID);
                String cid = cfg.getString(CLOUDID);
                if (appNumber.equals(number) && cid.contains(cloudId)) {
                    optimalConfig = cfg;
                    continue;
                }
                if (appNumber.equals(number)) {
                    sameAppConfig = cfg;
                    continue;
                }
                if (cid.contains(cloudId)) {
                    sameCloudConfig = cfg;
                    continue;
                }
                if (isv == null || !isv.equals(cfg.getString(ISV))) continue;
                currencyConfig = cfg;
            }
        }
        config = optimalConfig != null ? optimalConfig : (sameAppConfig != null ? sameAppConfig : (sameCloudConfig != null ? sameCloudConfig : currencyConfig));
        return ModelConfigUtil.createDynConfigByDynObj(stencilType, config);
    }

    public static Map<String, JSONObject> getStencilsUiConfig() {
        HashMap<String, JSONObject> uiConfigs = new HashMap<String, JSONObject>();
        String selectFields = "stenciltype,customuiconfig";
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"wf_dynmodelconfig", (String)selectFields, null);
        for (DynamicObject config : configs) {
            String uiConfig = config.getString("customuiconfig");
            if (!WfUtils.isNotEmpty(uiConfig)) continue;
            uiConfigs.put(config.getString(STENCILTYPE), JSON.parseObject((String)uiConfig));
        }
        return uiConfigs;
    }

    public static JSONObject getStencilsLifecycleConfig(String stencilType, String entityId) {
        QFilter[] filters = new QFilter[]{new QFilter(STENCILTYPE, "=", (Object)stencilType), new QFilter(ISV, "=", (Object)ISV_KINGDEE)};
        String selectFields = String.format("%s,%s,%s", APPID, CLOUDID, LIFECYCLECONFIG);
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])filters);
        if (configs == null || configs.isEmpty()) {
            return null;
        }
        String appId = MetadataDao.getAppIdByFormId((String)entityId);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        if (appInfo == null) {
            return null;
        }
        String configAppId = null;
        String appLifecycleConfig = null;
        String wfsLifecycleConfig = null;
        String cloudLifecycleConfig = null;
        String cloudId = appInfo.getCloudId();
        String appNumber = appInfo.getNumber();
        for (DynamicObject config : configs) {
            String aid = config.getString(APPID);
            String cid = config.getString(CLOUDID);
            String lifecycleConfig = config.getString(LIFECYCLECONFIG);
            if ("18Y30L1D2HS4".equals(cid)) {
                wfsLifecycleConfig = lifecycleConfig;
            }
            if (cid.contains(cloudId) && WfUtils.isEmpty(aid)) {
                cloudLifecycleConfig = lifecycleConfig;
            }
            if (!cid.contains(cloudId) || !WfUtils.isNotEmpty(appNumber) || !appNumber.equals(aid)) continue;
            configAppId = aid;
            appLifecycleConfig = lifecycleConfig;
        }
        if (WfUtils.isEmpty(appLifecycleConfig)) {
            appLifecycleConfig = cloudLifecycleConfig;
        }
        if (WfUtils.isEmpty(appLifecycleConfig)) {
            appLifecycleConfig = wfsLifecycleConfig;
        }
        if (WfUtils.isNotEmpty(appLifecycleConfig)) {
            JSONObject config = JSON.parseObject(appLifecycleConfig);
            config.put("appId", configAppId);
            return config;
        }
        return null;
    }

    private static void initWorkflowStencilRelation(Map<String, StencilElement> stencilMap) {
        try {
            ModelConfigUtil.getStencilRelationFromURL(ModelConfigUtil.class.getResource(WORKFLOW_TEMPLATE_CONFIG_FILE), stencilMap);
        }
        catch (Exception e) {
            log.error(String.format("\u89e3\u6790%s\u51fa\u9519\uff1a%s", WORKFLOW_TEMPLATE_CONFIG_FILE, WfUtils.getExceptionStacktrace(e)));
        }
        try {
            ModelConfigUtil.getStencilRelationFromURL(ModelConfigUtil.class.getResource(AUDITFLOW_TEMPLATE_CONFIG_FILE), stencilMap);
        }
        catch (Exception e) {
            log.error(String.format("\u89e3\u6790%s\u51fa\u9519\uff1a%s", AUDITFLOW_TEMPLATE_CONFIG_FILE, WfUtils.getExceptionStacktrace(e)));
        }
        try {
            ModelConfigUtil.getStencilRelationFromURL(ModelConfigUtil.class.getResource(BIZFLOW_TEMPLATE_CONFIG_FILE), stencilMap);
        }
        catch (Exception e) {
            log.error(String.format("\u89e3\u6790%s\u51fa\u9519\uff1a%s", BIZFLOW_TEMPLATE_CONFIG_FILE, WfUtils.getExceptionStacktrace(e)));
        }
    }

    public static String getInheritStencilType(String stencilId) {
        ModelConfigUtil.initStencilRelationMap();
        StencilElement stencil = stencilRelMap.get(stencilId);
        if (stencil != null) {
            return stencil.getParentId();
        }
        return null;
    }

    public static List<StencilElement> getAllInheritedStencil(String stencilId, boolean includeSelf) {
        ModelConfigUtil.initStencilRelationMap();
        StencilElement stencil = stencilRelMap.get(stencilId);
        if (stencil != null) {
            ArrayList<StencilElement> stencils = new ArrayList<StencilElement>();
            if (includeSelf) {
                stencils.add(stencil);
            }
            stencils.addAll(stencil.getOffspring());
            return stencils;
        }
        return null;
    }

    private static synchronized void initStencilRelationMap() {
        if (stencilRelMap.isEmpty()) {
            ModelConfigUtil.initWorkflowStencilRelation(stencilRelMap);
            String extModel = GraphCodecUtils.getExtendedModel("WorkflowModel");
            if (extModel != null) {
                String[] modelIds;
                for (String modelId : modelIds = extModel.split(";")) {
                    ModelConfigUtil.getModelStencilRelation(modelId, stencilRelMap);
                }
            }
        }
    }

    private static Map<String, StencilElement> getModelStencilRelation(String modelType, Map<String, StencilElement> stencilMap) {
        HashMap<String, StencilElement> rel = new HashMap<String, StencilElement>();
        if (WfUtils.isEmpty(modelType)) {
            return rel;
        }
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(DomainModelTypeDefiner.class));
        dts.add(OrmUtils.getDataEntityType(Resource.class));
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        URL url = DomainModelTypeDefiner.class.getResource("/domainmodel/product/" + modelType + ".model");
        if (url == null) {
            return rel;
        }
        DomainModelTypeDefiner md = (DomainModelTypeDefiner)ser.deserialize(url, null);
        String modelPath = url.getProtocol() + ":" + url.getPath();
        modelPath = modelPath.substring(0, modelPath.lastIndexOf(47) + 1);
        String path = null;
        for (Resource res : md.getElementResources()) {
            path = modelPath + res.getFileName();
            rel.putAll(ModelConfigUtil.getStencilRelationFromResourceXML(path, stencilMap));
        }
        return rel;
    }

    private static Map<String, StencilElement> getStencilRelationFromResourceXML(String tplResPath, Map<String, StencilElement> stencilMap) {
        try {
            return ModelConfigUtil.getStencilRelationFromURL(new URL(tplResPath), stencilMap);
        }
        catch (Exception e) {
            log.error(String.format("\u89e3\u6790%s\u51fa\u9519\uff1a%s", tplResPath, WfUtils.getExceptionStacktrace(e)));
            return new HashMap<String, StencilElement>();
        }
    }

    private static Map<String, StencilElement> getStencilRelationFromURL(URL url, Map<String, StencilElement> stencilMap) throws DocumentException {
        HashMap<String, StencilElement> rel = new HashMap<String, StencilElement>();
        SAXReader reader = ModelConfigUtil.getSAXReader();
        Document document = reader.read(url);
        Element root = document.getRootElement();
        List styles = root.selectNodes("/Styles/Style[@Id][@style]");
        if (styles != null) {
            Node name = null;
            String id = null;
            String parentId = null;
            StencilElement stencil = null;
            for (Node node : styles) {
                if (!(node instanceof Element)) continue;
                Element style = (Element)node;
                id = style.attributeValue("Id");
                parentId = style.attributeValue("style");
                stencil = new StencilElement(id, parentId);
                rel.put(id, stencil);
                name = style.selectSingleNode(".//Name");
                if (name != null) {
                    stencil.setName(name.getText());
                    stencilMap.put(stencil.getId(), stencil);
                    ModelConfigUtil.updateParentStencilOffspring(stencil, stencilMap.get(stencil.getParentId()), stencilMap);
                    continue;
                }
                if (stencilMap.get(stencil.getId()) != null) continue;
                stencilMap.put(stencil.getId(), stencil);
            }
        }
        return rel;
    }

    private static void updateParentStencilOffspring(StencilElement stencil, StencilElement parent, Map<String, StencilElement> stencilMap) {
        if (parent != null && parent.getName() != null) {
            parent.getOffspring().add(stencil);
            ModelConfigUtil.updateParentStencilOffspring(stencil, stencilMap.get(parent.getParentId()), stencilMap);
        }
    }

    public static String getExtendNodeInheritStencilType(String stencilId) {
        String extModel = GraphCodecUtils.getExtendedModel("WorkflowModel");
        if (extModel != null) {
            String[] modelIds = extModel.split(";");
            String type = null;
            for (String modelId : modelIds) {
                type = ModelConfigUtil.getInheritStencilTypeByModelId(modelId, stencilId);
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    private static String getInheritStencilTypeByModelId(String modelId, String stencilId) {
        try {
            DomainModelType domainType = DomainModelTypeFactory.getDomainModelType((String)modelId, (boolean)true);
            ElementType elementType = domainType.getElementType(stencilId);
            if (elementType == null) {
                return null;
            }
            List properties = elementType.getProperties();
            for (Property property : properties) {
                if (!STENCIL_TYPE.equals(property.getPropertyName())) continue;
                return property.getName().toString();
            }
        }
        catch (KDException e) {
            log.error(String.format("getDomainModelType from %s error! %s", modelId, e.getMessage()));
        }
        return null;
    }

    public static void addUniqueListeners(List<ActivitiListener> activitiListeners, List<ActivitiListener> listeners) {
        if (activitiListeners == null || listeners == null) {
            return;
        }
        ActivitiListener listener = null;
        for (ActivitiListener activitiListener : activitiListeners) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                listener = listeners.get(i);
                if (listener != null && (!listener.getEvent().equals(activitiListener.getEvent()) || !listener.getImplementationType().equals(activitiListener.getImplementationType()) || !listener.getImplementation().equals(activitiListener.getImplementation()))) continue;
                listeners.remove(i);
            }
        }
        activitiListeners.addAll(listeners);
    }

    public static Map<String, Object> getISVModelPropertiesConfig(String stencilType) {
        String isv = ISVService.getISVInfo().getId();
        Map<String, Object> isvConfig = ModelConfigUtil.getISVModelConfig(isv, stencilType);
        Map isvPropsConfig = null;
        if (isvConfig != null) {
            isvPropsConfig = (Map)isvConfig.get("properties");
        }
        return isvPropsConfig;
    }

    private static SAXReader getSAXReader() {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException e) {
            log.error("XXE: " + WfUtils.getExceptionStacktrace(e));
        }
        return reader;
    }

    private static Map<String, UserTask> getMandatoryDynModelConfig(String appId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String isv = ISVService.getISVInfo().getId();
        QFilter[] filters = new QFilter[]{new QFilter(MANDATORY, "=", (Object)true), new QFilter(ISV, "in", (Object)new String[]{ISV_KINGDEE, isv}), new QFilter(APPID, "in", (Object)new String[]{"*", appInfo.getNumber()}).or(new QFilter(CLOUDID, "like", (Object)String.format("%%%s%%", appInfo.getCloudId())))};
        LinkedHashMap<String, UserTask> result = new LinkedHashMap<String, UserTask>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"wf_dynmodelconfig", (String)"id,stenciltype,customruntimeconfig,modifydate,isv", (QFilter[])filters, (String)"id asc");
        if (collection == null || collection.isEmpty()) {
            return result;
        }
        ArrayList<DynamicObject> isvConfigs = new ArrayList<DynamicObject>(collection.size());
        for (DynamicObject config : collection) {
            String isvValue = config.getString(ISV);
            if (ISV_KINGDEE.equals(isvValue)) {
                String runtimeConfig = config.getString(CUSTOMRUNTIMECONFIG);
                if (!WfUtils.isNotEmpty(runtimeConfig)) continue;
                String stencilType = config.getString(STENCILTYPE);
                String typeKey = String.format("%s_%s", stencilType, config.get(ID));
                result.put(typeKey, ModelConfigUtil.createDynConfigByDynObj(stencilType, config));
                continue;
            }
            isvConfigs.add(config);
        }
        for (DynamicObject config : isvConfigs) {
            String runtimeConfig = config.getString(CUSTOMRUNTIMECONFIG);
            if (!WfUtils.isNotEmpty(runtimeConfig)) continue;
            String stencilType = config.getString(STENCILTYPE);
            String typeKey = String.format("%s_%s", stencilType, config.get(ID));
            result.put(typeKey, ModelConfigUtil.createDynConfigByDynObj(stencilType, config));
        }
        return result;
    }

    private static String getMandatoryDynConfigKey(String appId) {
        return WfCacheHelper.getWholeKey(KEY_DYNMODELCONFIG, MANDATORY, appId);
    }

    public static String getBuiltInDynConfigKey() {
        return WfCacheHelper.getWholeKey(KEY_DYNMODELCONFIG, "builtIn");
    }

    public static String getEntityNumberKey(String entityNumber) {
        return WfCacheHelper.getWholeKey(KEY_DYNMODELCONFIG, entityNumber);
    }

    public static String getAppDynConfigKey(String appId) {
        return WfCacheHelper.getWholeKey(KEY_DYNMODELCONFIG, appId);
    }

    public static String getModelConfigFormatter(String configType, String formatterKey) {
        String formmaterValue = WfCacheHelper.getModelConfigFormatter(configType, formatterKey);
        if (WfUtils.isNotEmpty(formmaterValue)) {
            return formmaterValue;
        }
        String selectFields = "stenciltype,customruntimeconfig";
        QFilter qFilter = new QFilter(STENCILTYPE, "=", (Object)configType);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null && dynamicObject.getString(CUSTOMRUNTIMECONFIG) != null) {
            JSONObject config = (JSONObject)SerializationUtils.fromJsonString((String)dynamicObject.getString(CUSTOMRUNTIMECONFIG), JSONObject.class);
            JSONObject properties = config.getJSONObject("properties");
            formmaterValue = properties.getString(formatterKey);
            if (WfUtils.isEmpty(formmaterValue)) {
                return null;
            }
            WfCacheHelper.putModelConfigFormatter(configType, formatterKey, formmaterValue);
            return formmaterValue;
        }
        return null;
    }
}

