/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.diff.IDiff;
import kd.bos.workflow.bpmn.diff.comparator.IntegerValueComparator;
import kd.bos.workflow.bpmn.diff.comparator.StringAttributeComparator;
import kd.bos.workflow.bpmn.diff.enumeration.NodeType;
import kd.bos.workflow.bpmn.diff.patch.IPatch;
import kd.bos.workflow.bpmn.diff.pointer.json.JsonPointer;
import kd.bos.workflow.bpmn.diff.processor.DiffOperation;
import kd.bos.workflow.bpmn.diff.processor.IDiffProcessor;
import kd.bos.workflow.bpmn.diff.processor.JsonDiffProcessor;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.diff.util.JacksonUtils;
import kd.bos.workflow.bpmn.diff.util.JsonEquals;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import org.apache.log4j.Logger;

public class JsonDiff
implements IDiff<JsonNode> {
    private static final String FORMAT_TPL = "[%s:%s]";
    private final Equivalence<JsonNode> EQUIVALENCE = JsonEquals.getInstance();
    private StringAttributeComparator comparator = new StringAttributeComparator();
    private Logger log = Logger.getLogger(this.getClass());
    private Set<String> conditionTypes = ConditionalRuleType.getTypes();

    @Override
    public JsonNode applyPatch(JsonNode source, JsonNode patch) {
        if (!source.isObject() || !patch.isObject()) {
            return source;
        }
        return this.mergeObjectNode((ObjectNode)source, (ObjectNode)patch);
    }

    private boolean isBasicArray(ArrayNode patch) {
        JsonNode item = patch.get(0);
        JsonNode keyNode = item.get("_hashcode_");
        if (keyNode != null && !keyNode.isNull()) {
            return true;
        }
        keyNode = item.get("_value_");
        return keyNode != null && !keyNode.isNull();
    }

    private boolean hasClearAddAction(JsonNode node) {
        JsonNode keyNode = node.get("_action_");
        return keyNode != null && "clear-add".equals(keyNode.textValue());
    }

    private ArrayNode mergeArrayNode(String arrKey, ArrayNode source, ArrayNode patch) {
        if (patch.size() == 0) {
            return source;
        }
        if (this.isBasicArray(patch)) {
            return this.mergeBaseEltArrayNode(source, patch);
        }
        if (this.hasClearAddAction(patch.get(0))) {
            return this.mergeClearActionArrayNode(source, patch);
        }
        String uniqueKey = BpmnDiffUtil.getListElementUniqueKey(arrKey);
        if (uniqueKey == null) {
            return source;
        }
        uniqueKey = BpmnDiffUtil.getFormatUniqueKey(uniqueKey);
        JsonNode node = null;
        HashMap<String, ObjectNode> sourceMap = new HashMap<String, ObjectNode>();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        Iterator iterator = source.iterator();
        JsonNode uniqueValue = null;
        String text = null;
        int index = 0;
        while (iterator.hasNext()) {
            node = (JsonNode)iterator.next();
            uniqueValue = node.get(uniqueKey);
            text = uniqueValue == null || uniqueValue.isNull() ? BpmnDiffUtil.getUniqueKeyValue(node, uniqueKey) : uniqueValue.asText();
            sourceMap.put(text, (ObjectNode)node);
            indexMap.put(text, index++);
        }
        ArrayList<Integer> removed = new ArrayList<Integer>();
        ObjectNode sourceNode = null;
        iterator = patch.iterator();
        JsonNode action = null;
        while (iterator.hasNext()) {
            node = (JsonNode)iterator.next();
            action = node.get("_action_");
            uniqueValue = node.get(uniqueKey);
            if (action != null && "remove".equals(action.asText())) {
                Integer idx = (Integer)indexMap.get(uniqueValue.asText());
                if (idx != null) {
                    removed.add(idx);
                    continue;
                }
                this.log.info((Object)String.format("%s\u4e2d\u672a\u627e\u5230\u7d22\u5f15\u4e3a%s\u7684\u5143\u7d20\uff01[%s]", source, idx, uniqueValue));
                continue;
            }
            if (uniqueValue != null) {
                sourceNode = (ObjectNode)sourceMap.get(uniqueValue.asText());
                if (sourceNode != null) {
                    JsonNode independent = node.get("_independent_");
                    if (independent != null && independent.booleanValue()) {
                        source.set(((Integer)indexMap.get(uniqueValue.asText())).intValue(), node);
                        continue;
                    }
                    this.mergeObjectNode(sourceNode, (ObjectNode)node);
                    continue;
                }
                if (node.isObject()) {
                    if (uniqueKey.indexOf(45) > -1) {
                        ObjectNode copyNode = JacksonUtils.copyObjectNode((ObjectNode)node);
                        copyNode.remove(uniqueKey);
                        source.add((JsonNode)copyNode);
                        continue;
                    }
                    if (node.has("_inherit_")) continue;
                    source.add(node);
                    continue;
                }
                source.add(node);
                continue;
            }
            source.add(node);
        }
        if (!removed.isEmpty()) {
            Collections.sort(removed, new IntegerValueComparator());
            for (Integer idx : removed) {
                source.remove(idx.intValue());
            }
        }
        return source;
    }

    private ArrayNode mergeClearActionArrayNode(ArrayNode source, ArrayNode patch) {
        source.removeAll();
        JsonNode node2 = null;
        for (JsonNode node2 : patch) {
            if (!(node2 instanceof ObjectNode)) continue;
            ((ObjectNode)node2).remove("_action_");
            source.add(node2);
        }
        return source;
    }

    private ArrayNode mergeBaseEltArrayNode(ArrayNode source, ArrayNode patch) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        Iterator iterator = source.iterator();
        JsonNode node = null;
        String text = null;
        int index = 0;
        while (iterator.hasNext()) {
            node = (JsonNode)iterator.next();
            text = String.valueOf(node.hashCode());
            indexMap.put(text, index++);
        }
        iterator = patch.iterator();
        ArrayList<Integer> removed = new ArrayList<Integer>();
        JsonNode action = null;
        JsonNode uniqueValue = null;
        while (iterator.hasNext()) {
            node = (JsonNode)iterator.next();
            action = node.get("_action_");
            uniqueValue = node.get("_hashcode_");
            if (action != null && "remove".equals(action.asText())) {
                text = uniqueValue.asText();
                Integer idx = (Integer)indexMap.get(text);
                if (idx != null) {
                    removed.add(idx);
                    continue;
                }
                this.log.info((Object)String.format("%s\u4e2d\u672a\u627e\u5230\u7d22\u5f15\u4e3a%s\u7684\u5143\u7d20\uff01[%s]", source, idx, text));
                continue;
            }
            if (uniqueValue != null && source.get(text = uniqueValue.asText()) != null) {
                source.set(((Integer)indexMap.get(text)).intValue(), node.get("_value_"));
                continue;
            }
            source.add(node.get("_value_"));
        }
        if (!removed.isEmpty()) {
            Collections.sort(removed, new IntegerValueComparator());
            for (Integer idx : removed) {
                source.remove(idx.intValue());
            }
        }
        return source;
    }

    private ObjectNode mergeObjectNode(ObjectNode sourceNode, ObjectNode patchNode) {
        if (this.hasClearAddAction((JsonNode)patchNode)) {
            sourceNode.removeAll();
            sourceNode.putAll(patchNode);
            sourceNode.remove("_action_");
            return sourceNode;
        }
        Iterator patchFields = patchNode.fields();
        Map.Entry entry = null;
        String key = null;
        JsonNode value = null;
        JsonNode sourceValue = null;
        while (patchFields.hasNext()) {
            entry = (Map.Entry)patchFields.next();
            key = (String)entry.getKey();
            value = (JsonNode)entry.getValue();
            sourceValue = sourceNode.get(key);
            JsonNode independent = value.get("_independent_");
            if (independent != null && independent.booleanValue()) {
                sourceNode.put(key, value);
                continue;
            }
            if (sourceValue == null || sourceValue.isNull()) {
                if ("_inherit_".equals(key) || key.indexOf(45) > -1) continue;
                if (value.isArray()) {
                    this.checkArrayPatch(key, (ArrayNode)value);
                    sourceNode.put(key, value);
                } else if (value.isObject()) {
                    if (value.has("_inherit_")) {
                        this.log.info((Object)"Object has inherit...");
                    } else {
                        this.checkObjectPatch(key, (ObjectNode)value);
                        sourceNode.put(key, value);
                    }
                } else {
                    sourceNode.put(key, value);
                }
            } else if (value == null || value.isNull()) {
                sourceNode.remove(key);
            } else if (sourceValue.isArray()) {
                this.mergeArrayNode(key, (ArrayNode)sourceValue, (ArrayNode)value);
            } else if (sourceValue.isObject()) {
                this.mergeObjectNode((ObjectNode)sourceValue, (ObjectNode)value);
            } else {
                sourceNode.put(key, value);
            }
            if (!this.isConditionRule(sourceValue) && !this.isConditionRule(value)) continue;
            this.regenerateExpression(sourceNode.get(key), value);
        }
        return sourceNode;
    }

    private void checkArrayPatch(String key, ArrayNode patch) {
        if (patch.size() == 0) {
            return;
        }
        if (BpmnDiffUtil.getListElementUniqueKey(key) != null) {
            Iterator iter = patch.iterator();
            JsonNode node = null;
            while (iter.hasNext()) {
                node = (JsonNode)iter.next();
                if (node.has("_inherit_")) {
                    iter.remove();
                    continue;
                }
                JsonNode action = node.get("_action_");
                if (action == null || "clear-add".equals(action.textValue())) continue;
                iter.remove();
            }
        } else if (this.isBasicArray(patch)) {
            Iterator iter = patch.iterator();
            JsonNode node = null;
            ArrayNode values = BpmnDiffUtil.createArrayNode();
            while (iter.hasNext()) {
                node = (JsonNode)iter.next();
                if (node.has("_action_")) {
                    iter.remove();
                    continue;
                }
                if (!node.has("_value_")) continue;
                values.add(node.get("_value_"));
                iter.remove();
            }
            patch.addAll(values);
        }
    }

    private void checkObjectPatch(String key, ObjectNode patch) {
        Iterator iterator = patch.fieldNames();
        String name = null;
        JsonNode node = null;
        while (iterator.hasNext()) {
            name = (String)iterator.next();
            node = patch.get(name);
            if (node.isArray()) {
                this.checkArrayPatch(name, (ArrayNode)node);
                continue;
            }
            if (!node.isObject()) continue;
            this.checkObjectPatch(name, (ObjectNode)node);
        }
    }

    private void regenerateExpression(JsonNode sourceNode, JsonNode patchNode) {
        if (sourceNode == null || sourceNode.isNull()) {
            return;
        }
        ArrayNode conditions = (ArrayNode)sourceNode.get("entryentity");
        if (conditions != null && conditions.size() > 0) {
            String condExpression = ConditionalRuleHelper.getConditionExpression(conditions);
            ((ObjectNode)sourceNode).put("expression", condExpression);
        } else {
            ((ObjectNode)sourceNode).put("expression", "");
        }
    }

    private boolean isConditionRule(JsonNode node) {
        return node != null && node.has("expression") && node.has("entryentity");
    }

    private boolean isPluginConditionalRule(JsonNode node) {
        return node != null && node.has("plugin") && node.has("type") && this.conditionTypes.contains(node.get("type").asText());
    }

    @Override
    public IPatch<JsonNode> getPatch(JsonNode source, JsonNode target) {
        JsonDiffProcessor processor = new JsonDiffProcessor();
        try {
            this.generateDiffs(processor, JsonPointer.empty(), source, target);
        }
        catch (Exception e) {
            this.log.error((Object)WfUtils.getExceptionStacktrace(e));
            throw new KDException(WFErrorCode.generateDiffsError(), new Object[]{e.getMessage()});
        }
        return processor.getPatch();
    }

    private void generateDiffs(IDiffProcessor<JsonNode> processor, JsonPointer pointer, JsonNode source, JsonNode target) {
        NodeType secondType;
        if (this.EQUIVALENCE.equivalent((Object)source, (Object)target)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType(source);
        if (firstType != (secondType = NodeType.getNodeType(target))) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (!source.isContainerNode()) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonNode independent = target.get("_independent_");
            if (independent != null && independent.booleanValue()) {
                processor.valueAdded(pointer, target);
                return;
            }
            this.generateObjectDiffs(processor, pointer, (ObjectNode)source, (ObjectNode)target);
        } else if (source.size() > 0 && !source.get(0).isContainerNode() || target.size() > 0 && !target.get(0).isContainerNode()) {
            this.generateSpecialDiffs(processor, pointer, (ArrayNode)source, (ArrayNode)target, "_hashcode_");
        } else {
            this.log.info((Object)String.format("%s\u4e0d\u5c5e\u4e8e\u5904\u7406\u8303\u56f4\u5185\u7684\u6570\u7ec4\uff01", pointer));
        }
    }

    private void generateObjectDiffs(IDiffProcessor<JsonNode> processor, JsonPointer pointer, ObjectNode source, ObjectNode target) {
        TreeSet firstFields = Sets.newTreeSet((Iterable)Sets.newHashSet((Iterator)source.fieldNames()));
        TreeSet secondFields = Sets.newTreeSet((Iterable)Sets.newHashSet((Iterator)target.fieldNames()));
        boolean numModify = false;
        for (String field : Sets.difference((Set)firstFields, (Set)secondFields)) {
            processor.valueRemoved(pointer.append(field), source.get(field));
            numModify = true;
        }
        for (String field : Sets.difference((Set)secondFields, (Set)firstFields)) {
            processor.valueAdded(pointer.append(field), target.get(field));
            numModify = true;
        }
        if (numModify) {
            boolean isSpecListElt;
            String parent = pointer.parent().toString();
            String key = parent.substring(parent.lastIndexOf(47) + 1, parent.length());
            boolean bl = isSpecListElt = BpmnDiffUtil.getListElementUniqueKey(key) != null;
            if (isSpecListElt) {
                processor.valueAdded(pointer.append("_inherit_"), BpmnDiffUtil.INHERIT_TRUE);
            }
        }
        Sets.SetView intersectFields = Sets.intersection((Set)firstFields, (Set)secondFields);
        this.processIntersectionFields(processor, pointer, source, target, (Sets.SetView<String>)intersectFields);
    }

    private void processIntersectionFields(IDiffProcessor<JsonNode> processor, JsonPointer pointer, ObjectNode source, ObjectNode target, Sets.SetView<String> intersectFields) {
        String parent = pointer.parent().toString();
        String key = parent.substring(parent.lastIndexOf(47) + 1, parent.length());
        boolean isSpecListElt = BpmnDiffUtil.getListElementUniqueKey(key) != null;
        List<DiffOperation<JsonNode>> diffs = processor.getDiffOperations();
        int size = diffs.size();
        for (String field : intersectFields) {
            if ("style".equals(field) || "bounds".equals(field)) continue;
            String uniqueKey = BpmnDiffUtil.getListElementUniqueKey(field);
            JsonNode src = source.get(field);
            JsonNode tgt = target.get(field);
            if (uniqueKey != null && src.isArray() && tgt.isArray()) {
                this.generateSpecialDiffs(processor, pointer.append(field), (ArrayNode)src, (ArrayNode)tgt, uniqueKey);
                continue;
            }
            this.generateDiffs(processor, pointer.append(field), source.get(field), target.get(field));
        }
        if (isSpecListElt && !intersectFields.isEmpty() && diffs.size() > size) {
            processor.valueAdded(pointer.append("_inherit_"), BpmnDiffUtil.INHERIT_TRUE);
        }
        if ((this.isConditionRule((JsonNode)source) || this.isPluginConditionalRule((JsonNode)source)) && diffs.size() > size) {
            processor.valueAdded(pointer.append("type"), source.get("type"));
            processor.valueAdded(pointer.append("_inherit_"), BpmnDiffUtil.INHERIT_TRUE);
        }
    }

    private void generateSpecialDiffs(IDiffProcessor<JsonNode> processor, JsonPointer pointer, ArrayNode source, ArrayNode target, String uniqueKey) {
        TreeMap<String, JsonNode> sourceMap = new TreeMap<String, JsonNode>(this.comparator);
        TreeMap<String, JsonNode> targetMap = new TreeMap<String, JsonNode>(this.comparator);
        HashMap<String, String> srcKeyMap = new HashMap<String, String>();
        HashMap<String, String> tgtKeyMap = new HashMap<String, String>();
        int firstSize = source.size();
        int secondSize = target.size();
        String[] keys = uniqueKey.split(String.valueOf('-'));
        String fmtKey = BpmnDiffUtil.getFormatUniqueKey(uniqueKey);
        JsonNode node = null;
        String text = null;
        StringBuilder id = null;
        JsonNode temp = null;
        for (int i = 0; i < firstSize; ++i) {
            node = source.get(i);
            if (keys.length > 1) {
                id = new StringBuilder();
                for (String key : keys) {
                    temp = node.get(key);
                    if (temp == null || temp.isNull()) continue;
                    id.append(String.valueOf(temp).hashCode());
                }
                text = id.toString();
                srcKeyMap.put(text, fmtKey);
            } else if (!node.isContainerNode()) {
                text = String.valueOf(node.hashCode());
                srcKeyMap.put(text, uniqueKey);
            } else {
                temp = node.get(uniqueKey);
                if (temp == null) {
                    throw new WFException(String.format(ResManager.loadKDString((String)"%1$s%2$s\u5dee\u91cf\u8ba1\u7b97\u5931\u8d25\uff0c\u552f\u4e00\u6807\u8bc6\uff1a%3$s\u3002", (String)"JsonDiff_2", (String)"bos-wf-engine", (Object[])new Object[0]), pointer, i, uniqueKey));
                }
                text = temp.asText();
                srcKeyMap.put(text, uniqueKey);
            }
            sourceMap.put(text, node);
        }
        HashMap<String, Integer> tgtIndexMap = new HashMap<String, Integer>(secondSize);
        for (int i = 0; i < secondSize; ++i) {
            node = target.get(i);
            if (keys.length > 1) {
                id = new StringBuilder();
                for (String key : keys) {
                    temp = node.get(key);
                    if (temp == null || temp.isNull()) continue;
                    id.append(String.valueOf(temp).hashCode());
                }
                text = id.toString();
                tgtKeyMap.put(text, fmtKey);
            } else if (!node.isContainerNode()) {
                text = String.valueOf(node.hashCode());
                tgtKeyMap.put(text, uniqueKey);
            } else {
                temp = node.get(uniqueKey);
                if (temp == null) {
                    throw new WFException(String.format(ResManager.loadKDString((String)"%1$s%2$s\u5dee\u91cf\u8ba1\u7b97\u5931\u8d25\uff0c\u552f\u4e00\u6807\u8bc6\uff1a%3$s\u3002", (String)"JsonDiff_2", (String)"bos-wf-engine", (Object[])new Object[0]), pointer, i, uniqueKey));
                }
                text = temp.asText();
                tgtKeyMap.put(text, uniqueKey);
            }
            targetMap.put(text, node);
            tgtIndexMap.put(text, i);
        }
        for (String key : Sets.difference(sourceMap.keySet(), targetMap.keySet())) {
            processor.valueRemoved(pointer.append(String.format(FORMAT_TPL, srcKeyMap.get(key), key)), (JsonNode)sourceMap.get(key));
        }
        for (String key : Sets.difference(targetMap.keySet(), sourceMap.keySet())) {
            processor.valueAdded(pointer.append(String.format(FORMAT_TPL, tgtKeyMap.get(key), key)), target.get(((Integer)tgtIndexMap.get(key)).intValue()));
        }
        for (String key : Sets.intersection(sourceMap.keySet(), targetMap.keySet())) {
            this.generateDiffs(processor, pointer.append(String.format(FORMAT_TPL, srcKeyMap.get(key), key)), (JsonNode)sourceMap.get(key), (JsonNode)targetMap.get(key));
        }
    }
}

