/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.enumeration;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;

public enum NodeType {
    ARRAY("array"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string");

    private final String name;
    private static final Map<String, NodeType> NAME_MAP;
    private static final Map<JsonToken, NodeType> TOKEN_MAP;

    private NodeType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static NodeType fromName(String name) {
        return NAME_MAP.get(name);
    }

    public static NodeType getNodeType(JsonNode node) {
        JsonToken token = node.asToken();
        NodeType ret = TOKEN_MAP.get(token);
        return ret;
    }

    static {
        TOKEN_MAP = new EnumMap<JsonToken, NodeType>(JsonToken.class);
        TOKEN_MAP.put(JsonToken.START_ARRAY, ARRAY);
        TOKEN_MAP.put(JsonToken.VALUE_TRUE, BOOLEAN);
        TOKEN_MAP.put(JsonToken.VALUE_FALSE, BOOLEAN);
        TOKEN_MAP.put(JsonToken.VALUE_NUMBER_INT, NUMBER);
        TOKEN_MAP.put(JsonToken.VALUE_NUMBER_FLOAT, NUMBER);
        TOKEN_MAP.put(JsonToken.VALUE_NULL, NULL);
        TOKEN_MAP.put(JsonToken.START_OBJECT, OBJECT);
        TOKEN_MAP.put(JsonToken.VALUE_STRING, STRING);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NodeType type : NodeType.values()) {
            builder.put((Object)type.name, (Object)type);
        }
        NAME_MAP = builder.build();
    }
}

