/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.patch;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.diff.enumeration.DiffOperationType;
import kd.bos.workflow.bpmn.diff.patch.IPatch;
import kd.bos.workflow.bpmn.diff.patch.operation.IPatchOperation;

public abstract class AbstractPatch<T>
implements IPatch<T> {
    protected final List<IPatchOperation<T>> operations;

    public AbstractPatch(List<IPatchOperation<T>> operations) {
        this.operations = operations;
    }

    @Override
    public T apply(T source) {
        Object ret = source;
        String REPLACE = DiffOperationType.REPLACE.toString();
        String REMOVE = DiffOperationType.REMOVE.toString();
        ArrayList<IPatchOperation<T>> addOpers = new ArrayList<IPatchOperation<T>>();
        ArrayList<IPatchOperation<T>> removeOpers = new ArrayList<IPatchOperation<T>>();
        for (IPatchOperation<T> iPatchOperation : this.operations) {
            if (REPLACE.equals(iPatchOperation.getOp())) {
                ret = iPatchOperation.apply(ret);
                continue;
            }
            if (REMOVE.equals(iPatchOperation.getOp())) {
                removeOpers.add(iPatchOperation);
                continue;
            }
            addOpers.add(iPatchOperation);
        }
        for (IPatchOperation<Object> iPatchOperation : removeOpers) {
            ret = iPatchOperation.apply(ret);
        }
        for (IPatchOperation<Object> iPatchOperation : addOpers) {
            ret = iPatchOperation.apply(ret);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }
}

