/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.patch.operation.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kd.bos.workflow.bpmn.diff.patch.operation.json.JsonPatchOperation;
import kd.bos.workflow.bpmn.diff.pointer.json.JsonPointer;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import org.apache.log4j.Logger;

public abstract class PathValueOperation
extends JsonPatchOperation {
    protected final JsonNode value;
    private Logger log = Logger.getLogger(this.getClass());
    protected static final String REGEX = "\\[([\\w\\-]+):(.+?)\\]";

    protected PathValueOperation(String op, JsonPointer path, JsonNode value) {
        super(op, path);
        this.value = value;
    }

    protected String getValue(String path) {
        return path.replaceFirst(REGEX, "$2");
    }

    protected String getKey(String path) {
        return path.replaceFirst(REGEX, "$1");
    }

    protected ObjectNode createJsonNode(ObjectNode parent, String key, String next, boolean isLast) {
        ObjectNode node = null;
        if (next.matches(REGEX)) {
            ArrayNode array = this.MAPPER.createArrayNode();
            parent.put(key, (JsonNode)array);
            node = this.getChildNode(next, this.value, isLast);
            array.add((JsonNode)node);
        } else if (isLast) {
            parent.put(key, this.value);
        } else {
            node = this.MAPPER.createObjectNode();
            parent.put(key, (JsonNode)node);
        }
        return node;
    }

    protected ObjectNode getChildNode(String next, JsonNode value, boolean isLast) {
        ObjectNode node = null;
        String key = this.getKey(next);
        String path = this.getValue(next);
        if (isLast) {
            node = this.getNode(value, key, path);
        } else {
            node = this.MAPPER.createObjectNode();
            node.put(key, path);
        }
        return node;
    }

    private ObjectNode getNode(JsonNode value, String key, String path) {
        ObjectNode node;
        if (value == null) {
            node = this.MAPPER.createObjectNode();
            node.put(key, path);
            node.put("_action_", "remove");
        } else {
            node = value.isContainerNode() ? (ObjectNode)value : this.getBaseTypeNode(value, key, path);
        }
        return node;
    }

    private ObjectNode getBaseTypeNode(JsonNode value, String key, String path) {
        ObjectNode node = this.MAPPER.createObjectNode();
        if ("replace".equals(this.op)) {
            node.put(key, path);
        }
        node.put("_value_", value);
        return node;
    }

    protected ObjectNode getJsonNode(JsonNode jsonNode, String next, boolean isLast) {
        if (jsonNode.isArray()) {
            String key = this.getKey(next);
            String path = this.getValue(next);
            ArrayNode array = (ArrayNode)jsonNode;
            JsonNode item = null;
            for (JsonNode child : array) {
                item = child.get(key);
                if (item == null || item.isNull()) {
                    BpmnDiffUtil.createUniqueKeyValue(child, key);
                    item = child.get(key);
                }
                if (item == null || !path.equals(item.textValue())) continue;
                return (ObjectNode)child;
            }
            ObjectNode node = this.getChildNode(next, this.value, isLast);
            array.add((JsonNode)node);
            return node;
        }
        return (ObjectNode)jsonNode;
    }

    @Override
    public JsonNode apply(JsonNode jsonNode) {
        ObjectNode node = (ObjectNode)jsonNode;
        String realPath = this.path.toString();
        String[] paths = realPath.replaceFirst("^/|/$", "").split("/");
        ObjectNode temp = node;
        String path = null;
        int size = paths.length;
        for (int i = 0; i < size; ++i) {
            path = paths[i];
            String next = i + 1 < size ? paths[i + 1] : "";
            boolean isLast = i + 1 == size || next.matches(REGEX) && i + 2 == size;
            JsonNode valNode = temp.get(path);
            if (valNode == null) {
                temp = this.createJsonNode(temp, path, next, isLast);
            } else if (isLast && !valNode.isArray() && !valNode.isObject()) {
                this.log.info((Object)"isLast==true, value is not an object or array.");
            } else {
                temp = this.getJsonNode(valNode, next, isLast);
            }
            if (!next.matches(REGEX)) continue;
            ++i;
        }
        return node;
    }

    @Override
    public String toString() {
        return "{\"op\": \"" + this.op + "\", \"path\": \"" + this.path + "\", \"value\": " + this.value + "}";
    }
}

