/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.pointer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.diff.pointer.json.JsonNodeResolver;
import kd.bos.workflow.bpmn.diff.pointer.json.ReferenceToken;
import kd.bos.workflow.bpmn.diff.pointer.json.TokenResolver;
import kd.bos.workflow.bpmn.diff.pointer.json.TreePointer;

public final class JsonPointer
extends TreePointer {
    private static final JsonPointer POINTER_EMPTY = new JsonPointer((List<TokenResolver<JsonNode>>)ImmutableList.of());

    public static JsonPointer empty() {
        return POINTER_EMPTY;
    }

    public static JsonPointer of(Object first, Object ... other) {
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)(other.length + 1));
        tokens.add(ReferenceToken.fromRaw(first.toString()));
        for (Object o : other) {
            tokens.add(ReferenceToken.fromRaw(o.toString()));
        }
        return new JsonPointer(JsonPointer.fromTokens(tokens));
    }

    public JsonPointer(String input) {
        this(JsonPointer.fromTokens(JsonPointer.tokensFromInput(input)));
    }

    public JsonPointer(List<TokenResolver<JsonNode>> tokenResolvers) {
        super((JsonNode)MissingNode.getInstance(), tokenResolvers);
    }

    public JsonPointer append(String raw) {
        ReferenceToken refToken = ReferenceToken.fromRaw(raw);
        JsonNodeResolver resolver = new JsonNodeResolver(refToken);
        ArrayList list = Lists.newArrayList((Iterable)this.tokenResolvers);
        list.add(resolver);
        return new JsonPointer(list);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    public JsonPointer append(JsonPointer other) {
        ArrayList list = Lists.newArrayList((Iterable)this.tokenResolvers);
        list.addAll(other.tokenResolvers);
        return new JsonPointer(list);
    }

    public JsonPointer parent() {
        int size = this.tokenResolvers.size();
        return size <= 1 ? POINTER_EMPTY : new JsonPointer(this.tokenResolvers.subList(0, size - 1));
    }

    private static List<TokenResolver<JsonNode>> fromTokens(List<ReferenceToken> tokens) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)tokens.size());
        for (ReferenceToken token : tokens) {
            list.add(new JsonNodeResolver(token));
        }
        return list;
    }

    @Override
    public String getPath() {
        return this.toString();
    }
}

