/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.pointer.json;

import com.google.common.collect.ImmutableList;
import java.nio.CharBuffer;
import java.util.List;
import kd.bos.workflow.exception.WFException;

public final class ReferenceToken {
    private static final char ESCAPE = '~';
    private static final List<Character> ENCODED = ImmutableList.of((Object)Character.valueOf('0'), (Object)Character.valueOf('1'));
    private static final List<Character> DECODED = ImmutableList.of((Object)Character.valueOf('~'), (Object)Character.valueOf('/'));
    private final String cooked;
    private final String raw;

    private ReferenceToken(String cooked, String raw) {
        this.cooked = cooked;
        this.raw = raw;
    }

    public static ReferenceToken fromCooked(String cooked) {
        return new ReferenceToken(cooked, ReferenceToken.asRaw(cooked));
    }

    public static ReferenceToken fromRaw(String raw) {
        return new ReferenceToken(ReferenceToken.asCooked(raw), raw);
    }

    public static ReferenceToken fromInt(int index) {
        String s = Integer.toString(index);
        return new ReferenceToken(s, s);
    }

    public String getRaw() {
        return this.raw;
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceToken other = (ReferenceToken)obj;
        return this.raw.equals(other.raw);
    }

    public String toString() {
        return this.cooked;
    }

    private static String asRaw(String cooked) {
        StringBuilder raw = new StringBuilder(cooked.length());
        CharBuffer buffer = CharBuffer.wrap(cooked);
        boolean inEscape = false;
        while (buffer.hasRemaining()) {
            char c = buffer.get();
            if (inEscape) {
                ReferenceToken.appendEscaped(raw, c);
                inEscape = false;
                continue;
            }
            if (c == '~') {
                inEscape = true;
                continue;
            }
            raw.append(c);
        }
        if (inEscape) {
            throw new WFException("JsonDiffError: emptyEscape");
        }
        return raw.toString();
    }

    private static void appendEscaped(StringBuilder sb, char c) {
        int index = ENCODED.indexOf(Character.valueOf(c));
        if (index == -1) {
            throw new WFException("JsonDiffError: illegalEscape");
        }
        sb.append(DECODED.get(index));
    }

    private static String asCooked(String raw) {
        StringBuilder cooked = new StringBuilder(raw.length());
        CharBuffer buffer = CharBuffer.wrap(raw);
        while (buffer.hasRemaining()) {
            char c = buffer.get();
            int index = DECODED.indexOf(Character.valueOf(c));
            if (index != -1) {
                cooked.append('~').append(ENCODED.get(index));
                continue;
            }
            cooked.append(c);
        }
        return cooked.toString();
    }
}

