/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.pointer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.workflow.bpmn.diff.pointer.IPointer;
import kd.bos.workflow.bpmn.diff.pointer.json.ReferenceToken;
import kd.bos.workflow.bpmn.diff.pointer.json.TokenResolver;
import kd.bos.workflow.exception.WFException;

@JsonSerialize(using=ToStringSerializer.class)
public abstract class TreePointer
implements Iterable<TokenResolver<JsonNode>>,
IPointer {
    private static final char SLASH = '/';
    private final JsonNode missing;
    protected final List<TokenResolver<JsonNode>> tokenResolvers;

    protected TreePointer(JsonNode missing, List<TokenResolver<JsonNode>> tokenResolvers) {
        this.missing = missing;
        this.tokenResolvers = ImmutableList.copyOf(tokenResolvers);
    }

    protected TreePointer(List<TokenResolver<JsonNode>> tokenResolvers) {
        this(null, tokenResolvers);
    }

    public final JsonNode get(JsonNode node) {
        JsonNode ret = node;
        for (TokenResolver<JsonNode> tokenResolver : this.tokenResolvers) {
            if (ret == null) break;
            ret = tokenResolver.get(ret);
        }
        return ret;
    }

    public final JsonNode path(JsonNode node) {
        JsonNode ret = this.get(node);
        return ret == null ? this.missing : ret;
    }

    public final boolean isEmpty() {
        return this.tokenResolvers.isEmpty();
    }

    @Override
    public final Iterator<TokenResolver<JsonNode>> iterator() {
        return this.tokenResolvers.iterator();
    }

    public final int hashCode() {
        return this.tokenResolvers.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreePointer other = (TreePointer)obj;
        return this.tokenResolvers.equals(other.tokenResolvers);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (TokenResolver<JsonNode> tokenResolver : this.tokenResolvers) {
            sb.append('/').append(tokenResolver);
        }
        return sb.toString();
    }

    protected static List<ReferenceToken> tokensFromInput(String input) {
        String s = input;
        int size = s.split(String.valueOf('/')).length;
        ArrayList ret = Lists.newArrayListWithExpectedSize((int)size);
        while (!s.isEmpty()) {
            char c = s.charAt(0);
            if (c != '/') {
                throw new WFException("JsonDiffError: notSlash");
            }
            int index = (s = s.substring(1)).indexOf(47);
            String cooked = index == -1 ? s : s.substring(0, index);
            ret.add(ReferenceToken.fromCooked(cooked));
            if (index == -1) break;
            s = s.substring(index);
        }
        return ret;
    }
}

