/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.diff.patch.IPatch;
import kd.bos.workflow.bpmn.diff.patch.operation.IPatchOperation;
import kd.bos.workflow.bpmn.diff.pointer.IPointer;
import kd.bos.workflow.bpmn.diff.processor.DiffOperation;
import kd.bos.workflow.bpmn.diff.processor.IDiffProcessor;

public abstract class AbstractDiffProcessor<T>
implements IDiffProcessor<T> {
    protected final List<DiffOperation<T>> diffs = Lists.newArrayList();

    @Override
    public void valueAdded(IPointer pointer, T value) {
        this.diffs.add(this.getDiffOperation().add(pointer, value));
    }

    @Override
    public void valueReplaced(IPointer pointer, T oldValue, T newValue) {
        this.diffs.add(this.getDiffOperation().replace(pointer, oldValue, newValue));
    }

    @Override
    public void valueRemoved(IPointer pointer, T value) {
        this.diffs.add(this.getDiffOperation().remove(pointer, value));
    }

    @Override
    public IPatch<T> getPatch() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.diffs.size());
        for (DiffOperation<T> op : this.diffs) {
            list.add(this.getIPatchOperation(op));
        }
        return this.getPatch(list);
    }

    @Override
    public List<DiffOperation<T>> getDiffOperations() {
        return this.diffs;
    }

    protected abstract IPatch<T> getPatch(List<IPatchOperation<T>> var1);

    protected abstract IPatchOperation<T> getIPatchOperation(DiffOperation<T> var1);

    protected abstract DiffOperation<T> getDiffOperation();
}

