/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.processor;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import kd.bos.workflow.bpmn.diff.patch.IPatch;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.patch.operation.IPatchOperation;
import kd.bos.workflow.bpmn.diff.patch.operation.json.JsonAddOperation;
import kd.bos.workflow.bpmn.diff.patch.operation.json.JsonReplaceOperation;
import kd.bos.workflow.bpmn.diff.pointer.IPointer;
import kd.bos.workflow.bpmn.diff.pointer.json.JsonPointer;
import kd.bos.workflow.bpmn.diff.processor.AbstractDiffProcessor;
import kd.bos.workflow.bpmn.diff.processor.DiffOperation;
import kd.bos.workflow.bpmn.diff.util.JacksonUtils;

public class JsonDiffProcessor
extends AbstractDiffProcessor<JsonNode> {
    private DiffOperation<JsonNode> diffOperation = new DiffOperation();

    @Override
    public DiffOperation<JsonNode> getDiffOperation() {
        return this.diffOperation;
    }

    @Override
    public void valueAdded(IPointer pointer, JsonNode value) {
        if (value != null && !value.isNull()) {
            super.valueAdded(pointer, JacksonUtils.copyNode(value));
        }
    }

    @Override
    public void valueRemoved(IPointer pointer, JsonNode value) {
        if (value != null && !value.isNull()) {
            super.valueRemoved(pointer, value);
        }
    }

    @Override
    protected IPatchOperation<JsonNode> getIPatchOperation(DiffOperation<JsonNode> op) {
        switch (op.getType()) {
            case ADD: {
                return new JsonAddOperation((JsonPointer)op.getPath(), op.getValue());
            }
            case REPLACE: {
                return new JsonReplaceOperation((JsonPointer)op.getPath(), op.getValue(), op.getOldValue());
            }
            case REMOVE: {
                return new JsonReplaceOperation((JsonPointer)op.getPath(), null, op.getOldValue());
            }
        }
        return null;
    }

    @Override
    protected IPatch<JsonNode> getPatch(List<IPatchOperation<JsonNode>> list) {
        return new JsonPatch(list);
    }
}

