/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.workflow.bpmn.diff.IDiff;
import kd.bos.workflow.bpmn.diff.enumeration.DiffType;
import kd.bos.workflow.bpmn.diff.factory.DiffFactory;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.util.JacksonUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.log4j.Logger;

public class BpmnDiffUtil {
    private static Logger log = Logger.getLogger(BpmnDiffUtil.class);
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final String ARRKEY_ID = "id";
    private static final ORM orm = ORM.create();
    private static final Map<String, String> arrKeys = new HashMap<String, String>();
    private static final DynamicObjectType conditionType = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_conditionalrule")).getDynamicObjectCollection("entryentity").getDynamicObjectType();
    public static final JsonNode INHERIT_TRUE = BpmnDiffUtil.getNode("true");

    public static JsonNode getBpmnPatch(JsonPatch patch) {
        ObjectNode ret = MAPPER.createObjectNode();
        try {
            patch.apply(ret);
        }
        catch (Exception e) {
            log.error((Object)String.format("JsonPatch\u8f6cJsonNode\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            throw new KDException(WFErrorCode.jsonPatchToBpmnPatchError(), new Object[]{e.getMessage()});
        }
        return ret;
    }

    public static JsonPatch getJsonDiffPatch(String src, String tgt) {
        JsonNode source = null;
        JsonNode target = null;
        try {
            source = MAPPER.readTree(src);
            target = MAPPER.readTree(tgt);
        }
        catch (Exception e) {
            log.error((Object)String.format("\u5b57\u7b26\u4e32JSON\u8f6cJsonNode\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
        }
        return BpmnDiffUtil.diffJson(source, target);
    }

    public static JsonPatch diffJson(JsonNode source, JsonNode target) {
        IDiff diff = DiffFactory.getDiff(DiffType.JSON);
        return (JsonPatch)diff.getPatch(source, target);
    }

    public static JsonNode getBpmnPatch(JsonNode source, JsonNode target) {
        JsonPatch patch = BpmnDiffUtil.diffJson(source, target);
        return BpmnDiffUtil.getBpmnPatch(patch);
    }

    public static String getFormatUniqueKey(String key) {
        if (key.indexOf(45) > -1) {
            return String.format("_%s_", key);
        }
        return key;
    }

    public static JsonNode applyPatch(JsonNode source, JsonNode patch) {
        if (patch == null) {
            return source;
        }
        try {
            IDiff diff = DiffFactory.getDiff(DiffType.JSON);
            return diff.applyPatch(source, patch);
        }
        catch (Exception e) {
            log.error((Object)WfUtils.getExceptionStacktrace(e));
            throw new KDException(WFErrorCode.mergeDiffsError(), new Object[]{e.getMessage()});
        }
    }

    public static JsonNode applyPatch(String source, String patch) {
        if (WfUtils.isNotEmpty(source) && WfUtils.isNotEmpty(patch)) {
            return BpmnDiffUtil.applyPatch(BpmnDiffUtil.getNode(source), BpmnDiffUtil.getNode(patch));
        }
        return null;
    }

    public static JsonNode applyPatch(String source, JsonNode patch) {
        if (WfUtils.isNotEmpty(source) && patch != null) {
            return BpmnDiffUtil.applyPatch(BpmnDiffUtil.getNode(source), patch);
        }
        return null;
    }

    public static JsonNode applyPatch(JsonNode source, String patch) {
        String temp = null;
        if (patch == null || "".equals(temp = patch.trim()) || "{}".equals(temp)) {
            return source;
        }
        JsonNode patchNode = null;
        try {
            patchNode = MAPPER.readTree(patch);
        }
        catch (Exception e) {
            log.error((Object)WfUtils.getExceptionStacktrace(e));
            throw new KDException(WFErrorCode.mergeDiffsError(), new Object[]{e.getMessage()});
        }
        return BpmnDiffUtil.applyPatch(source, patchNode);
    }

    public static JsonNode applyPatch(JsonNode source, InputStream patch) {
        JsonNode patchNode = null;
        try {
            patchNode = MAPPER.readTree(patch);
        }
        catch (Exception e) {
            log.error((Object)WfUtils.getExceptionStacktrace(e));
            throw new KDException(WFErrorCode.mergeDiffsError(), new Object[]{e.getMessage()});
        }
        return BpmnDiffUtil.applyPatch(source, patchNode);
    }

    public static String createUniqueKeyValue(JsonNode jsonNode, String fmtKey) {
        String ret = "";
        if (jsonNode.isObject()) {
            ObjectNode node = (ObjectNode)jsonNode;
            ret = BpmnDiffUtil.getUniqueKeyValue((JsonNode)node, fmtKey);
            node.put(fmtKey, ret);
            return ret;
        }
        return ret;
    }

    public static String getUniqueKeyValue(JsonNode node, String fmtKey) {
        if (!fmtKey.matches("_\\w+(\\-\\w+)*_")) {
            return fmtKey;
        }
        String[] keys = fmtKey.replace("_", "").split(String.valueOf('-'));
        StringBuilder id = new StringBuilder();
        JsonNode temp = null;
        for (String key : keys) {
            temp = node.get(key);
            if (temp == null || temp.isNull()) continue;
            id.append(String.valueOf(temp).hashCode());
        }
        return id.toString();
    }

    public static String getListElementUniqueKey(String key) {
        return arrKeys.get(key);
    }

    public static JsonNode getNode(String content) {
        JsonNode node = null;
        try {
            node = MAPPER.readTree(content);
        }
        catch (Exception e) {
            log.error((Object)WfUtils.getExceptionStacktrace(e));
        }
        return node;
    }

    public static ObjectNode createObjectNode() {
        return MAPPER.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return MAPPER.createArrayNode();
    }

    public static String getListElementId(String field) {
        String number = null;
        switch (field) {
            case "pageAttrConfig": 
            case "mobilePageAttrConfig": {
                number = "wf_billpageattrcfgmodel";
                break;
            }
            case "entryentity": {
                return String.valueOf(orm.genLongId((IDataEntityType)conditionType));
            }
            default: {
                number = "wf_billdyninfomodel";
            }
        }
        return String.valueOf(orm.genLongId(number));
    }

    public static List<String> getOrderedConditionEntityIds(int size) {
        ArrayList<String> ids = new ArrayList<String>();
        if (size > 0) {
            long[] itemIds = orm.genLongIds((IDataEntityType)conditionType, size);
            for (int i = 0; i < size; ++i) {
                ids.add(String.valueOf(itemIds[i]));
            }
        }
        return ids;
    }

    public static String fixArrayElementId(String json) {
        try {
            JsonNode jsonNode = BpmnDiffUtil.getNode(json);
            int index = 0;
            if (jsonNode != null && jsonNode.isObject()) {
                ObjectNode node = (ObjectNode)jsonNode;
                BpmnDiffUtil.fixArrayElementId(node, index);
                return node.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)WfUtils.getExceptionStacktrace(e));
            throw new KDException(WFErrorCode.fixArrayElementIdError(), new Object[]{e.getMessage()});
        }
        return json;
    }

    public static void fixArrayElementId(ObjectNode node, int index) {
        Iterator iterator = node.fields();
        Map.Entry entry = null;
        String field = null;
        JsonNode value = null;
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            field = (String)entry.getKey();
            value = (JsonNode)entry.getValue();
            if (value.isArray()) {
                BpmnDiffUtil.fixArrayNodeElementId(index, field, value);
                continue;
            }
            if (!value.isObject()) continue;
            BpmnDiffUtil.fixArrayElementId((ObjectNode)value, index);
        }
    }

    private static void fixArrayNodeElementId(int index, String field, JsonNode value) {
        ArrayNode array = (ArrayNode)value;
        String arrKey = BpmnDiffUtil.getListElementUniqueKey(field);
        Iterator arrIterator = array.elements();
        JsonNode child = null;
        if (ARRKEY_ID.equals(arrKey)) {
            while (arrIterator.hasNext()) {
                child = (JsonNode)arrIterator.next();
                JsonNode idNode = null;
                String id = null;
                if (!child.isObject() || (idNode = child.get(ARRKEY_ID)) != null && !"".equals(id = idNode.asText().trim()) && !"0".equals(id)) continue;
                ObjectNode objNode = (ObjectNode)child;
                objNode.put(ARRKEY_ID, BpmnDiffUtil.getListElementId(field));
                BpmnDiffUtil.fixArrayElementId(objNode, index);
            }
        } else {
            while (arrIterator.hasNext()) {
                child = (JsonNode)arrIterator.next();
                if (!child.isObject()) continue;
                BpmnDiffUtil.fixArrayElementId((ObjectNode)child, index);
            }
        }
    }

    public static JSONObject regenerateListPropertyId(JSONObject properties) {
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        Set keys = properties.keySet();
        for (String key : keys) {
            Object value = properties.get((Object)key);
            if (value instanceof JSONArray) {
                BpmnDiffUtil.regenerateArrayNodePropertyId(key, value);
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            BpmnDiffUtil.regenerateListPropertyId((JSONObject)value);
        }
        return properties;
    }

    private static void regenerateArrayNodePropertyId(String key, Object value) {
        String arrKey = BpmnDiffUtil.getListElementUniqueKey(key);
        JSONArray array = (JSONArray)value;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            Object val = array.get(i);
            if (!(val instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)val;
            if (ARRKEY_ID.equals(arrKey) && !BpmnDiffUtil.isSpecialData(key, object)) {
                object.put(ARRKEY_ID, (Object)BpmnDiffUtil.getListElementId(key));
            }
            BpmnDiffUtil.regenerateListPropertyId(object);
        }
    }

    private static boolean isSpecialData(String key, JSONObject object) {
        return "customParams".equals(key) && Boolean.TRUE.equals(object.get((Object)"builtin"));
    }

    public static void markAsIndependent(Map<String, Object> properties) {
        if (properties != null) {
            properties.put("_independent_", true);
        }
    }

    static {
        arrKeys.put("childShapes", "resourceId");
        arrKeys.put("outgoing", "resourceId");
        arrKeys.put("optionalOperations", ARRKEY_ID);
        arrKeys.put("optionalDecisionItems", ARRKEY_ID);
        arrKeys.put("decisionOptions", ARRKEY_ID);
        arrKeys.put("rejectOptions", "itemId");
        arrKeys.put("participant", ARRKEY_ID);
        arrKeys.put("entryentity", ARRKEY_ID);
        arrKeys.put("executionListeners", ARRKEY_ID);
        arrKeys.put("taskListeners", ARRKEY_ID);
        arrKeys.put("variables", ARRKEY_ID);
        arrKeys.put("startItems", ARRKEY_ID);
        arrKeys.put("eventParams", ARRKEY_ID);
        arrKeys.put("customParams", ARRKEY_ID);
        arrKeys.put("rpaProcParams", ARRKEY_ID);
        arrKeys.put("inMsg", ARRKEY_ID);
        arrKeys.put("outMsg", ARRKEY_ID);
        arrKeys.put("receiver", ARRKEY_ID);
        arrKeys.put("timeControls", ARRKEY_ID);
        arrKeys.put("inParameters", ARRKEY_ID);
        arrKeys.put("extendBtns", ARRKEY_ID);
        arrKeys.put("auditPoints", ARRKEY_ID);
        arrKeys.put("subject", ARRKEY_ID);
        arrKeys.put("auditComments", ARRKEY_ID);
        arrKeys.put("billExceptionOp", ARRKEY_ID);
        arrKeys.put("pageAttrConfig", ARRKEY_ID);
        arrKeys.put("mobilePageAttrConfig", ARRKEY_ID);
        arrKeys.put("participantAllow", ARRKEY_ID);
        arrKeys.put("participantBlackList", ARRKEY_ID);
        arrKeys.put("pageParameter", ARRKEY_ID);
        arrKeys.put("advAppSchemes", ARRKEY_ID);
        arrKeys.put("operations", ARRKEY_ID);
        arrKeys.put("backSet", ARRKEY_ID);
    }
}

