/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.diff.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import org.apache.log4j.Logger;

public final class JacksonUtils {
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.instance;
    private static final ObjectReader READER;
    private static final ObjectWriter WRITER;
    private static Logger log;

    private JacksonUtils() {
    }

    public static ObjectReader getReader() {
        return READER;
    }

    public static JsonNodeFactory nodeFactory() {
        return FACTORY;
    }

    public static Map<String, JsonNode> asMap(JsonNode node) {
        if (!node.isObject()) {
            return Collections.emptyMap();
        }
        Iterator iterator = node.fields();
        HashMap ret = Maps.newHashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static String prettyPrint(JsonNode node) {
        StringWriter writer = new StringWriter();
        try {
            WRITER.writeValue((Writer)writer, (Object)node);
            writer.flush();
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException("How did I get there??", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("How did I get there??", e);
        }
        catch (IOException ignored) {
            log.error((Object)WfUtils.getExceptionStacktrace(ignored));
        }
        return writer.toString();
    }

    public static <T> T copyNode(T node) {
        if (node instanceof ObjectNode) {
            return (T)JacksonUtils.copyObjectNode((ObjectNode)node);
        }
        if (node instanceof ArrayNode) {
            return (T)JacksonUtils.copyArrayNode((ArrayNode)node);
        }
        if (node instanceof ValueNode) {
            return node;
        }
        return node;
    }

    public static ArrayNode copyArrayNode(ArrayNode node) {
        ArrayNode ret = new ArrayNode(FACTORY);
        Iterator iterator = node.elements();
        while (iterator.hasNext()) {
            ret.add((JsonNode)JacksonUtils.copyNode(iterator.next()));
        }
        return ret;
    }

    public static ObjectNode copyObjectNode(ObjectNode node) {
        ObjectNode ret = new ObjectNode(FACTORY);
        Iterator iterator = node.fields();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            ret.put((String)entry.getKey(), (JsonNode)JacksonUtils.copyNode(entry.getValue()));
        }
        return ret;
    }

    public static ObjectMapper newMapper() {
        return new ObjectMapper().setNodeFactory(FACTORY);
    }

    static {
        log = Logger.getLogger(JacksonUtils.class);
        ObjectMapper mapper = JacksonUtils.newMapper();
        READER = mapper.reader();
        WRITER = mapper.writer();
    }
}

