/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.workflow.bpmn.graph.codec.GraphCellCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.TerminateEventDefinition;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import org.dom4j.Element;
import org.dom4j.Node;

public class EndEventCodec
extends GraphCellCodec {
    public EndEventCodec() {
        this.type = "EndNoneEvent";
    }

    @Override
    protected String getType(Object element) {
        EndEvent endEvent = (EndEvent)element;
        return SpecialPropertyUtil.getEndEventType(endEvent);
    }

    @Override
    protected void setCellCommonAttributes(GraphCodecContext ctx, Node node, Object obj) {
        super.setCellCommonAttributes(ctx, node, obj);
        ((Element)node).addAttribute("showRecords", "false");
    }

    @Override
    protected String getNameInFlowchart(BaseElement element, GraphCodecContext ctx) {
        return element.getName();
    }

    @Override
    protected Object initiation(Object obj, ElementType elementType, GraphCodecContext context) {
        EndEvent endEvent = (EndEvent)super.initiation(obj, elementType, context);
        switch (endEvent.getType()) {
            case "EndTerminateEvent": {
                TerminateEventDefinition eventDefinition = new TerminateEventDefinition();
                eventDefinition.setTerminateAll(false);
                eventDefinition.setTerminateMultiInstance(false);
                endEvent.getEventDefinitions().add(eventDefinition);
                break;
            }
            case "EndErrorEvent": {
                ErrorEventDefinition errorEventDefinition = new ErrorEventDefinition();
                endEvent.getEventDefinitions().add(errorEventDefinition);
                break;
            }
            case "EndCancelEvent": {
                CancelEventDefinition cancelEventDefinition = new CancelEventDefinition();
                endEvent.getEventDefinitions().add(cancelEventDefinition);
                break;
            }
        }
        endEvent.setStyle(this.getStyle((Object)endEvent, elementType));
        return endEvent;
    }

    @Override
    protected String getGroup() {
        return "BasicControl";
    }

    @Override
    protected int getCommonNodeWidth() {
        return 115;
    }

    @Override
    protected int getCommonNodeHeight() {
        return 45;
    }

    @Override
    protected EndEvent create() {
        return new EndEvent();
    }
}

