/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.converter.field.TransIgnore;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecRegistry;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.codec.GraphObjectCodec;
import kd.bos.workflow.bpmn.graph.model.ElementValueContext;
import kd.bos.workflow.bpmn.graph.model.GraphPoint;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.beanutils.PropertyUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class GraphCellCodec
extends GraphObjectCodec {
    protected static Log logger = LogFactory.getLog(GraphCellCodec.class);
    protected int vertex = 1;
    protected int edge = 0;
    protected String styleTpl = "shape=ierp.%s.%s;whiteSpace=wrap;spacingLeft=50;spacingRight=10;overflow=hidden;";
    protected List<GraphPoint> connectPoints = new ArrayList<GraphPoint>();
    private static final String STYLE = "style";
    protected static final String OBJECT = "Object";
    private static final String ARRAY = "Array";

    public GraphCellCodec() {
        super("mxCell");
        this.connectPoints.add(new GraphPoint("1", "0.5"));
        this.connectPoints.add(new GraphPoint("0", "0.5"));
        this.connectPoints.add(new GraphPoint("0.5", "0"));
        this.connectPoints.add(new GraphPoint("0.5", "1"));
    }

    @Override
    protected void encodeObject(GraphCodecContext ctx, Object obj, Node node) {
        if (node.getNodeType() == 1) {
            Element elm = (Element)node;
            ctx.setCurrentNode((BaseElement)obj);
            this.setCellCommonAttributes(ctx, (Node)elm, obj);
            this.encodeGeometry(ctx, (Node)elm, obj);
            if (ctx.isCodecProperties()) {
                this.encodeProperties(ctx, (Node)elm, obj);
            }
            this.encodeData(ctx, elm, obj);
        }
    }

    @Override
    protected void encodeFlowElement(GraphCodecContext ctx, BaseElement baseElement, Node node) {
        super.encodeFlowElement(ctx, baseElement, node);
        if (node.getNodeType() == 1) {
            Element elm = (Element)node;
            if (baseElement instanceof FlowElement) {
                elm.addAttribute(STYLE, ((FlowElement)baseElement).getStyle());
            }
            elm.addAttribute("type", this.getType(baseElement));
            elm.addAttribute("group", this.getGroup());
            if (this.edge == 1) {
                elm.addAttribute("edge", Integer.toString(this.edge));
            } else {
                elm.addAttribute("vertex", Integer.toString(this.vertex));
            }
            this.encodeProperties(ctx, (Node)elm, baseElement);
        }
    }

    protected void setCellCommonAttributes(GraphCodecContext ctx, Node node, Object obj) {
        Element elm = (Element)node;
        String id = this.getId(obj);
        elm.addAttribute("id", id);
        elm.addAttribute("value", this.getName(obj, ctx));
        if (ctx.isConfigScheme()) {
            elm.addAttribute(STYLE, this.getLockedStyle(this.getOriginalStyle(obj, ctx)));
        } else {
            String style = this.getStyle(obj, ctx);
            if (style != null && style.indexOf("movable=0;resizable=0;rotatable=0;deletable=0;editable=0;connectable=0;") > -1) {
                style = style.replaceAll("movable=0;resizable=0;rotatable=0;deletable=0;editable=0;connectable=0;", "");
            }
            elm.addAttribute(STYLE, style);
        }
        elm.addAttribute("type", this.getType(obj));
        elm.addAttribute("parent", this.getParentContainerId(ctx, obj));
        if (this.edge == 1) {
            elm.addAttribute("edge", Integer.toString(this.edge));
        } else {
            elm.addAttribute("vertex", Integer.toString(this.vertex));
            if (ctx.getTraversedNodeIds().contains(id) && !ctx.getSkipNodeIds().contains(id) || ctx.getCurrentNodeIds().contains(id) || ctx.getCanceledNodeIds().contains(id)) {
                elm.addAttribute("showRecords", "true");
            } else {
                elm.addAttribute("showRecords", "false");
            }
        }
    }

    protected String getLockedStyle(String style) {
        if (style.indexOf("movable=0;resizable=0;rotatable=0;deletable=0;editable=0;connectable=0;") > -1) {
            return style;
        }
        if (style.endsWith(";")) {
            return String.format("%s%s", style, "movable=0;resizable=0;rotatable=0;deletable=0;editable=0;connectable=0;");
        }
        return String.format("%s;%s", style, "movable=0;resizable=0;rotatable=0;deletable=0;editable=0;connectable=0;");
    }

    protected void encodeGeometry(GraphCodecContext ctx, Node node, Object obj) {
        if (this.edge == 1) {
            List<GraphicInfo> graphics = ctx.getModel().getFlowLocationMap().get(this.getId(obj));
            this.appendGeometry(ctx, node, graphics);
        } else {
            GraphicInfo graphic = ctx.getModel().getLocationMap().get(this.getId(obj));
            this.appendGeometry(ctx, node, graphic);
        }
    }

    protected void encodeProperties(GraphCodecContext ctx, Node node, Object obj) {
        try {
            List<Property> properties = GraphCodecUtils.getNodeProperties(ctx.getModelType(), this.getType(obj));
            if (properties != null && !properties.isEmpty()) {
                Element object = ((Element)node).addElement(OBJECT);
                for (Property prop : properties) {
                    this.encodeProperty(ctx, node, prop, obj, object);
                }
                object.addAttribute("as", "properties");
            }
        }
        catch (Exception e) {
            logger.error(String.format("BpmnModel\u8f6cGraph Xml\u51fa\u9519\uff01 %s", e.getMessage()), (Throwable)e);
        }
    }

    protected void encodeProperty(GraphCodecContext ctx, Node node, Property prop, Object obj, Element properties) {
        try {
            String groupId = null;
            String propName = null;
            boolean isGroupProp = false;
            Element group = null;
            propName = prop.getPropertyName();
            groupId = prop.getGroupId();
            isGroupProp = groupId != null && !"base".equals(groupId);
            Object value = this.getPropertyValue(obj, prop, isGroupProp);
            if (GraphCodecUtils.isNull(value)) {
                return;
            }
            if (isGroupProp) {
                group = (Element)properties.selectSingleNode("Object[@as='" + groupId + "']");
                if (group == null) {
                    group = properties.addElement(OBJECT);
                }
                this.addPropNode(ctx, group, value, prop.getPropertyName());
                Attribute as = group.attribute("as");
                if (as != null) {
                    group.remove(as);
                    group.add(as);
                } else {
                    group.addAttribute("as", groupId);
                }
            } else {
                this.addPropNode(ctx, properties, value, propName);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected void encodeData(GraphCodecContext ctx, Element elm, Object obj) {
        if (obj instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)obj;
            Map<String, Object> datas = flowElement.getDatas();
            if (datas == null || datas.isEmpty()) {
                return;
            }
            Element propsElement = elm.element("properties");
            if (propsElement == null) {
                propsElement = elm.addElement(OBJECT);
                propsElement.addAttribute("as", "properties");
            }
            for (Map.Entry<String, Object> entry : datas.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.addPropNode(ctx, propsElement, value, key);
            }
        }
    }

    protected Object getPropertyValue(Object obj, Property prop, boolean isGroupProp) {
        try {
            String propName = prop.getPropertyName();
            String propKey = isGroupProp ? prop.getGroupId() + "." + propName : propName;
            Object value = GraphCodecUtils.safeGetPropertyValue(obj, propKey);
            if (GraphCodecUtils.isNull(value)) {
                if (isGroupProp && this.needFindInGroup(prop, obj)) {
                    value = GraphCodecUtils.safeGetPropertyValue(obj, propName);
                    if (GraphCodecUtils.isNull(value)) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected boolean needFindInGroup(Property prop, Object obj) {
        return true;
    }

    protected void addPropNode(GraphCodecContext ctx, Element node, Object obj, String propName) {
        try {
            if (obj == null) {
                return;
            }
            if (propName != null && GraphCodecUtils.isBaseDataType(obj.getClass())) {
                String value = obj.toString();
                node.addAttribute(propName, value);
            } else if (ARRAY.equalsIgnoreCase(node.getName()) && GraphCodecUtils.isBaseDataType(obj.getClass())) {
                Element object = node.addElement("add");
                object.addAttribute("value", String.valueOf(obj));
            } else {
                this.addReferPropNode(ctx, node, obj, propName);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected void addReferPropNode(GraphCodecContext ctx, Element node, Object obj, String propName) {
        try {
            if (obj instanceof List) {
                this.addListNode(ctx, node, (List)obj, propName);
            } else if (obj instanceof Map) {
                this.addMapNode(ctx, node, (Map)obj, propName);
            } else if (obj instanceof Object[]) {
                this.addArrayNode(ctx, node, (Object[])obj, propName);
            } else {
                this.addObjectNode(ctx, node, obj, propName);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected void addMapNode(GraphCodecContext ctx, Element node, Map<String, Object> map, String propName) {
        try {
            Element object = node.addElement(OBJECT);
            Object value = null;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                value = entry.getValue();
                this.addPropNode(ctx, object, value, key);
            }
            if (propName != null) {
                object.addAttribute("as", propName);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected void addObjectNode(GraphCodecContext ctx, Element node, Object obj, String propName) {
        try {
            PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Object)obj);
            if (descriptors != null) {
                Element object = node.addElement(OBJECT);
                for (PropertyDescriptor descriptor : descriptors) {
                    Object value;
                    String name;
                    if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || this.isIgnore(ctx, obj, descriptor) || !PropertyUtils.isReadable((Object)obj, (String)(name = descriptor.getName())) || this.isIgnore(name) || GraphCodecUtils.isNull(value = PropertyUtils.getProperty((Object)obj, (String)name))) continue;
                    this.addPropNode(ctx, object, value, name);
                }
                if (propName != null) {
                    object.addAttribute("as", propName);
                }
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    private boolean isIgnore(GraphCodecContext ctx, Object obj, PropertyDescriptor descriptor) {
        TransIgnore ignore = descriptor.getReadMethod().getAnnotation(TransIgnore.class);
        return ignore != null && ignore.adapterClass() == null || ignore != null && ignore.adapterClass() != null && ignore.adapterClass().length > 0 && !ignore.adapterClass()[0].equals(ctx.getCurrentNode().getClass());
    }

    protected boolean isIgnore(String name) {
        return GraphCodecUtils.isIgnore(name);
    }

    protected void addListNode(GraphCodecContext ctx, Element node, List<Object> list, String propName) {
        Element array = node.addElement(ARRAY);
        for (Object obj : list) {
            this.addPropNode(ctx, array, obj, null);
        }
        array.addAttribute("as", propName);
    }

    protected void addArrayNode(GraphCodecContext ctx, Element node, Object[] arr, String propName) {
        Element array = node.addElement(ARRAY);
        for (Object obj : arr) {
            this.addPropNode(ctx, array, obj, null);
        }
        array.addAttribute("as", propName);
    }

    protected String getName(Object obj, GraphCodecContext ctx) {
        if (obj instanceof BaseElement) {
            BaseElement element = (BaseElement)obj;
            if (ctx.isViewFlowchart()) {
                return this.getNameInFlowchart(element, ctx);
            }
            return element.getName();
        }
        return "";
    }

    protected String getNameInFlowchart(BaseElement element, GraphCodecContext ctx) {
        if (element instanceof FlowNode) {
            CommentEntity comment;
            if (ctx.getHangupNodeIds().contains(element.getId())) {
                if ("BizFlowModel".equalsIgnoreCase(ctx.getModelType())) {
                    return String.format("%s %s", element.getName(), WFMultiLangConstants.getAbnormalErrorStateName());
                }
                return String.format("%s %s", element.getName(), WFMultiLangConstants.getAbnormalHangUpStateName());
            }
            String map = ctx.getManualHangUpNodeIds().get(element.getId());
            if (map != null) {
                String stateName = WFMultiLangConstants.getManualHangUpStateName();
                if ("subProcess".equals(map)) {
                    stateName = WFMultiLangConstants.getAbnormalHangUpStateName();
                }
                String participants = GraphCodecUtils.getCurrentParticipants(ctx, stateName, element.getId());
                return String.format("%s %s%s", element.getName(), participants, stateName);
            }
            if (ctx.getCurrentNodeIds().contains(element.getId())) {
                String nodeTitle = this.rebuildNodeTitle(element, ctx);
                if (WfUtils.isNotEmpty(nodeTitle)) {
                    return nodeTitle;
                }
                String stateName = GraphCodecUtils.getHandleStateName(ctx);
                String participants = GraphCodecUtils.getCurrentParticipants(ctx, stateName, element.getId());
                return String.format("%s %s%s", element.getName(), participants, stateName);
            }
            if (ctx.getCommentMap() != null && (comment = ctx.getCommentMap().get(element.getId())) != null && element instanceof UserTask) {
                String assignee;
                UserTask userTask = (UserTask)element;
                ParticipatantModel participantModel = userTask.getParticipant();
                String displayInfo = null;
                if (participantModel != null) {
                    displayInfo = participantModel.getDisplayInfo();
                }
                if (WfUtils.isEmpty(assignee = String.valueOf(comment.getUserNameFormatter())) || "null".equalsIgnoreCase(assignee)) {
                    assignee = "";
                } else if (!WfConfigurationUtil.isDisplaySetting() && WfUtils.isEmpty(displayInfo)) {
                    assignee = String.valueOf(comment.getTaskAssignee());
                    if (WfUtils.isEmpty(assignee) || "null".equalsIgnoreCase(assignee)) {
                        assignee = "";
                    }
                    ILocaleString assignorName = comment.getAssignorName();
                    if (!(WfUtils.isEmpty(comment.getOwnerId()) || WfUtils.isEmpty(assignorName) || WfUtils.isEmpty(assignee))) {
                        assignee = TaskDelegateUtil.getDelegateAssigneeName(assignorName.toString(), assignee, "replace");
                    }
                }
                return String.format("%s %s %s", element.getName(), assignee, comment.getResultName() != null ? comment.getResultName() : "");
            }
        }
        return element.getName();
    }

    protected String getStyle(Object obj, GraphCodecContext ctx) {
        String style = this.getOriginalStyle(obj, ctx);
        if (style == null) {
            return null;
        }
        String id = this.getId(obj);
        String suffix = "";
        String fontColor = "";
        boolean isBizFlow = "BizFlowModel".equals(ctx.getModelType());
        if (ctx.getHangupNodeIds().contains(id)) {
            suffix = "HANGUP";
            if (!isBizFlow) {
                style = this.updateStyleProperty(style, "ellipsisBackgroundColor", "#FEE6E6");
            }
        } else if (ctx.getCurrentNodeIds().contains(id)) {
            suffix = "PROCESSING";
            if (isBizFlow) {
                fontColor = null;
            } else {
                fontColor = "#FFFFFF";
                style = this.updateStyleProperty(style, "ellipsisBackgroundColor", "#4F99F2");
            }
        } else if (ctx.getSkipNodeIds().contains(id)) {
            suffix = "SKIP";
            fontColor = "#BBBBBB";
        } else if (ctx.getCanceledNodeIds().contains(id)) {
            suffix = "CANCEL";
        } else if (ctx.getTraversedNodeIds().contains(id)) {
            suffix = "TRAVERSED";
        } else if (isBizFlow && ctx.isViewFlowchart() && style.indexOf("ierp.bizflow") > -1) {
            suffix = "UNTRAVERSED";
        }
        if (isBizFlow) {
            style = this.updateStyleProperty(style, "resizable", "0");
        }
        if (!"".equals(fontColor)) {
            style = this.updateStyleProperty(style, "fontColor", fontColor);
        }
        if (!"".equals(suffix)) {
            style = style.replaceFirst(String.format("(shape=ierp\\.\\w+\\.%s);", this.getType(obj)), String.format("%s_%s;", "$1", suffix));
        }
        return style;
    }

    protected String updateStyleProperty(String style, String property, String value) {
        return GraphCodecUtils.updateStyleProperty(style, property, value);
    }

    protected String getOriginalStyle(Object obj, GraphCodecContext ctx) {
        String style = null;
        try {
            style = (String)GraphCodecUtils.safeGetPropertyValue(obj, STYLE);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return style != null ? style : "";
    }

    protected String getId(Object obj) {
        if (obj instanceof BaseElement) {
            return ((BaseElement)obj).getId();
        }
        return "";
    }

    protected Node appendGeometry(GraphCodecContext ctx, Node node, Object geometry) {
        GraphObjectCodec codec = GraphCodecRegistry.getCodec(GraphicInfo.class);
        return codec.encode(ctx, geometry, node);
    }

    @Override
    protected <T> T initDefaultElement(T element, ElementType elementType) {
        if ((element = super.initDefaultElement(element, elementType)) instanceof FlowElement) {
            FlowElement flow = (FlowElement)element;
            flow.setType(this.getType());
            flow.setStyle(this.getStyle((Object)flow, elementType));
            this.initProperties(flow, elementType, new HashMap<String, Object>());
        } else {
            logger.error("can not initiation class: " + element.getClass());
        }
        return element;
    }

    @Override
    protected Object initiation(Object obj, ElementType elementType, GraphCodecContext context) {
        if ((obj = super.initiation(obj, elementType, context)) instanceof FlowElement) {
            Map<String, Object> config = context.getConfig();
            FlowElement flow = (FlowElement)obj;
            flow.setType(this.getStencilType());
            Process process = context.getModel().getMainProcess();
            int size = process.getFlowElementMap().size();
            String procNumber = process.getId();
            Object number = config.get("number");
            if (WfUtils.isNotEmptyString(number)) {
                flow.setNumber(number.toString());
            } else {
                int i = 1;
                String key = String.format("%s%s", this.getStencilType(), size + i);
                while (process.getFlowElementMap().get(String.format("%s_%s", procNumber, key)) != null) {
                    key = String.format("%s%s", this.getStencilType(), size + ++i);
                }
                flow.setNumber(key);
            }
            Object id = config.get("itemId");
            if (WfUtils.isNotEmptyString(id)) {
                flow.setId(id.toString());
            } else {
                flow.setId(String.format("%s_%s", procNumber, flow.getNumber()));
            }
            flow.setStyle(this.getStyle(obj, elementType));
            this.setGraphicInfo(flow, context);
            this.initProperties(flow, elementType, config, process);
            return flow;
        }
        return obj;
    }

    protected void setGraphicInfo(Object obj, GraphCodecContext context) {
        if (obj instanceof BaseElement) {
            boolean isDynamic;
            BaseElement elt = (BaseElement)obj;
            BpmnModel bpmnModel = context.getModel();
            Map<String, Object> config = context.getConfig();
            if (bpmnModel == null) {
                return;
            }
            String eltId = elt.getId();
            List elements = (List)bpmnModel.getMainProcess().getFlowElements();
            int size = elements.size();
            int x = this.getX();
            int y = this.getY();
            if (x == 0) {
                x = (826 - this.getWidth(context)) / 2;
            }
            Object setReference = config.get("set_nodes_reference");
            Object isDynamicNode = config.get("is_dynamic_node");
            boolean bl = isDynamic = isDynamicNode != null && (Boolean)isDynamicNode == true;
            if (size > 0 && !isDynamic && (setReference == null || ((Boolean)setReference).booleanValue())) {
                FlowElement prevNode = (FlowElement)elements.get(size - 1);
                if (elt instanceof SequenceFlow) {
                    SequenceFlow flow = (SequenceFlow)elt;
                    if (prevNode instanceof FlowNode) {
                        FlowNode node = (FlowNode)prevNode;
                        node.getOutgoingFlows().add(flow);
                        flow.setSourceRef(prevNode.getId());
                        flow.setSourceFlowElement(flow);
                    }
                } else if (elt instanceof FlowNode) {
                    FlowNode node = (FlowNode)elt;
                    if (prevNode instanceof SequenceFlow) {
                        SequenceFlow flow = (SequenceFlow)prevNode;
                        FlowElement beforePrev = (FlowElement)elements.get(size - 2);
                        node.getIncomingFlows().add(flow);
                        flow.setTargetRef(node.getId());
                        flow.setTargetFlowElement(node);
                        if (y == 0) {
                            GraphicInfo graphic = bpmnModel.getGraphicInfo(beforePrev.getId());
                            y = (int)((double)y + (graphic.getY() + graphic.getHeight() + 70.0));
                        }
                    }
                }
            }
            if (elt instanceof SequenceFlow) {
                ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
                bpmnModel.addFlowGraphicInfoList(eltId, graphicInfoList);
            } else {
                GraphicInfo graphicInfo = new GraphicInfo();
                graphicInfo.setWidth(this.getWidth(context));
                graphicInfo.setHeight(this.getHeight(context));
                graphicInfo.setX(x);
                graphicInfo.setY(y);
                bpmnModel.addGraphicInfo(eltId, graphicInfo);
            }
        }
    }

    protected void initProperties(Object obj, ElementType element, Map<String, Object> config) {
        this.initProperties(obj, element, config, null);
    }

    protected void initProperties(Object obj, ElementType element, Map<String, Object> config, Process process) {
        List properties = element.getProperties();
        Map<String, Object> isvPropsConfig = ModelConfigUtil.getISVModelPropertiesConfig(element.getId());
        for (Property property : properties) {
            this.initProperty(obj, property, config, process, isvPropsConfig);
        }
    }

    protected Object initProperty(Object obj, Property property, Map<String, Object> config, Process process, Map<String, Object> isvPropsConfig) {
        Object defaultVal = null;
        try {
            String groupId = property.getGroupId();
            String propName = property.getPropertyName();
            String key = null;
            boolean isGroupProp = groupId != null && !"base".equals(groupId);
            key = isGroupProp ? groupId + "." + propName : propName;
            Object specialVal = config.get(key);
            if (specialVal != null) {
                GraphCodecUtils.safeSetPropertyValue(obj, key, specialVal);
                return specialVal;
            }
            specialVal = config.get(propName);
            if (specialVal != null) {
                GraphCodecUtils.safeSetPropertyValue(obj, propName, specialVal);
                return specialVal;
            }
            if (isvPropsConfig != null) {
                defaultVal = BpmnModelUtil.getProperty(isvPropsConfig, key);
            }
            if (defaultVal == null) {
                Map editor = property.getEditor();
                if (editor == null) {
                    return null;
                }
                defaultVal = editor.get("default");
                if (defaultVal == null) {
                    return null;
                }
            }
            ElementValueContext valueContext = new ElementValueContext(process, obj);
            defaultVal = GraphCodecUtils.handlSpecialValue(valueContext, defaultVal);
            if (isGroupProp) {
                this.setGroupPropValue(obj, groupId, propName, defaultVal);
            } else {
                this.setBasePropValue(obj, propName, defaultVal);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return defaultVal;
    }

    protected void setBasePropValue(Object obj, String propName, Object defaultVal) {
        try {
            if (PropertyUtils.isWriteable((Object)obj, (String)propName)) {
                PropertyUtils.setProperty((Object)obj, (String)propName, (Object)defaultVal);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected void setGroupPropValue(Object obj, String groupId, String propName, Object defaultVal) {
        try {
            boolean isBaseProp = false;
            if (!PropertyUtils.isReadable((Object)obj, (String)groupId) && !(isBaseProp = PropertyUtils.isReadable((Object)obj, (String)propName))) {
                return;
            }
            if (isBaseProp) {
                this.setBasePropValue(obj, propName, defaultVal);
            } else {
                Object group = PropertyUtils.getProperty((Object)obj, (String)groupId);
                if (group == null) {
                    PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)obj, (String)groupId);
                    group = TypesContainer.createInstance(desc.getPropertyType());
                }
                if (PropertyUtils.isWriteable((Object)obj, (String)groupId) && PropertyUtils.isWriteable((Object)group, (String)propName)) {
                    PropertyUtils.setProperty((Object)group, (String)propName, (Object)defaultVal);
                    PropertyUtils.setProperty((Object)obj, (String)groupId, (Object)group);
                }
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    protected List<GraphPoint> findFreeConnectPoints(GraphCodecContext ctx, FlowNode vertex) {
        return this.findFreeConnectPoints(ctx, vertex, null);
    }

    protected List<GraphPoint> findFreeConnectPoints(GraphCodecContext ctx, FlowNode vertex, List<GraphPoint> priorPoints) {
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        if (priorPoints == null || priorPoints.isEmpty()) {
            points.addAll(this.connectPoints);
        } else {
            points.addAll(priorPoints);
        }
        List<SequenceFlow> incoming = vertex.getIncomingFlows();
        List<SequenceFlow> outgoing = vertex.getOutgoingFlows();
        String x = null;
        String y = null;
        BpmnModel bpmnModel = ctx.getModel();
        for (SequenceFlow flow : incoming) {
            flow = (SequenceFlow)bpmnModel.getFlowElement(flow.getId());
            x = GraphCodecUtils.getStyleValue(flow.getStyle(), "entryX", "0.5");
            y = GraphCodecUtils.getStyleValue(flow.getStyle(), "entryY", "0");
            points.remove(new GraphPoint(x, y));
        }
        for (SequenceFlow flow : outgoing) {
            flow = (SequenceFlow)bpmnModel.getFlowElement(flow.getId());
            x = GraphCodecUtils.getStyleValue(flow.getStyle(), "exitX", "0.5");
            y = GraphCodecUtils.getStyleValue(flow.getStyle(), "exitY", "1");
            points.remove(new GraphPoint(x, y));
        }
        return points;
    }

    protected String getStyle(Object element, ElementType elementType) {
        String baseType = WfUtils.isNotEmpty(elementType.getExtendClassName()) ? elementType.getExtendClassName() : "bpmn";
        return String.format(this.styleTpl, baseType, this.getType(element));
    }

    protected String rebuildNodeTitle(BaseElement element, GraphCodecContext ctx) {
        return null;
    }
}

