/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.ArrayList;
import java.util.Hashtable;
import kd.bos.workflow.bpmn.graph.codec.AuditTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.AutoMicroServiceTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.AutoTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.BillTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.BoundaryEventCodec;
import kd.bos.workflow.bpmn.graph.codec.BroadcastTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.CallActivityCodec;
import kd.bos.workflow.bpmn.graph.codec.CompensateTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.EndEventCodec;
import kd.bos.workflow.bpmn.graph.codec.EventSubProcessCodec;
import kd.bos.workflow.bpmn.graph.codec.GatewayCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphGeometryCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphModelCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphObjectCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphProcessCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphRectangleCodec;
import kd.bos.workflow.bpmn.graph.codec.JudgeTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.LaneCodec;
import kd.bos.workflow.bpmn.graph.codec.NotifyTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.PoolCodec;
import kd.bos.workflow.bpmn.graph.codec.RPATaskCodec;
import kd.bos.workflow.bpmn.graph.codec.SequenceFlowCodec;
import kd.bos.workflow.bpmn.graph.codec.StartEventCodec;
import kd.bos.workflow.bpmn.graph.codec.UserTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.WaitTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.YunzhijiaTaskCodec;
import kd.bos.workflow.bpmn.graph.model.GraphRectangle;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoMicroServiceTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.BroadcastTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.CompensateTask;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.InclusiveGateway;
import kd.bos.workflow.bpmn.model.JudgeTask;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.Pool;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.RPATask;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;

public class GraphCodecRegistry {
    protected static Hashtable<Class<?>, GraphObjectCodec> codecs = new Hashtable();
    protected static Hashtable<String, GraphObjectCodec> strCodecs = new Hashtable();

    public static GraphObjectCodec getCodec(Class<?> clazz) {
        GraphObjectCodec codec = codecs.get(clazz);
        if (codec != null) {
            return codec;
        }
        return codecs.get(Object.class);
    }

    public static GraphObjectCodec getCodec(String stencilType) {
        GraphObjectCodec codec = strCodecs.get(stencilType);
        if (codec != null) {
            return codec;
        }
        return codecs.get(Object.class);
    }

    static {
        codecs.put(ArrayList.class, new GraphObjectCodec("Array"));
        codecs.put(Object.class, new GraphObjectCodec("Object"));
        GraphModelCodec modelCodec = new GraphModelCodec();
        GraphProcessCodec processCodec = new GraphProcessCodec();
        GraphGeometryCodec geometryCodec = new GraphGeometryCodec();
        GraphRectangleCodec rectangleCodec = new GraphRectangleCodec();
        SequenceFlowCodec sequenceFlowCodec = new SequenceFlowCodec();
        StartEventCodec startEventCodec = new StartEventCodec();
        EndEventCodec endEventCodec = new EndEventCodec();
        UserTaskCodec userTaskCodec = new UserTaskCodec();
        YunzhijiaTaskCodec yunzhijiaTaskCodec = new YunzhijiaTaskCodec();
        AuditTaskCodec auditTaskCodec = new AuditTaskCodec();
        NotifyTaskCodec notifyTaskCodec = new NotifyTaskCodec();
        AutoTaskCodec autoTaskCodec = new AutoTaskCodec();
        RPATaskCodec rpaTaskCodec = new RPATaskCodec();
        EventSubProcessCodec eventSubProcessCodec = new EventSubProcessCodec();
        BoundaryEventCodec boundaryEventCodec = new BoundaryEventCodec();
        WaitTaskCodec waitTaskCodec = new WaitTaskCodec();
        BroadcastTaskCodec broadcastTaskCodec = new BroadcastTaskCodec();
        GatewayCodec gatewayCodec = new GatewayCodec();
        CallActivityCodec callActivityCodec = new CallActivityCodec();
        BillTaskCodec billTaskCodec = new BillTaskCodec();
        AutoMicroServiceTaskCodec autoMicroServiceCodec = new AutoMicroServiceTaskCodec();
        JudgeTaskCodec judgeTaskCodec = new JudgeTaskCodec();
        PoolCodec poolCodec = new PoolCodec();
        LaneCodec laneCodec = new LaneCodec();
        CompensateTaskCodec compensateCodec = new CompensateTaskCodec();
        codecs.put(BpmnModel.class, modelCodec);
        codecs.put(Process.class, processCodec);
        codecs.put(GraphicInfo.class, geometryCodec);
        codecs.put(GraphRectangle.class, rectangleCodec);
        codecs.put(SequenceFlow.class, sequenceFlowCodec);
        codecs.put(StartEvent.class, startEventCodec);
        codecs.put(EndEvent.class, endEventCodec);
        codecs.put(UserTask.class, userTaskCodec);
        codecs.put(YunzhijiaTask.class, yunzhijiaTaskCodec);
        codecs.put(AuditTask.class, auditTaskCodec);
        codecs.put(NotifyTask.class, notifyTaskCodec);
        codecs.put(AutoTask.class, autoTaskCodec);
        codecs.put(RPATask.class, rpaTaskCodec);
        codecs.put(EventSubProcess.class, eventSubProcessCodec);
        codecs.put(BoundaryEvent.class, boundaryEventCodec);
        codecs.put(WaitTask.class, waitTaskCodec);
        codecs.put(BroadcastTask.class, broadcastTaskCodec);
        codecs.put(InclusiveGateway.class, gatewayCodec);
        codecs.put(CallActivity.class, callActivityCodec);
        codecs.put(BillTask.class, billTaskCodec);
        codecs.put(AutoMicroServiceTask.class, autoMicroServiceCodec);
        codecs.put(JudgeTask.class, judgeTaskCodec);
        codecs.put(Pool.class, poolCodec);
        codecs.put(Lane.class, laneCodec);
        codecs.put(CompensateTask.class, compensateCodec);
        strCodecs.put("BpmnModel", modelCodec);
        strCodecs.put("Process", processCodec);
        strCodecs.put("StartNoneEvent", startEventCodec);
        strCodecs.put("StartTimerEvent", startEventCodec);
        strCodecs.put("StartMessageEvent", startEventCodec);
        strCodecs.put("StartSignalEvent", startEventCodec);
        strCodecs.put("StartErrorEvent", startEventCodec);
        strCodecs.put("EndNoneEvent", endEventCodec);
        strCodecs.put("EndErrorEvent", endEventCodec);
        strCodecs.put("EndCancelEvent", endEventCodec);
        strCodecs.put("EndTerminateEvent", endEventCodec);
        strCodecs.put("UserTask", userTaskCodec);
        strCodecs.put("AuditTask", auditTaskCodec);
        strCodecs.put("NotifyTask", notifyTaskCodec);
        strCodecs.put("YunzhijiaTask", yunzhijiaTaskCodec);
        strCodecs.put("SequenceFlow", sequenceFlowCodec);
        strCodecs.put("BillTask", billTaskCodec);
        strCodecs.put("AutoTask", autoTaskCodec);
        strCodecs.put("Pool", poolCodec);
        strCodecs.put("Lane", laneCodec);
        strCodecs.put("RPATask", rpaTaskCodec);
        strCodecs.put("BoundaryTimerEvent", boundaryEventCodec);
        strCodecs.put("BoundaryErrorEvent", boundaryEventCodec);
        strCodecs.put("BoundarySignalEvent", boundaryEventCodec);
        strCodecs.put("BoundaryMessageEvent", boundaryEventCodec);
        strCodecs.put("BoundaryCancelEvent", boundaryEventCodec);
        strCodecs.put("BoundaryCompensateEvent", boundaryEventCodec);
        strCodecs.put("WaitTask", waitTaskCodec);
        strCodecs.put("BroadcastTask", broadcastTaskCodec);
        strCodecs.put("AutoMicroServiceTask", autoMicroServiceCodec);
        strCodecs.put("JudgeTask", judgeTaskCodec);
        strCodecs.put("InclusiveGateway", gatewayCodec);
        strCodecs.put("CallActivity", callActivityCodec);
        strCodecs.put("CompensateTask", compensateCodec);
    }
}

