/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.codec.GraphObjectCodec;
import kd.bos.workflow.bpmn.graph.model.GraphPoint;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.GraphicOffset;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class GraphGeometryCodec
extends GraphObjectCodec {
    public GraphGeometryCodec() {
        super("mxGeometry");
    }

    @Override
    protected void encodeObject(GraphCodecContext ctx, Object obj, Node node) {
        if (obj != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            if (obj instanceof GraphicInfo) {
                GraphicInfo graphic = (GraphicInfo)obj;
                elm.addAttribute("width", Double.toString(graphic.getWidth()));
                elm.addAttribute("height", Double.toString(graphic.getHeight()));
                BaseElement cell = ctx.getCurrentNode();
                if (!(cell instanceof FlowElement) || !((FlowElement)cell).isDynamic()) {
                    elm.addAttribute("x", Double.toString(graphic.getX()));
                    elm.addAttribute("y", Double.toString(graphic.getY()));
                    if (graphic.isRelative()) {
                        elm.addAttribute("relative", String.valueOf(graphic.isRelative()));
                        GraphicOffset offset = graphic.getOffset();
                        Element offsetPoint = this.createMxPoint(ctx, elm, offset.getX(), offset.getY());
                        offsetPoint.addAttribute("as", "offset");
                    }
                } else {
                    this.setDynamicNodeGraphic(ctx, cell, elm);
                }
            } else if (obj instanceof List) {
                elm.addAttribute("relative", "1");
                List graphics = (List)obj;
                if (graphics.size() > 0) {
                    Element array = elm.addElement("Array");
                    for (GraphicInfo graphic : graphics) {
                        if (graphic.getTerminalPointType() == null) {
                            this.createMxPoint(ctx, array, graphic.getX(), graphic.getY());
                            continue;
                        }
                        this.createTerminalPoint(elm, graphic);
                    }
                    array.addAttribute("as", "points");
                }
            }
            elm.addAttribute("as", "geometry");
        }
    }

    private Element createMxPoint(GraphCodecContext ctx, Element array, double x, double y) {
        Element mxPoint = array.addElement("mxPoint");
        mxPoint.addAttribute("x", Double.toString(x));
        mxPoint.addAttribute("y", Double.toString(y));
        return mxPoint;
    }

    private Element createTerminalPoint(Element elm, GraphicInfo graphic) {
        Element point = elm.addElement("mxPoint");
        point.addAttribute("x", Double.toString(graphic.getX()));
        point.addAttribute("y", Double.toString(graphic.getY()));
        point.addAttribute("as", graphic.getTerminalPointType());
        return point;
    }

    private void setDynamicNodeGraphic(GraphCodecContext ctx, BaseElement cell, Element elm) {
        if (cell instanceof FlowNode) {
            FlowNode node = (FlowNode)cell;
            List<SequenceFlow> flows = node.getIncomingFlows();
            FlowNode prevNode = null;
            SequenceFlow dynFlow = null;
            for (SequenceFlow flow : flows) {
                if (!flow.isDynamic()) continue;
                dynFlow = flow;
                prevNode = (FlowNode)flow.getSourceFlowElement();
                break;
            }
            if (prevNode != null) {
                String defaultY;
                String defaultX;
                ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
                points.add(new GraphPoint("0", "0.5"));
                points.add(new GraphPoint("1", "0.5"));
                String x = null;
                String y = null;
                Map<String, GraphicInfo> locationMap = ctx.getModel().getLocationMap();
                GraphicInfo prevGraphic = locationMap.get(prevNode.getId());
                GraphicInfo cellGraphic = locationMap.get(cell.getId());
                flows = prevNode.getIncomingFlows();
                for (SequenceFlow flow : flows) {
                    if (flow.isDynamic()) continue;
                    GraphicInfo srcLocation = locationMap.get(flow.getSourceRef());
                    defaultX = "0.5";
                    defaultY = "0";
                    if (srcLocation.getX() - prevGraphic.getX() < 0.0) {
                        defaultX = "0";
                        defaultY = "0.5";
                    } else if (srcLocation.getX() - prevGraphic.getX() > 0.0) {
                        defaultX = "1";
                        defaultY = "0.5";
                    }
                    x = GraphCodecUtils.getStyleValue(flow.getStyle(), "entryX", defaultX);
                    y = GraphCodecUtils.getStyleValue(flow.getStyle(), "entryY", defaultY);
                    points.remove(new GraphPoint(x, y));
                }
                flows = prevNode.getOutgoingFlows();
                for (SequenceFlow flow : flows) {
                    if (flow.isDynamic()) continue;
                    GraphicInfo tgtLocation = locationMap.get(flow.getTargetRef());
                    defaultX = "0.5";
                    defaultY = "1";
                    if (tgtLocation.getX() - prevGraphic.getX() < 0.0) {
                        defaultX = "0";
                        defaultY = "0.5";
                    } else if (tgtLocation.getX() - prevGraphic.getX() > 0.0) {
                        defaultX = "1";
                        defaultY = "0.5";
                    }
                    x = GraphCodecUtils.getStyleValue(flow.getStyle(), "exitX", defaultX);
                    y = GraphCodecUtils.getStyleValue(flow.getStyle(), "exitY", defaultY);
                    points.remove(new GraphPoint(x, y));
                }
                double locX = 0.0;
                int flowLength = this.getStringPerfectWidth(dynFlow != null ? dynFlow.getName() : null);
                locX = points.size() == 1 && "1".equals(((GraphPoint)points.get(0)).getX()) ? prevGraphic.getX() + prevGraphic.getWidth() + 260.0 : prevGraphic.getX() - (prevGraphic.getWidth() + 260.0);
                cellGraphic.setX(locX);
                cellGraphic.setY(prevGraphic.getY() + prevGraphic.getHeight() / 2.0 - cellGraphic.getHeight() / 2.0);
                elm.addAttribute("x", Double.toString(cellGraphic.getX()));
                elm.addAttribute("y", Double.toString(cellGraphic.getY()));
            }
        }
    }

    protected int getStringPerfectWidth(String text) {
        int textWidth = 260;
        if (text == null || text.trim().length() < 8) {
            return textWidth;
        }
        try {
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Font font = new Font("Microsoft YaHei", 0, 12);
            textWidth = (int)font.getStringBounds(text, frc).getWidth() + 30;
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        return Math.max(textWidth, 260);
    }
}

