/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecRegistry;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.codec.GraphObjectCodec;
import kd.bos.workflow.bpmn.graph.model.GraphIcon;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.Pool;
import kd.bos.workflow.bpmn.model.Process;
import org.dom4j.Element;
import org.dom4j.Node;

public class GraphModelCodec
extends GraphObjectCodec {
    public GraphModelCodec() {
        super("mxGraphModel");
    }

    protected void initGraphConfig(Element graph, GraphCodecContext ctx) {
        Map<String, Object> config = ctx.getConfig();
        Object gridEnabled = config.get("gridEnabled");
        if (gridEnabled != null) {
            graph.addAttribute("grid", (Boolean)gridEnabled != false ? "1" : "0");
        } else {
            graph.addAttribute("grid", "0");
        }
    }

    @Override
    protected void encodeObject(GraphCodecContext ctx, Object obj, Node node) {
        if (obj instanceof BpmnModel && node != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            this.initGraphConfig(elm, ctx);
            Element root = elm.addElement("root");
            if (ctx.isConfigScheme()) {
                root.addComment(String.format("Time: %s", System.currentTimeMillis()));
            }
            GraphCodecUtils.appendNode((Node)root, "mxCell", "node_0");
            this.encodeChildren(root, ctx);
        }
    }

    protected void encodeChildren(Element root, GraphCodecContext ctx) {
        this.encodeProcess(root, ctx);
        this.encodeCells(root, ctx);
    }

    protected void encodeProcess(Element root, GraphCodecContext ctx) {
        Process process = ctx.getModel().getMainProcess();
        GraphObjectCodec processCodec = GraphCodecRegistry.getCodec(process.getClass());
        processCodec.encode(ctx, process, (Node)root);
    }

    protected void encodeCells(Element root, GraphCodecContext ctx) {
        BpmnModel bpmnModel = ctx.getModel();
        List<Pool> pools = bpmnModel.getPools();
        if (pools != null && !pools.isEmpty()) {
            for (Pool pool : pools) {
                GraphObjectCodec graphObjectCodec = GraphCodecRegistry.getCodec(pool.getClass());
                ctx.setCurrentNodeParent("node_1");
                graphObjectCodec.encode(ctx, pool, (Node)root);
            }
            HashMap<Process, Set<String>> map = new HashMap<Process, Set<String>>();
            for (Pool pool : pools) {
                Process process = bpmnModel.getProcess(pool.getId());
                Set<String> ids = (Set<String>)map.get(process);
                if (ids == null) {
                    ids = this.getProcessElementsIds(process);
                    map.put(process, ids);
                }
                List<Lane> lanes = process.getLanes();
                for (Lane lane : lanes) {
                    if (!pool.getId().equals(lane.getPoolRef())) continue;
                    this.encodeLaneElements(ctx, lane, (Node)root);
                    ids.removeAll(lane.getFlowReferences());
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                Set elementIds = (Set)entry.getValue();
                if (elementIds == null || elementIds.isEmpty()) continue;
                this.encodeProcessElements((Process)entry.getKey(), elementIds, root, ctx);
            }
        } else {
            this.encodeProcessElements(bpmnModel.getMainProcess(), root, ctx);
        }
    }

    protected void encodeProcessElements(Process process, Element root, GraphCodecContext ctx) {
        this.encodeProcessElements(process, null, root, ctx);
    }

    protected void encodeProcessElements(Process process, Set<String> ids, Element root, GraphCodecContext ctx) {
        Collection<FlowElement> elements = process.getFlowElements();
        for (FlowElement element : elements) {
            if (ids != null && !ids.isEmpty() && !ids.contains(element.getId())) continue;
            GraphObjectCodec codec = GraphCodecRegistry.getCodec(element.getClass());
            ctx.setCurrentNodeParent(process.getResourceId());
            codec.encode(ctx, element, (Node)root);
            this.createGraphIcon(root, ctx, element);
        }
    }

    protected void createGraphIcon(Element root, GraphCodecContext ctx, FlowElement element) {
        GraphIcon icon = element.getIcon();
        if (icon != null) {
            Element child = root.addElement("mxCell");
            child.addAttribute("id", String.format("%s_child", element.getId()));
            child.addAttribute("parent", element.getId());
            child.addAttribute("vertex", "1");
            child.addAttribute("style", icon.getStyle());
            Map<String, String> datas = icon.getIconDatas();
            if (!datas.isEmpty()) {
                Element props = child.addElement("Object");
                for (Map.Entry<String, String> entry : datas.entrySet()) {
                    props.addAttribute(entry.getKey(), entry.getValue());
                }
                props.addAttribute("as", "properties");
            }
            GraphCodecRegistry.getCodec(GraphicInfo.class).encode(ctx, icon.getGraphicInfo(), (Node)child);
        }
    }

    protected void encodeLaneElements(GraphCodecContext ctx, Lane lane, Node root) {
        List<String> references = lane.getFlowReferences();
        List<String> poolFlows = lane.getBeloneToPoolFlows();
        BpmnModel bpmnModel = ctx.getModel();
        Process process = bpmnModel.getProcess(lane.getPoolRef());
        List<FlowElement> elements = process.getFlowElementList();
        for (FlowElement element : elements) {
            GraphObjectCodec codec;
            if (references.contains(element.getId())) {
                codec = GraphCodecRegistry.getCodec(element.getClass());
                ctx.setCurrentNodeParent(lane.getId());
                codec.encode(ctx, element, root);
                continue;
            }
            if (!poolFlows.contains(element.getId())) continue;
            codec = GraphCodecRegistry.getCodec(element.getClass());
            ctx.setCurrentNodeParent(lane.getPoolRef());
            codec.encode(ctx, element, root);
        }
    }

    protected Set<String> getProcessElementsIds(Process process) {
        Collection<FlowElement> elements = process.getFlowElements();
        HashSet<String> ids = new HashSet<String>(elements.size());
        for (FlowElement element : elements) {
            ids.add(element.getId());
        }
        return ids;
    }

    @Override
    protected int getHeight(GraphCodecContext context) {
        return 1169;
    }

    @Override
    protected int getWidth(GraphCodecContext context) {
        return 826;
    }

    @Override
    protected int getX() {
        return 0;
    }

    @Override
    protected int getY() {
        return 0;
    }

    @Override
    protected BpmnModel create() {
        BpmnModel model = new BpmnModel();
        return model;
    }

    @Override
    public BpmnModel initiation(ElementType elementType, GraphCodecContext context) {
        return this.initiation(context.getModel(), elementType, context);
    }

    @Override
    protected BpmnModel initiation(Object obj, ElementType elementType, GraphCodecContext context) {
        super.initiation(obj, elementType, context);
        this.setGraphicInfo(context);
        return context.getModel();
    }

    private void setGraphicInfo(GraphCodecContext context) {
        BpmnModel bpmnModel = context.getModel();
        GraphicInfo graphic = new GraphicInfo();
        graphic.setX(this.getX());
        graphic.setY(this.getY());
        graphic.setHeight(this.getHeight(context));
        graphic.setWidth(this.getWidth(context));
        bpmnModel.setLocation(graphic);
    }
}

