/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class GraphObjectCodec {
    protected String tagName;
    protected String type;
    protected Object currentObj;
    protected Log log = LogFactory.getLog(this.getClass());

    public GraphObjectCodec(String tagName) {
        this.tagName = tagName;
    }

    public String getTagName() {
        return this.tagName;
    }

    protected String getStencilType() {
        return this.type;
    }

    protected String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected String getType(Object element) {
        String type;
        if (element instanceof BaseElement && WfUtils.isNotEmpty(type = GraphCodecUtils.getElementType((BaseElement)element))) {
            return type;
        }
        return this.getType();
    }

    protected String getGroup() {
        return null;
    }

    protected String getProcessId(BpmnModel model) {
        return model.getMainProcess().getResourceId();
    }

    protected String getParentContainerId(GraphCodecContext ctx, Object obj) {
        FlowElement element;
        FlowElementsContainer parentContainer;
        BpmnModel model = ctx.getModel();
        String containerId = ctx.getCurrentNodeParent();
        if (WfUtils.isNotEmpty(containerId)) {
            return containerId;
        }
        if (obj instanceof FlowElement && (parentContainer = (element = (FlowElement)obj).getParentContainer()) instanceof Process) {
            containerId = ((Process)parentContainer).getResourceId();
        }
        if (WfUtils.isNotEmpty(containerId)) {
            return containerId;
        }
        return this.getProcessId(model);
    }

    public String encodeFlowElement(GraphCodecContext ctx, BaseElement element) {
        Document document = GraphCodecUtils.createDocument();
        Element node = document.addElement(this.getTagName());
        this.encodeFlowElement(ctx, element, (Node)node);
        return node.asXML();
    }

    public Node encode(GraphCodecContext ctx, Object obj) {
        Document document = GraphCodecUtils.createDocument();
        this.encode(ctx, obj, (Node)document);
        return document;
    }

    protected Node encode(GraphCodecContext ctx, Object obj, Node parent) {
        Element node = null;
        if (parent.getNodeType() == 9) {
            node = ((Document)parent).addElement(this.getTagName());
        } else if (parent.getNodeType() == 1) {
            node = ((Element)parent).addElement(this.getTagName());
        }
        if (node != null) {
            this.setCurrentObj(obj);
            this.beforeEncodeObject(ctx, obj, (Node)node);
            this.encodeObject(ctx, obj, (Node)node);
            this.afterEncodeObject(ctx, obj, (Node)node);
        }
        return node;
    }

    protected void encodeFlowElement(GraphCodecContext ctx, BaseElement obj, Node node) {
    }

    protected void encodeObject(GraphCodecContext ctx, Object obj, Node node) {
    }

    protected void beforeEncodeObject(GraphCodecContext ctx, Object obj, Node node) {
    }

    protected void afterEncodeObject(GraphCodecContext ctx, Object obj, Node node) {
    }

    protected Object create() {
        return new Object();
    }

    public <T> T initDefaultElement(ElementType elementType) {
        return (T)this.initDefaultElement(this.create(), elementType);
    }

    protected <T> T initDefaultElement(T element, ElementType elementType) {
        return element;
    }

    public Object initiation(ElementType elementType, GraphCodecContext context) {
        return this.initiation(this.create(), elementType, context);
    }

    protected Object initiation(Object obj, ElementType elementType, GraphCodecContext context) {
        this.setCurrentObj(obj);
        return obj;
    }

    protected int getHeight(GraphCodecContext context) {
        if ("BizFlowModel".equals(context.getModelType())) {
            return this.getBizFlowNodeHeight();
        }
        return this.getCommonNodeHeight();
    }

    protected int getCommonNodeHeight() {
        return 50;
    }

    protected int getWidth(GraphCodecContext context) {
        if ("BizFlowModel".equals(context.getModelType())) {
            return this.getBizFlowNodeWidth();
        }
        return this.getCommonNodeWidth();
    }

    protected int getCommonNodeWidth() {
        return 150;
    }

    protected int getBizFlowNodeHeight() {
        return 48;
    }

    protected int getBizFlowNodeWidth() {
        return 148;
    }

    protected int getX() {
        return 0;
    }

    protected int getY() {
        return 0;
    }

    public Object getCurrentObj() {
        return this.currentObj;
    }

    public void setCurrentObj(Object currentObj) {
        this.currentObj = currentObj;
    }
}

