/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.KDException;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.graph.codec.GraphCellCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import org.dom4j.Element;
import org.dom4j.Node;

public class GraphProcessCodec
extends GraphCellCodec {
    @Override
    protected void encodeObject(GraphCodecContext ctx, Object obj, Node node) {
        if (obj instanceof Process && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Process process = (Process)obj;
            if (ctx.isCodecProperties()) {
                super.encodeProperties(ctx, node, obj);
            }
            ctx.setModelType(GraphCodecUtils.getModelTypeByProcessType(process.getProcessType()));
            elm.addAttribute("id", process.getResourceId());
            elm.addAttribute("type", this.getType());
            elm.addAttribute("group", this.getGroup());
            elm.addAttribute("parent", "node_0");
            Element properties = elm.element("Object");
            if (properties == null) {
                properties = elm.addElement("Object");
            }
            properties.addAttribute("process_id", process.getId());
            properties.addAttribute("as", "properties");
        }
    }

    @Override
    public String getType() {
        return "Diagram";
    }

    @Override
    protected String getGroup() {
        return "ProcessControl";
    }

    @Override
    protected Process create() {
        return new Process();
    }

    @Override
    protected Process initiation(Object obj, ElementType element, GraphCodecContext context) {
        Process process = (Process)super.initiation(obj, element, context);
        Map<String, Object> config = context.getConfig();
        this.initProperties(process, element, config);
        this.initConfigProperty(process, config);
        return process;
    }

    @Override
    protected void setBasePropValue(Object obj, String propName, Object defaultVal) {
        try {
            if (!"macros".equals(propName)) {
                super.setBasePropValue(obj, propName, defaultVal);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void encodeProperty(GraphCodecContext ctx, Node node, Property prop, Object obj, Element properties) {
        try {
            if (!"macros".equals(prop.getPropertyName())) {
                super.encodeProperty(ctx, node, prop, obj, properties);
            }
        }
        catch (Exception e) {
            throw new WFException(e.getMessage());
        }
    }

    private void initConfigProperty(Process process, Map<String, Object> config) {
        process.setResourceId("node_1");
        String number = config.get("number").toString();
        process.setId(number);
        Object name = config.get("name");
        if (name instanceof ILocaleString) {
            process.setName((ILocaleString)name);
        } else {
            process.setName((ILocaleString)(name != null ? new LocaleString(String.valueOf(name)) : null));
        }
        process.setNumber(number);
        Object documentation = config.get("documentation");
        if (documentation instanceof ILocaleString) {
            process.setDocumentation((ILocaleString)documentation);
        } else {
            process.setDocumentation((ILocaleString)(documentation != null ? new LocaleString(String.valueOf(documentation)) : null));
        }
        process.setBusinessId((String)config.get("businessid"));
        boolean isSubProcess = config.get("subProcess") == null ? false : (Boolean)config.get("subProcess");
        process.setSubProcess(isSubProcess);
    }
}

