/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.List;
import kd.bos.workflow.bpmn.graph.codec.GraphCellCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecRegistry;
import kd.bos.workflow.bpmn.graph.codec.GraphObjectCodec;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.Pool;
import kd.bos.workflow.bpmn.model.Process;
import org.dom4j.Node;

public class PoolCodec
extends GraphCellCodec {
    @Override
    protected String getType() {
        return "Pool";
    }

    @Override
    protected void encodeObject(GraphCodecContext ctx, Object obj, Node node) {
        super.encodeObject(ctx, obj, node);
        if (obj instanceof Pool) {
            Pool pool = (Pool)obj;
            BpmnModel bpmnModel = ctx.getModel();
            Process process = bpmnModel.getProcess(pool.getId());
            List<Lane> lanes = process.getLanes();
            for (Lane lane : lanes) {
                if (!pool.getId().equals(lane.getPoolRef())) continue;
                GraphObjectCodec laneCodec = GraphCodecRegistry.getCodec(lane.getClass());
                ctx.setCurrentNodeParent(pool.getId());
                laneCodec.encode(ctx, lane, (Node)node.getParent());
            }
        }
    }

    @Override
    protected String getGroup() {
        return "FlowControl";
    }

    @Override
    protected Pool create() {
        return new Pool();
    }
}

