/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.graph.codec.GraphCellCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.codec.SequenceFlowLocation;
import kd.bos.workflow.bpmn.graph.model.GraphPoint;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.LinkControlIntensity;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;
import org.dom4j.Element;
import org.dom4j.Node;

public class SequenceFlowCodec
extends GraphCellCodec {
    private final GraphPoint topPoint = new GraphPoint("0.5", "0");
    private final GraphPoint bottomPoint = new GraphPoint("0.5", "1");
    private final GraphPoint leftPoint = new GraphPoint("0", "0.5");
    private final GraphPoint rightPoint = new GraphPoint("1", "0.5");
    private final List<GraphPoint> VERTICAL_PRIOR_POINTS = new ArrayList<GraphPoint>();
    private final List<GraphPoint> HORIZONTAL_PRIOR_POINTS = new ArrayList<GraphPoint>();
    private static final String VALUE = "value";
    private static final String FORMATSHOWVALUE = "%s\\n%s";

    public SequenceFlowCodec() {
        this.edge = 1;
        this.styleTpl = "%sentryX=%s;entryY=%s;exitX=%s;exitY=%s;";
        this.VERTICAL_PRIOR_POINTS.add(this.rightPoint);
        this.VERTICAL_PRIOR_POINTS.add(this.leftPoint);
        this.HORIZONTAL_PRIOR_POINTS.add(this.topPoint);
        this.HORIZONTAL_PRIOR_POINTS.add(this.bottomPoint);
    }

    @Override
    public String getType() {
        return "SequenceFlow";
    }

    @Override
    protected String getStencilType() {
        return "SequenceFlow";
    }

    @Override
    protected String getGroup() {
        return "DesignControl";
    }

    @Override
    protected void beforeEncodeObject(GraphCodecContext ctx, Object obj, Node node) {
        super.beforeEncodeObject(ctx, obj, node);
        SequenceFlow flow = (SequenceFlow)obj;
        FlowElement source = flow.getSourceFlowElement();
        FlowElement target = flow.getTargetFlowElement();
        if (flow.isDynamic() && source != null && target != null && "edgeStyle=orthogonalEdgeStyle;rounded=1;html=1;jettySize=auto;orthogonalLoop=1;".equals(flow.getStyle())) {
            SequenceFlowLocation location = this.getConnectPoints(ctx, (FlowNode)source, (FlowNode)target);
            if (location.getInfos() != null) {
                ctx.getModel().getFlowLocationMap().put(flow.getId(), location.getInfos());
            }
            flow.setStyle(String.format(this.styleTpl, "edgeStyle=orthogonalEdgeStyle;rounded=1;html=1;jettySize=auto;orthogonalLoop=1;", location.getEntryX(), location.getEntryY(), location.getExitX(), location.getExitY()));
        }
    }

    @Override
    protected Object getPropertyValue(Object obj, Property prop, boolean isGroupProp) {
        try {
            if ("defaultflow".equals(prop.getPropertyName())) {
                return SpecialPropertyUtil.getProperty(obj, prop.getPropertyName());
            }
            return super.getPropertyValue(obj, prop, isGroupProp);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setCellCommonAttributes(GraphCodecContext ctx, Node node, Object obj) {
        super.setCellCommonAttributes(ctx, node, obj);
        if (obj instanceof SequenceFlow) {
            SequenceFlow flow = (SequenceFlow)obj;
            Element elm = (Element)node;
            elm.addAttribute("source", flow.getSourceRef());
            elm.addAttribute("target", flow.getTargetRef());
            LinkControlIntensity controlIntensity = flow.getControlIntensity();
            if (controlIntensity != null && (controlIntensity.isBindToPrevNode() || controlIntensity.isBindToNextNode())) {
                Element properties = elm.addElement("Object");
                properties.addAttribute("as", "properties");
                Element group = properties.addElement("Object");
                if (controlIntensity.isBindToPrevNode()) {
                    group.addAttribute("bindToPrevNode", "1");
                }
                if (controlIntensity.isBindToNextNode()) {
                    group.addAttribute("bindToNextNode", "1");
                }
                group.addAttribute("as", "controlIntensity");
            }
            String name = this.getName(obj, ctx);
            BillRelationshipModel billConversionInfo = flow.getBillRelationshipModel();
            if (billConversionInfo != null && "botpTargetBills".equals(billConversionInfo.getRelationType()) && (flow.getTargetFlowElement() instanceof BillTask || flow.getTargetFlowElement() instanceof AutoTask || flow.getTargetFlowElement() instanceof UserTask)) {
                String formatValue = null;
                String conversionMode = billConversionInfo.getConversionMode();
                if ("manualpush".equals(conversionMode)) {
                    formatValue = WFMultiLangConstants.getManualPush();
                } else if ("manualdraw".equals(conversionMode)) {
                    formatValue = WFMultiLangConstants.getManualDraw();
                } else if ("auto".equals(conversionMode)) {
                    formatValue = WFMultiLangConstants.getAutoConvert();
                }
                if (WfUtils.isNotEmpty(formatValue)) {
                    if (WfUtils.isNotEmpty(name)) {
                        elm.addAttribute(VALUE, String.format(FORMATSHOWVALUE, name, formatValue));
                    } else {
                        elm.addAttribute(VALUE, formatValue);
                    }
                }
            }
        }
    }

    @Override
    protected SequenceFlow create() {
        return new SequenceFlow();
    }

    @Override
    protected String getStyle(Object element, ElementType elementType) {
        if ("bizflow".equals(elementType.getExtendClassName())) {
            return String.format("%s%s=%s;", "edgeStyle=orthogonalEdgeStyle;rounded=1;html=1;jettySize=auto;orthogonalLoop=1;", "strokeColor", "#7F93BC");
        }
        return "edgeStyle=orthogonalEdgeStyle;rounded=1;html=1;jettySize=auto;orthogonalLoop=1;";
    }

    @Override
    protected String getStyle(Object obj, GraphCodecContext ctx) {
        String style = this.getOriginalStyle(obj, ctx);
        if (style == null) {
            return null;
        }
        SequenceFlow edge = (SequenceFlow)ctx.getCurrentNode();
        String color = null;
        if (ctx.getPreEdgeIds().contains(edge.getId())) {
            color = "#13BBAD";
            style = this.updateStyleProperty(style, "dashed", "1");
        } else if (ctx.getTraversedEdgeIds().contains(edge.getId())) {
            color = "#7F93BC";
        } else if (edge.getSourceFlowElement() instanceof SubProcess || edge.getTargetFlowElement() instanceof SubProcess) {
            color = "#45A6F9";
            style = style + "startArrow=oval;endArrow=oval;startFill=0;endFill=0;dashed=1;targetPerimeterSpacing=25;sourcePerimeterSpacing=25;";
        } else if ("BizFlowModel".equals(ctx.getModelType()) && ctx.isViewFlowchart()) {
            color = "#C7C7C7";
        } else if (ctx.isBillRelation()) {
            color = "#A1CFFF";
        }
        if (color != null) {
            style = this.updateStyleProperty(style, "strokeColor", String.format("%s!important;", color));
        }
        return style;
    }

    protected SequenceFlowLocation getConnectPoints(GraphCodecContext ctx, FlowNode source, FlowNode target) {
        SequenceFlowLocation optimumLocation = this.getOptimumConnectPoints(ctx, source, target);
        if (target instanceof EventSubProcess) {
            optimumLocation.setEntryX(this.topPoint.getX());
            optimumLocation.setEntryY(this.topPoint.getY());
        } else if (source instanceof EventSubProcess) {
            optimumLocation.setExitX(this.bottomPoint.getX());
            optimumLocation.setExitY(this.bottomPoint.getY());
        }
        return optimumLocation;
    }

    protected SequenceFlowLocation getOptimumConnectPoints(GraphCodecContext ctx, FlowNode source, FlowNode target) {
        boolean isStraightUp;
        if (source.equals(target)) {
            return new SequenceFlowLocation(this.rightPoint.getX(), this.rightPoint.getY(), this.leftPoint.getX(), this.leftPoint.getY());
        }
        BpmnModel bpmnModel = ctx.getModel();
        Map<String, GraphicInfo> locationMap = bpmnModel.getLocationMap();
        GraphicInfo srcLocation = locationMap.get(source.getId());
        GraphicInfo tgtLocation = locationMap.get(target.getId());
        List<GraphPoint> sourcePoints = null;
        List<GraphPoint> targetPoints = null;
        GraphPoint point = null;
        boolean isVertical = true;
        boolean isTopToBottom = srcLocation.getY() - tgtLocation.getY() < 0.0;
        boolean isLeftToRight = srcLocation.getX() - tgtLocation.getX() < 0.0;
        boolean bl = isStraightUp = tgtLocation.getX() >= srcLocation.getX() - 80.0 && tgtLocation.getX() + tgtLocation.getWidth() <= srcLocation.getX() + srcLocation.getWidth() + 80.0;
        if (Math.abs(srcLocation.getY() - tgtLocation.getY()) > srcLocation.getHeight()) {
            point = this.VERTICAL_PRIOR_POINTS.get(0);
            sourcePoints = this.findFreeConnectPoints(ctx, source);
            targetPoints = this.findFreeConnectPoints(ctx, target);
        } else {
            isVertical = false;
            point = this.HORIZONTAL_PRIOR_POINTS.get(0);
            sourcePoints = this.findFreeConnectPoints(ctx, source);
            targetPoints = this.findFreeConnectPoints(ctx, target);
        }
        List<GraphicInfo> infos = null;
        SequenceFlowLocation location = this.getFlowLocation(isVertical, isTopToBottom, isLeftToRight, isStraightUp, sourcePoints, targetPoints);
        if (location != null) {
            return location;
        }
        sourcePoints.retainAll(targetPoints);
        if (!sourcePoints.isEmpty()) {
            point = sourcePoints.get(0);
        } else {
            infos = this.getTurningPoints(ctx, source, target, point, isVertical);
        }
        location = new SequenceFlowLocation(point.getX(), point.getY());
        if (infos != null) {
            location.setInfos(infos);
        }
        return location;
    }

    protected SequenceFlowLocation getFlowLocation(boolean isVertical, boolean isTopToBottom, boolean isLeftToRight, boolean isStraightUp, List<GraphPoint> sourcePoints, List<GraphPoint> targetPoints) {
        if (targetPoints.isEmpty() && sourcePoints.isEmpty()) {
            return null;
        }
        SequenceFlowLocation location = null;
        if (isVertical) {
            if (isTopToBottom) {
                if (sourcePoints.contains(this.bottomPoint) && targetPoints.contains(this.topPoint)) {
                    location = new SequenceFlowLocation(this.topPoint.getX(), this.topPoint.getY(), this.bottomPoint.getX(), this.bottomPoint.getY());
                } else if (!isStraightUp) {
                    location = new SequenceFlowLocation();
                    if (sourcePoints.contains(this.bottomPoint)) {
                        location.setExitX(this.bottomPoint.getX());
                        location.setExitY(this.bottomPoint.getY());
                    } else {
                        location.setExitX(isLeftToRight ? this.rightPoint.getX() : this.leftPoint.getX());
                        location.setExitY(isLeftToRight ? this.rightPoint.getY() : this.leftPoint.getY());
                    }
                    if (targetPoints.contains(this.topPoint)) {
                        location.setEntryX(this.topPoint.getX());
                        location.setEntryY(this.topPoint.getY());
                    } else {
                        location.setEntryX(isLeftToRight ? this.leftPoint.getX() : this.rightPoint.getX());
                        location.setEntryY(isLeftToRight ? this.leftPoint.getY() : this.rightPoint.getY());
                    }
                }
            } else if (sourcePoints.contains(this.topPoint) && targetPoints.contains(this.bottomPoint)) {
                location = new SequenceFlowLocation(this.bottomPoint.getX(), this.bottomPoint.getY(), this.topPoint.getX(), this.topPoint.getY());
            } else if (!isStraightUp) {
                location = new SequenceFlowLocation();
                if (sourcePoints.contains(this.topPoint)) {
                    location.setExitX(this.topPoint.getX());
                    location.setExitY(this.topPoint.getY());
                } else {
                    location.setExitX(isLeftToRight ? this.rightPoint.getX() : this.leftPoint.getX());
                    location.setExitY(isLeftToRight ? this.rightPoint.getY() : this.leftPoint.getY());
                }
                if (targetPoints.contains(this.bottomPoint)) {
                    location.setEntryX(this.bottomPoint.getX());
                    location.setEntryY(this.bottomPoint.getY());
                } else {
                    location.setEntryX(isLeftToRight ? this.leftPoint.getX() : this.rightPoint.getX());
                    location.setEntryY(isLeftToRight ? this.leftPoint.getY() : this.rightPoint.getY());
                }
            }
        } else if (isLeftToRight) {
            if (sourcePoints.contains(this.rightPoint) || targetPoints.contains(this.leftPoint)) {
                location = new SequenceFlowLocation(this.leftPoint.getX(), this.leftPoint.getY(), this.rightPoint.getX(), this.rightPoint.getY());
            }
        } else if (sourcePoints.contains(this.leftPoint) || targetPoints.contains(this.rightPoint)) {
            location = new SequenceFlowLocation(this.rightPoint.getX(), this.rightPoint.getY(), this.leftPoint.getX(), this.leftPoint.getY());
        }
        return location;
    }

    protected List<SequenceFlow> getSequenceFlowByConnectPoint(FlowNode vertex, GraphPoint connectPoint) {
        ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
        List<SequenceFlow> incoming = vertex.getIncomingFlows();
        List<SequenceFlow> outgoing = vertex.getOutgoingFlows();
        String x = null;
        String y = null;
        for (SequenceFlow flow : incoming) {
            x = GraphCodecUtils.getStyleValue(flow.getStyle(), "entryX", "0.5");
            y = GraphCodecUtils.getStyleValue(flow.getStyle(), "entryY", "0");
            if (!x.equals(connectPoint.getX()) || !y.equals(connectPoint.getY())) continue;
            flows.add(flow);
        }
        for (SequenceFlow flow : outgoing) {
            x = GraphCodecUtils.getStyleValue(flow.getStyle(), "exitX", "0.5");
            y = GraphCodecUtils.getStyleValue(flow.getStyle(), "exitY", "1");
            if (!x.equals(connectPoint.getX()) || !y.equals(connectPoint.getY())) continue;
            flows.add(flow);
        }
        return flows;
    }

    protected List<GraphicInfo> getTurningPoints(GraphCodecContext ctx, FlowNode source, FlowNode target, GraphPoint connectPoint, boolean isVertical) {
        int symbol = isVertical && "0".equals(connectPoint.getX()) || !isVertical && "0".equals(connectPoint.getY()) ? -1 : 1;
        ArrayList<GraphicInfo> points = new ArrayList<GraphicInfo>();
        ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
        flows.addAll(this.getSequenceFlowByConnectPoint(source, connectPoint));
        flows.addAll(this.getSequenceFlowByConnectPoint(target, connectPoint));
        Map<String, List<GraphicInfo>> locationMap = ctx.getModel().getFlowLocationMap();
        List<GraphicInfo> infos = null;
        ArrayList<GraphicInfo> turnPoints = new ArrayList<GraphicInfo>();
        for (SequenceFlow flow : flows) {
            infos = locationMap.get(flow.getId());
            if (infos == null || infos.isEmpty()) continue;
            turnPoints.add(infos.get(0));
        }
        Map<String, GraphicInfo> location = ctx.getModel().getLocationMap();
        GraphicInfo sourceLoc = location.get(source.getId());
        GraphicInfo targetLoc = location.get(target.getId());
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        if (isVertical) {
            y1 = sourceLoc.getY() + sourceLoc.getHeight() * Double.parseDouble(connectPoint.getY());
            y2 = targetLoc.getY() + targetLoc.getHeight() * Double.parseDouble(connectPoint.getY());
            x1 = x2 = this.getSuitableCoordinate(turnPoints, symbol == -1 ? sourceLoc.getX() : sourceLoc.getX() + sourceLoc.getWidth(), isVertical, symbol);
        } else {
            x1 = sourceLoc.getX() + sourceLoc.getWidth() * Double.parseDouble(connectPoint.getX());
            x2 = targetLoc.getX() + targetLoc.getWidth() * Double.parseDouble(connectPoint.getX());
            y1 = y2 = this.getSuitableCoordinate(turnPoints, symbol == -1 ? sourceLoc.getY() : sourceLoc.getY() + sourceLoc.getHeight(), isVertical, symbol);
        }
        GraphicInfo graphic1 = new GraphicInfo();
        graphic1.setX(x1);
        graphic1.setY(y1);
        GraphicInfo graphic2 = new GraphicInfo();
        graphic2.setX(x2);
        graphic2.setY(y2);
        points.add(graphic1);
        points.add(graphic2);
        return points;
    }

    protected double getSuitableCoordinate(List<GraphicInfo> infos, double start, boolean isVertical, int symbol) {
        int i = 1;
        int step = 20 * symbol;
        if (infos.isEmpty()) {
            return start + (double)(step * 2);
        }
        boolean stop = false;
        double ret = 0.0;
        block0: while (!stop) {
            ret = start + (double)(i * step);
            for (GraphicInfo info : infos) {
                if (ret == (isVertical ? info.getX() : info.getY())) {
                    ++i;
                    stop = false;
                    continue block0;
                }
                stop = true;
            }
        }
        return ret;
    }
}

