/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.graph.codec.GraphCellCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;
import org.dom4j.Element;
import org.dom4j.Node;

public class StartEventCodec
extends GraphCellCodec {
    @Override
    protected String getType(Object element) {
        String type = this.getType();
        if (WfUtils.isNotEmpty(type)) {
            return type;
        }
        StartEvent event = (StartEvent)element;
        return SpecialPropertyUtil.getStartEventType(event);
    }

    @Override
    protected String getGroup() {
        return "BasicControl";
    }

    @Override
    protected StartEvent create() {
        return new StartEvent();
    }

    @Override
    protected Object getPropertyValue(Object obj, Property prop, boolean isGroupProp) {
        try {
            if ("signalref".equals(prop.getPropertyName())) {
                return SpecialPropertyUtil.getProperty(obj, prop.getPropertyName());
            }
            return super.getPropertyValue(obj, prop, isGroupProp);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setCellCommonAttributes(GraphCodecContext ctx, Node node, Object obj) {
        super.setCellCommonAttributes(ctx, node, obj);
        ((Element)node).addAttribute("showRecords", "false");
    }

    @Override
    protected Object initiation(Object obj, ElementType elementType, GraphCodecContext context) {
        String type;
        StartEvent event = (StartEvent)super.initiation(obj, elementType, context);
        switch (type = elementType.getId()) {
            case "StartSignalEvent": {
                this.setSignalEventDefinitions(event, elementType, context);
                break;
            }
            case "StartErrorEvent": {
                break;
            }
            case "StartTimerEvent": {
                break;
            }
            case "StartMessageEvent": {
                break;
            }
            case "StartNoneEvent": {
                break;
            }
        }
        return event;
    }

    private void setSignalEventDefinitions(StartEvent event, ElementType elementType, GraphCodecContext context) {
        try {
            Object value;
            Process process = context.getModel().getMainProcess();
            Property property = GraphCodecUtils.getPropertyByName(elementType.getProperties(), "signalref");
            Map editor = property.getEditor();
            Object defaultVal = editor.get("default");
            SignalEventDefinition eventDefinition = new SignalEventDefinition();
            if (defaultVal != null && (value = GraphCodecUtils.getParsedPropValue(defaultVal.toString(), process)) != null) {
                eventDefinition.setSignalRef(value.toString());
            }
            event.getEventDefinitions().add(eventDefinition);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected int getCommonNodeWidth() {
        return 115;
    }

    @Override
    protected int getCommonNodeHeight() {
        return 45;
    }

    @Override
    protected int getY() {
        return 100;
    }
}

