/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.graph.codec.GraphCellCodec;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.IMessageSupport;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;

public class UserTaskCodec
extends GraphCellCodec {
    @Override
    public String getType() {
        return "UserTask";
    }

    @Override
    protected String getGroup() {
        return "DisposeControl";
    }

    @Override
    protected IMessageSupport create() {
        return new UserTask();
    }

    @Override
    protected Object initProperty(Object obj, Property property, Map<String, Object> config, Process process, Map<String, Object> isvConfig) {
        String propName = property.getPropertyName();
        if ("formKey".equals(propName) || "mobilFormKey".equals(propName)) {
            return this.initFormKeyProperty((UserTask)obj, propName, config);
        }
        if ("skipCondition".equals(propName)) {
            return this.initSkipConditionProperty(obj, property, config, process, isvConfig);
        }
        return super.initProperty(obj, property, config, process, isvConfig);
    }

    private String initFormKeyProperty(UserTask userTask, String propName, Map<String, Object> config) {
        String entityId = (String)config.get("entityId");
        if (WfUtils.isEmpty(entityId)) {
            this.log.debug("NodeTemplate,There is't entityId");
            return "";
        }
        Map<String, Object> billPages = BillPagePluginUtil.getBillPagesForPC(null, entityId);
        Map<String, Object> billPagesForMob = BillPagePluginUtil.getBillPagesForMob("UserTask", null, null, entityId, (String)config.get("entityNumber"), (String)config.get("entityName"), (List)billPages.get("dataitems"));
        BillSetting billSetting = userTask.getBillSetting();
        if (billSetting == null) {
            billSetting = new BillSetting();
        }
        billSetting.setFormKey((String)billPages.get("selectedvalue"));
        billSetting.setMobilFormKey((String)billPagesForMob.get("selectedvalue"));
        userTask.setBillSetting(billSetting);
        return "formKey".equals(propName) ? billSetting.getFormKey() : billSetting.getMobilFormKey();
    }

    private ConditionalRuleEntity initSkipConditionProperty(Object obj, Property property, Map<String, Object> config, Process process, Map<String, Object> isvConfig) {
        ConditionalRuleEntityImpl condition = null;
        Object value = super.initProperty(obj, property, config, process, isvConfig);
        Map map = null;
        if (value instanceof Map && !(map = (Map)value).isEmpty()) {
            Object description;
            condition = new ConditionalRuleEntityImpl();
            condition.setElementid((String)map.get("elementid"));
            condition.setPlugin((String)map.get("plugin"));
            Object showText = map.get("showtext");
            if (showText instanceof Map) {
                condition.setShowtext((ILocaleString)LocaleString.fromMap((Map)((Map)showText)));
            }
            if ((description = map.get("description")) instanceof Map) {
                condition.setDescription((ILocaleString)LocaleString.fromMap((Map)((Map)description)));
            }
            condition.setProperty(property.getPropertyName());
            condition.setType(ConditionalRuleType.skip.toString());
            ((UserTask)obj).setSkipCondition(condition);
        }
        return condition;
    }

    @Override
    protected boolean needFindInGroup(Property prop, Object obj) {
        String propName = prop.getPropertyName();
        return !"participant".equals(propName);
    }
}

