/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.graph.codec.AuditTaskCodec;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.SimpleUserInfo;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class YunzhijiaTaskCodec
extends AuditTaskCodec {
    @Override
    public String getType() {
        return "YunzhijiaTask";
    }

    @Override
    protected String getGroup() {
        return "DisposeControl";
    }

    @Override
    protected YunzhijiaTask create() {
        return new YunzhijiaTask();
    }

    @Override
    protected int getCommonNodeWidth() {
        return 162;
    }

    @Override
    protected String getNameInFlowchart(BaseElement element, GraphCodecContext ctx) {
        if (ctx.getCurrentNodeIds().contains(element.getId()) || ctx.getPreNodeIds().contains(element.getId())) {
            return super.getNameInFlowchart(element, ctx);
        }
        if (ctx.getHangupNodeIds().contains(element.getId())) {
            if ("BizFlowModel".equalsIgnoreCase(ctx.getModelType())) {
                return String.format("%s %s", element.getName(), WFMultiLangConstants.getAbnormalErrorStateName());
            }
            return String.format("%s %s", element.getName(), WFMultiLangConstants.getAbnormalHangUpStateName());
        }
        if (ctx.getSkipNodeIds().contains(element.getId())) {
            return element.getName();
        }
        CommentEntity comment = ctx.getCommentMap().get(element.getId());
        if (comment != null && WfUtils.isEmpty(comment.getUserId())) {
            return String.format("%s %s", element.getName(), "approve".equals(comment.getDecisionType()) ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"YunzhijiaTaskCodec_1", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u901a\u8fc7", (String)"YunzhijiaTaskCodec_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return super.getNameInFlowchart(element, ctx);
    }

    @Override
    protected String rebuildNodeTitle(BaseElement element, GraphCodecContext ctx) {
        String currentNodeId = element.getId();
        List<SimpleUserInfo> users = ctx.getCurrentNodeUsersMap().get(currentNodeId);
        if (users == null) {
            users = new ArrayList<SimpleUserInfo>();
        }
        Long groupId = ctx.getCurrentNodeTaskMap().get(currentNodeId);
        ILocaleString assignee = null;
        ArrayList<String> handingUserNames = new ArrayList<String>();
        ArrayList<String> handedUserNames = new ArrayList<String>();
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List<CommentEntity> comments = ctx.getCommentList();
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (CommentEntity comment : comments) {
            DynamicObject dynamicObject;
            String type;
            if (currentNodeId == null || !currentNodeId.equals(comment.getActivityId()) || !String.valueOf(groupId).equalsIgnoreCase(comment.getGroupId()) || !"comment".equals(type = (dynamicObject = comment.getDynamicObject()).getString("type"))) continue;
            assignee = comment.getUserNameFormatter();
            String diplayInfo = null;
            if (WfUtils.isAuditTypeNode(element.getType())) {
                UserTask userTask = (UserTask)element;
                ParticipatantModel participantModel = userTask.getParticipant();
                String string = diplayInfo = participantModel != null ? participantModel.getDisplayInfo() : null;
            }
            if (!isDisplaySetting && WfUtils.isEmpty(diplayInfo)) {
                assignee = comment.getTaskAssignee();
            }
            Long ownerId = comment.getOwnerId();
            ILocaleString assignorName = comment.getAssignorName();
            if (null == assignee) continue;
            if (!WfUtils.isEmpty(ownerId) && WfUtils.isNotEmpty(assignorName)) {
                handedUserNames.add(TaskDelegateUtil.getDelegateAssigneeName(assignorName.toString(), assignee.toString(), "replace"));
                continue;
            }
            handedUserNames.add(assignee.toString());
        }
        for (SimpleUserInfo userInfo : users) {
            if (handedUserNames.contains(userInfo.getName())) continue;
            handingUserNames.add(userInfo.getName());
        }
        StringBuilder result = new StringBuilder();
        result.append(element.getName()).append(' ');
        String userNameForFinal = null;
        if (!handedUserNames.isEmpty()) {
            userNameForFinal = GraphCodecUtils.getUserNames(handedUserNames);
            result.append(userNameForFinal);
            result.append(ResManager.loadKDString((String)" \u5df2\u7ecf\u5ba1\u6279", (String)"GraphCellCodec_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (!handingUserNames.isEmpty()) {
            String userNames = null;
            if (!handedUserNames.isEmpty()) {
                result.append('\uff0c');
            } else {
                userNames = ViewFlowchartUtil.getYzjTeamMemberNamesFromVariable(ctx.getCurrentNodeTaskMap().get(currentNodeId), service.getRuntimeService(), element);
            }
            if (ctx.getManualHangUpNodeIds().get(currentNodeId) != null) {
                result.append(WFMultiLangConstants.getManualHangUpStateName());
            } else {
                result.append(ResManager.loadKDString((String)"\u7b49\u5f85\u5ba1\u6279\uff1a", (String)"GraphCellCodec_4", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            userNameForFinal = userNames != null ? userNames : GraphCodecUtils.getUserNames(handingUserNames);
            result.append(userNameForFinal);
        }
        return result.toString();
    }
}

