/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.model;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.graph.model.IValueContext;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractValueContext<T>
implements IValueContext {
    protected Log log = LogFactory.getLog(this.getClass());
    private String EXPRESSION_REGEX_NODE = "^\\$\\{node\\.(\\w+(\\.\\w+)*)\\}$";
    private String EXPRESSION_NODEID = "${nodeId}";
    private String EXPRESSION_NODEID_STANDARD = "${node.itemId}";
    private String EXPRESSION_REGEX_PROCESS = "^\\$\\{process\\.(\\w+(\\.\\w+)*)\\}$";
    protected T processProperties;
    protected T cellProperties;

    public AbstractValueContext(T processProperties, T cellProperties) {
        this.processProperties = processProperties;
        this.cellProperties = cellProperties;
    }

    @Override
    public Object getExpressionValue(String value) {
        if (value == null) {
            return value;
        }
        if (this.EXPRESSION_NODEID.equals(value)) {
            value = this.EXPRESSION_NODEID_STANDARD;
        }
        String propertyKey = null;
        try {
            if (value.matches(this.EXPRESSION_REGEX_NODE)) {
                propertyKey = value.replaceFirst(this.EXPRESSION_REGEX_NODE, "$1");
                return this.getCellProperty(propertyKey);
            }
            if (value.matches(this.EXPRESSION_REGEX_PROCESS)) {
                propertyKey = value.replaceFirst(this.EXPRESSION_REGEX_PROCESS, "$1");
                return this.getProcessProperty(propertyKey);
            }
            return value;
        }
        catch (Exception e) {
            this.log.warn(String.format("%s parsing failed! %s", value, WfUtils.getExceptionStacktrace(e)));
            return value;
        }
    }

    protected abstract Object getProcessProperty(String var1);

    protected abstract Object getCellProperty(String var1);
}

