/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.model.GraphBound;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.bpmn.graph.model.GraphPoint;
import kd.bos.workflow.bpmn.graph.model.GraphStencil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class GraphCell
implements Serializable {
    private static final long serialVersionUID = 7572869624018002592L;
    private String resourceId;
    private GraphStencil stencil;
    private String style;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<GraphCell> childShapes = new ArrayList<GraphCell>();
    private List<GraphItem> outgoing = new ArrayList<GraphItem>();
    private GraphItem target;
    private GraphBound bounds;
    private List<GraphPoint> dockers = new ArrayList<GraphPoint>();
    private String originId;
    private String originPageId;

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public List<GraphCell> getChildShapes() {
        return this.childShapes;
    }

    public void setChildShapes(List<GraphCell> childShapes) {
        this.childShapes = childShapes;
    }

    public GraphStencil getStencil() {
        return this.stencil;
    }

    public void setStencil(GraphStencil stencil) {
        this.stencil = stencil;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<GraphItem> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(List<GraphItem> outgoing) {
        this.outgoing = outgoing;
    }

    public GraphItem getTarget() {
        return this.target;
    }

    public void setTarget(GraphItem target) {
        this.target = target;
    }

    public GraphBound getBounds() {
        return this.bounds;
    }

    public void setBounds(GraphBound bounds) {
        this.bounds = bounds;
    }

    public List<GraphPoint> getDockers() {
        return this.dockers;
    }

    public void setDockers(List<GraphPoint> dockers) {
        this.dockers = dockers;
    }

    @JSONField(serialize=false)
    public boolean isEdge() {
        return "SequenceFlow".equals(this.getStencil().getId());
    }

    public void updateGeometry(GraphCell graphCell) {
        if (this.isEdge()) {
            this.setDockers(graphCell.getDockers());
            this.setBounds(graphCell.getBounds());
        } else {
            this.setBounds(graphCell.getBounds());
        }
        this.setStyle(graphCell.getStyle());
    }

    @JSONField(serialize=false)
    public String getOriginId() {
        return this.originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    @JSONField(serialize=false)
    public String getOriginPageId() {
        return this.originPageId;
    }

    public void setOriginPageId(String originPageId) {
        this.originPageId = originPageId;
    }

    @JSONField(serialize=false)
    public String getNumber() {
        return (String)BpmnModelUtil.getProperty(this.getProperties(), "number");
    }

    @JSONField(serialize=false)
    public String getName() {
        return (String)BpmnModelUtil.getProperty(this.getProperties(), "name");
    }

    @JSONField(serialize=false)
    public String getFullName() {
        String name = this.getName();
        if (WfUtils.isNotEmpty(name)) {
            return String.format("%s(%s)", name, this.getNumber());
        }
        return this.getNumber();
    }

    public int hashCode() {
        return this.resourceId.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof GraphCell) {
            return this.resourceId.equals(((GraphCell)other).getResourceId());
        }
        return false;
    }

    public String toString() {
        return this.getResourceId();
    }

    public Map<String, Object> getCopiedProperties(GraphCell newCell) {
        String props = JSON.toJSONString(this.getProperties());
        JSONObject copiedProperties = JSON.parseObject((String)props.replaceAll(String.format("\\b%s\\b", this.getResourceId()), newCell.getResourceId()));
        Map<String, Object> newProperties = newCell.getProperties();
        if (!newProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : newProperties.entrySet()) {
                copiedProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return BpmnDiffUtil.regenerateListPropertyId(copiedProperties);
    }
}

