/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.DataAssociation;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.IOSpecification;
import kd.bos.workflow.bpmn.model.MapExceptionEntry;
import kd.bos.workflow.bpmn.model.MultiInstanceLoopCharacteristics;

public abstract class Activity
extends FlowNode {
    private static final long serialVersionUID = 962064635764066763L;
    protected boolean forCompensation;
    protected MultiInstanceLoopCharacteristics loopCharacteristics;
    protected IOSpecification ioSpecification;
    private List<DataAssociation> dataInputAssociations = new ArrayList<DataAssociation>();
    private List<DataAssociation> dataOutputAssociations = new ArrayList<DataAssociation>();
    private List<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
    protected String failedJobRetryTimeCycleValue;
    private List<MapExceptionEntry> mapExceptions = new ArrayList<MapExceptionEntry>();

    public String getFailedJobRetryTimeCycleValue() {
        return this.failedJobRetryTimeCycleValue;
    }

    public void setFailedJobRetryTimeCycleValue(String failedJobRetryTimeCycleValue) {
        this.failedJobRetryTimeCycleValue = failedJobRetryTimeCycleValue;
    }

    public boolean isForCompensation() {
        return this.forCompensation;
    }

    public void setForCompensation(boolean forCompensation) {
        this.forCompensation = forCompensation;
    }

    public List<BoundaryEvent> getBoundaryEvents() {
        return this.boundaryEvents;
    }

    public void setBoundaryEvents(List<BoundaryEvent> boundaryEvents) {
        this.boundaryEvents = boundaryEvents;
    }

    public MultiInstanceLoopCharacteristics getLoopCharacteristics() {
        return this.loopCharacteristics;
    }

    public void setLoopCharacteristics(MultiInstanceLoopCharacteristics loopCharacteristics) {
        this.loopCharacteristics = loopCharacteristics;
    }

    public boolean hasMultiInstanceLoopCharacteristics() {
        return this.getLoopCharacteristics() != null;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    public List<DataAssociation> getDataInputAssociations() {
        return this.dataInputAssociations;
    }

    public void setDataInputAssociations(List<DataAssociation> dataInputAssociations) {
        this.dataInputAssociations = dataInputAssociations;
    }

    public List<DataAssociation> getDataOutputAssociations() {
        return this.dataOutputAssociations;
    }

    public void setDataOutputAssociations(List<DataAssociation> dataOutputAssociations) {
        this.dataOutputAssociations = dataOutputAssociations;
    }

    public List<MapExceptionEntry> getMapExceptions() {
        return this.mapExceptions;
    }

    public void setMapExceptions(List<MapExceptionEntry> mapExceptions) {
        this.mapExceptions = mapExceptions;
    }

    public void setValues(Activity otherActivity) {
        super.setValues(otherActivity);
        this.setFailedJobRetryTimeCycleValue(otherActivity.getFailedJobRetryTimeCycleValue());
        this.setDefaultFlow(otherActivity.getDefaultFlow());
        this.setForCompensation(otherActivity.isForCompensation());
        this.setMapExceptions(otherActivity.getMapExceptions());
        if (otherActivity.getLoopCharacteristics() != null) {
            this.setLoopCharacteristics(otherActivity.getLoopCharacteristics().clone());
        }
        if (otherActivity.getIoSpecification() != null) {
            this.setIoSpecification(otherActivity.getIoSpecification().clone());
        }
        this.dataInputAssociations = new ArrayList<DataAssociation>();
        if (otherActivity.getDataInputAssociations() != null && !otherActivity.getDataInputAssociations().isEmpty()) {
            for (DataAssociation association : otherActivity.getDataInputAssociations()) {
                this.dataInputAssociations.add(association.clone());
            }
        }
        this.dataOutputAssociations = new ArrayList<DataAssociation>();
        if (otherActivity.getDataOutputAssociations() != null && !otherActivity.getDataOutputAssociations().isEmpty()) {
            for (DataAssociation association : otherActivity.getDataOutputAssociations()) {
                this.dataOutputAssociations.add(association.clone());
            }
        }
        this.boundaryEvents = new ArrayList<BoundaryEvent>();
        if (otherActivity.getBoundaryEvents() != null && !otherActivity.getBoundaryEvents().isEmpty()) {
            for (BoundaryEvent event : otherActivity.getBoundaryEvents()) {
                this.boundaryEvents.add(event.clone());
            }
        }
    }
}

