/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.AutoService;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.InParameter;
import kd.bos.workflow.bpmn.model.Parameter;

public class AutoMicroServiceTask
extends FlowNode {
    private String entityId;
    private String entityName;
    private String entityNumber;
    private String fetchType;
    private AutoService autoService;
    private List<InParameter> inParams = new ArrayList<InParameter>();
    private List<Parameter> outParams = new ArrayList<Parameter>();

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public List<InParameter> getInParams() {
        return this.inParams;
    }

    public void setInParams(List<InParameter> inParams) {
        this.inParams = inParams;
    }

    public List<Parameter> getOutParams() {
        return this.outParams;
    }

    public void setOutParams(List<Parameter> outParams) {
        this.outParams = outParams;
    }

    public String getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(String fetchType) {
        this.fetchType = fetchType;
    }

    public AutoService getAutoService() {
        return this.autoService;
    }

    public void setAutoService(AutoService autoService) {
        this.autoService = autoService;
    }

    @Override
    public AutoMicroServiceTask clone() {
        AutoMicroServiceTask clone = new AutoMicroServiceTask();
        clone.setValues(this);
        return clone;
    }

    public void setValues(AutoMicroServiceTask other) {
        List<Parameter> outParameters;
        List<InParameter> inParameters;
        super.setValues(other);
        this.setEntityId(other.getEntityId());
        this.setEntityName(other.getEntityName());
        this.setEntityNumber(other.getEntityNumber());
        this.setFetchType(other.getFetchType());
        if (other.getAutoService() != null) {
            this.setAutoService(other.getAutoService().clone());
        }
        if ((inParameters = other.getInParams()) != null && !inParameters.isEmpty()) {
            ArrayList<InParameter> params = new ArrayList<InParameter>(inParameters.size());
            for (InParameter inParam : inParameters) {
                params.add(inParam.clone());
            }
            this.setInParams(params);
        }
        if ((outParameters = other.getOutParams()) != null && !outParameters.isEmpty()) {
            ArrayList<Parameter> params = new ArrayList<Parameter>(outParameters.size());
            for (Parameter outParam : outParameters) {
                params.add(outParam.clone());
            }
            this.setOutParams(params);
        }
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        this.copyInParams(model);
        return super.copy(model);
    }

    private void copyInParams(DuplicateModel model) {
        List<InParameter> inParameters = this.getInParams();
        if (inParameters == null || inParameters.isEmpty()) {
            return;
        }
        for (InParameter inParam : inParameters) {
            inParam.copy(model);
        }
    }
}

