/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.bpmn.converter.field.TransIgnore;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.ExtendAttributeGroup;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.ExtensionAttributesImpl;
import kd.bos.workflow.bpmn.model.ExtensionElement;
import kd.bos.workflow.bpmn.model.HasExtensionAttributes;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import org.apache.commons.lang.StringUtils;

public abstract class BaseElement
implements WorkflowElement,
HasExtensionAttributes {
    protected static Log log = LogFactory.getLog(BaseElement.class);
    protected String id;
    protected String number;
    protected int xmlRowNumber;
    protected int xmlColumnNumber;
    protected ExtensionAttributesImpl extensionAttributesImpl = new ExtensionAttributesImpl();

    public ExtensionAttributesImpl getExtensionAttributesImpl() {
        return this.extensionAttributesImpl;
    }

    public void setExtensionAttributesImpl(ExtensionAttributesImpl extensionAttributesImpl) {
        this.extensionAttributesImpl = extensionAttributesImpl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @TransIgnore
    public int getXmlRowNumber() {
        return this.xmlRowNumber;
    }

    public void setXmlRowNumber(int xmlRowNumber) {
        this.xmlRowNumber = xmlRowNumber;
    }

    @TransIgnore
    public int getXmlColumnNumber() {
        return this.xmlColumnNumber;
    }

    public void setXmlColumnNumber(int xmlColumnNumber) {
        this.xmlColumnNumber = xmlColumnNumber;
    }

    public Map<String, List<ExtensionElement>> getExtensionElements() {
        return this.extensionAttributesImpl.getExtensionElements();
    }

    public void addExtensionElement(ExtensionElement extensionElement) {
        if (extensionElement != null && StringUtils.isNotEmpty((String)extensionElement.getName())) {
            ArrayList elementList = null;
            if (!this.getExtensionElements().containsKey(extensionElement.getName())) {
                elementList = new ArrayList();
                this.getExtensionElements().put(extensionElement.getName(), elementList);
            }
            this.getExtensionElements().get(extensionElement.getName()).add(extensionElement);
        }
    }

    public void setExtensionElements(Map<String, List<ExtensionElement>> extensionElements) {
        this.extensionAttributesImpl.setExtensionElements(extensionElements);
    }

    @Override
    public Map<String, List<ExtensionAttribute>> getAttributes() {
        return this.extensionAttributesImpl.getAttributes();
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        List<ExtensionAttribute> attributes = this.getAttributes().get(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (ExtensionAttribute attribute : attributes) {
                if ((namespace != null || attribute.getNamespace() != null) && (namespace == null || !namespace.equals(attribute.getNamespace()))) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(null, name);
    }

    public void removeAttribute(String name) {
        this.getAttributes().remove(name);
    }

    public void removeAttribute(String ... name) {
        if (name != null && name.length > 0) {
            for (String n : name) {
                this.getAttributes().remove(n);
            }
        }
    }

    @Override
    public void addAttribute(ExtensionAttribute attribute) {
        if (attribute != null && StringUtils.isNotEmpty((String)attribute.getName())) {
            ArrayList attributeList = null;
            if (!this.extensionAttributesImpl.getAttributes().containsKey(attribute.getName())) {
                attributeList = new ArrayList();
                this.extensionAttributesImpl.getAttributes().put(attribute.getName(), attributeList);
            }
            this.extensionAttributesImpl.getAttributes().get(attribute.getName()).add(attribute);
        }
    }

    public void addAttribute(String name, String value) {
        ExtensionAttribute attr = new ExtensionAttribute();
        attr.setName(name);
        attr.setValue(value);
        this.addAttribute(attr);
    }

    @Override
    public void setAttributes(Map<String, List<ExtensionAttribute>> attributes) {
        this.extensionAttributesImpl.setAttributes(attributes);
    }

    public void setValues(BaseElement otherElement) {
        this.setId(otherElement.getId());
        this.setNumber(otherElement.getNumber());
        if (otherElement.getExtensionElements() != null && !otherElement.getExtensionElements().isEmpty()) {
            LinkedHashMap<String, List<ExtensionElement>> extensionElements = new LinkedHashMap<String, List<ExtensionElement>>(otherElement.getExtensionElements().size());
            for (String key : otherElement.getExtensionElements().keySet()) {
                List<ExtensionElement> otherElementList = otherElement.getExtensionElements().get(key);
                if (otherElementList == null || otherElementList.isEmpty()) continue;
                ArrayList<ExtensionElement> elementList = new ArrayList<ExtensionElement>(otherElementList.size());
                for (ExtensionElement extensionElement : otherElementList) {
                    elementList.add(extensionElement.clone());
                }
                extensionElements.put(key, elementList);
            }
            this.extensionAttributesImpl.setExtensionElements(extensionElements);
        }
        LinkedHashMap<String, List<ExtensionAttribute>> attributes = new LinkedHashMap<String, List<ExtensionAttribute>>();
        if (otherElement.getAttributes() != null && !otherElement.getAttributes().isEmpty()) {
            for (String key : otherElement.getAttributes().keySet()) {
                List<ExtensionAttribute> otherAttributeList = otherElement.getAttributes().get(key);
                if (otherAttributeList == null || otherAttributeList.isEmpty()) continue;
                ArrayList<ExtensionAttribute> attributeList = new ArrayList<ExtensionAttribute>(otherAttributeList.size());
                for (ExtensionAttribute extensionAttribute : otherAttributeList) {
                    attributeList.add(extensionAttribute.clone());
                }
                attributes.put(key, attributeList);
            }
        }
        this.extensionAttributesImpl.setAttributes(attributes);
    }

    public abstract BaseElement clone();

    public Object getPropertyValue(String propertyName) {
        Object value = null;
        try {
            value = SpecialPropertyUtil.getProperty(this, propertyName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public Object getCustomPropValue(String propertyName) {
        String value = null;
        Object propValue = this.getPropertyValue("customParams");
        if (propValue != null) {
            List customParams = (List)propValue;
            for (CustomParam customParam : customParams) {
                if (!propertyName.equalsIgnoreCase(customParam.getNumber())) continue;
                value = customParam.getValue();
                break;
            }
        }
        return value;
    }

    public Object getExtPropValue(String propertyName) {
        Map<String, Object> value = null;
        Object propValue = this.getPropertyValue("extAttrGroup");
        if (propValue instanceof HashMap) {
            Map extAttrGroupMap = (Map)propValue;
            for (Map.Entry extAttrGroup : extAttrGroupMap.entrySet()) {
                ExtendAttributeGroup extendAttributeGroup = (ExtendAttributeGroup)extAttrGroup.getValue();
                if (!propertyName.equals(extAttrGroup.getKey())) continue;
                value = extendAttributeGroup.getExtAttrValue();
                break;
            }
        }
        return value;
    }

    public BaseElement copy(DuplicateModel model) {
        this.copyForItemId(model.getModelKeyOld(), model.getModelKey());
        this.copyForExtensionAttributes(model);
        return this;
    }

    private void copyForItemId(String oldValue, String newValue) {
        String itemIdNew = this.getCopyValueForReplace(this.getId(), oldValue, newValue);
        if (WfUtils.isNotEmpty(itemIdNew)) {
            this.setId(itemIdNew);
        }
    }

    private void copyForExtensionAttributes(DuplicateModel model) {
        Map<String, List<ExtensionAttribute>> attributes;
        ExtensionAttributesImpl extensionAttrImpl = this.getExtensionAttributesImpl();
        if (null != extensionAttrImpl && null != (attributes = extensionAttrImpl.getAttributes()) && 0 != attributes.size()) {
            Set<Map.Entry<String, List<ExtensionAttribute>>> entrySet = attributes.entrySet();
            Iterator<Map.Entry<String, List<ExtensionAttribute>>> ite = entrySet.iterator();
            Map.Entry<String, List<ExtensionAttribute>> entry = null;
            List<ExtensionAttribute> value = null;
            String oldValue = model.getModelKeyOld();
            String newValue = model.getModelKey();
            String attributeValueNew = null;
            while (ite.hasNext()) {
                entry = ite.next();
                value = entry.getValue();
                if (null == value || 0 == value.size()) continue;
                for (ExtensionAttribute attribute : value) {
                    attributeValueNew = this.getCopyValueForReplace(attribute.getValue(), oldValue, newValue);
                    if (!WfUtils.isNotEmpty(attributeValueNew)) continue;
                    attribute.setValue(attributeValueNew);
                }
            }
        }
    }

    protected String getCopyValueForReplace(String originalValue, String oldValue, String newValue) {
        return BpmnModelUtil.getCopyValueForReplace(originalValue, oldValue, newValue);
    }

    protected void copyForConditionalRuleEntity(ConditionalRuleEntity entity, String oldValue, String newValue) {
        if (null != entity) {
            DynamicObjectCollection entities;
            String expression;
            String itemId = this.getCopyValueForReplace(entity.getElementid(), oldValue, newValue);
            if (WfUtils.isNotEmpty(itemId)) {
                entity.setElementid(itemId);
            }
            if (WfUtils.isNotEmpty(expression = this.getCopyValueForReplace(entity.getExpression(), oldValue, newValue))) {
                entity.setExpression(expression);
            }
            if (WfUtils.isNotEmptyForCollection((Collection)(entities = entity.getDynamicObject().getDynamicObjectCollection("entryentity")))) {
                String paramnumber = null;
                String value = null;
                for (DynamicObject conditionalEntity : entities) {
                    paramnumber = this.getCopyValueForReplace(conditionalEntity.getString("paramnumber"), oldValue, newValue);
                    if (WfUtils.isNotEmpty(paramnumber)) {
                        conditionalEntity.set("paramnumber", (Object)paramnumber);
                    }
                    if (!WfUtils.isNotEmpty(value = this.getCopyValueForReplace(conditionalEntity.getString("value"), oldValue, newValue))) continue;
                    conditionalEntity.set("value", (Object)value);
                }
            }
        }
    }
}

