/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModel;
import kd.bos.workflow.bpmn.model.PageParameter;
import kd.bos.workflow.bpmn.model.dynamicpartial.IDynamicPartial;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillSetting
extends BaseElement
implements IDynamicPartial {
    private static final long serialVersionUID = 1L;
    private List<BillPageAttributeConfigEntity> pageAttrConfig;
    private List<BillPageAttributeConfigEntity> mobilePageAttrConfig;
    private boolean fieldModified;
    private String operationWhenSave;
    private String operationWhenSubmit;
    private String operationWhenReject;
    private String formKey;
    private String mobilFormKey;
    protected List<PageParameter> pageParameter;
    private boolean dataSignedVerify;
    private boolean dataSignedAdd;
    private BillPageAttributeConfigModel pageAttrConfigModel;
    private BillPageAttributeConfigModel mobilePageAttrConfigModel;

    @Override
    public String getPartialType() {
        return "billSetting";
    }

    @Override
    public BillSetting clone() {
        BillSetting clone = new BillSetting();
        clone.setFieldModified(this.isFieldModified());
        clone.setOperationWhenSave(this.getOperationWhenSave());
        clone.setPageAttrConfig(this.getPageAttrConfig());
        clone.setMobilePageAttrConfig(this.getMobilePageAttrConfig());
        clone.setFormKey(this.getFormKey());
        clone.setMobilFormKey(this.getMobilFormKey());
        clone.setOperationWhenSubmit(this.getOperationWhenSubmit());
        clone.setOperationWhenReject(this.getOperationWhenReject());
        clone.setDataSignedVerify(this.isDataSignedVerify());
        clone.setDataSignedAdd(this.isDataSignedAdd());
        ArrayList<PageParameter> pageParametersClone = null;
        List<PageParameter> pageParameters = this.getPageParameter();
        if (WfUtils.isEmptyForCollection(pageParameters)) {
            pageParametersClone = new ArrayList<PageParameter>(1);
        } else {
            pageParametersClone = new ArrayList(pageParameters.size());
            for (PageParameter pageParameter : pageParameters) {
                if (null == pageParameter) continue;
                pageParametersClone.add((PageParameter)pageParameter.clone());
            }
        }
        clone.setPageParameter(pageParametersClone);
        if (null != this.getPageAttrConfigModel()) {
            clone.setPageAttrConfigModel(this.getPageAttrConfigModel().clone());
        }
        if (null != this.getMobilePageAttrConfigModel()) {
            clone.setMobilePageAttrConfigModel(this.getMobilePageAttrConfigModel().clone());
        }
        return clone;
    }

    public List<BillPageAttributeConfigEntity> getPageAttrConfig() {
        return this.pageAttrConfig;
    }

    public void setPageAttrConfig(List<BillPageAttributeConfigEntity> pageAttrConfig) {
        this.pageAttrConfig = pageAttrConfig;
    }

    public List<BillPageAttributeConfigEntity> getMobilePageAttrConfig() {
        return this.mobilePageAttrConfig;
    }

    public void setMobilePageAttrConfig(List<BillPageAttributeConfigEntity> mobilePageAttrConfig) {
        this.mobilePageAttrConfig = mobilePageAttrConfig;
    }

    public String getOperationWhenSave() {
        return this.operationWhenSave;
    }

    public boolean isFieldModified() {
        return this.fieldModified;
    }

    public void setFieldModified(boolean fieldModified) {
        this.fieldModified = fieldModified;
    }

    public void setOperationWhenSave(String operationWhenSave) {
        this.operationWhenSave = operationWhenSave;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getMobilFormKey() {
        return this.mobilFormKey;
    }

    public void setMobilFormKey(String mobilFormKey) {
        this.mobilFormKey = mobilFormKey;
    }

    public void setOperationWhenSubmit(String operationWhenSubmit) {
        this.operationWhenSubmit = operationWhenSubmit;
    }

    public String getOperationWhenSubmit() {
        return WfUtils.isEmpty(this.operationWhenSubmit) ? "" : this.filterOperation(this.operationWhenSubmit);
    }

    public String getOperationWhenReject() {
        return WfUtils.isEmpty(this.operationWhenReject) ? "" : this.filterOperation(this.operationWhenReject);
    }

    public void setOperationWhenReject(String operationWhenReject) {
        this.operationWhenReject = operationWhenReject;
    }

    private String filterOperation(String operationStr) {
        if (WfUtils.isEmpty(operationStr) || !operationStr.startsWith("{")) {
            return operationStr;
        }
        try {
            JSONObject dataJson = JSONObject.parseObject((String)operationStr);
            String pulginType = dataJson.getString("type");
            if (!"script".equals(pulginType)) {
                return operationStr;
            }
            String valueStr = dataJson.getString("value");
            if (null == valueStr || !valueStr.startsWith("{")) {
                return operationStr;
            }
            JSONObject valueObject = dataJson.getJSONObject("value");
            valueObject.remove((Object)"scriptSource");
            return dataJson.toJSONString();
        }
        catch (Exception e) {
            return operationStr;
        }
    }

    public List<PageParameter> getPageParameter() {
        return this.pageParameter;
    }

    public void setPageParameter(List<PageParameter> pageParameter) {
        this.pageParameter = pageParameter;
    }

    public boolean isDataSignedVerify() {
        return this.dataSignedVerify;
    }

    public void setDataSignedVerify(boolean dataSignedVerify) {
        this.dataSignedVerify = dataSignedVerify;
    }

    public boolean isDataSignedAdd() {
        return this.dataSignedAdd;
    }

    public void setDataSignedAdd(boolean dataSignedAdd) {
        this.dataSignedAdd = dataSignedAdd;
    }

    public BillPageAttributeConfigModel getPageAttrConfigModel() {
        return this.pageAttrConfigModel;
    }

    public void setPageAttrConfigModel(BillPageAttributeConfigModel pageAttrConfigModel) {
        this.pageAttrConfigModel = pageAttrConfigModel;
    }

    public BillPageAttributeConfigModel getMobilePageAttrConfigModel() {
        return this.mobilePageAttrConfigModel;
    }

    public void setMobilePageAttrConfigModel(BillPageAttributeConfigModel mobilePageAttrConfigModel) {
        this.mobilePageAttrConfigModel = mobilePageAttrConfigModel;
    }
}

