/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillTaskCallActivity;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.EventParam;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitCloseEvent;
import kd.bos.workflow.engine.event.util.WaitEventUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class BillTask
extends UserTask {
    protected BillTaskCallActivity billTaskCallActivity;
    private static final long serialVersionUID = 1L;
    private String sourceBill;
    private String sourceEntityNumber;
    private BillCloseConfig billCloseConfig;

    public String getSourceBill() {
        return this.sourceBill;
    }

    public void setSourceBill(String sourceBill) {
        this.sourceBill = sourceBill;
    }

    public String getSourceEntityNumber() {
        return this.sourceEntityNumber;
    }

    public void setSourceEntityNumber(String sourceEntityNumber) {
        this.sourceEntityNumber = sourceEntityNumber;
    }

    public BillCloseConfig getBillCloseConfig() {
        return this.billCloseConfig;
    }

    public void setBillCloseConfig(BillCloseConfig billCloseConfig) {
        this.billCloseConfig = billCloseConfig;
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        this.copyBillCloseConfig(model);
        return super.copy(model);
    }

    private void copyBillCloseConfig(DuplicateModel model) {
        WaitCloseEvent closeEvent;
        if (this.billCloseConfig != null && this.billCloseConfig.getWaitActions() != null && this.billCloseConfig.getWaitActions().getCloseEvent() != null && (closeEvent = this.billCloseConfig.getWaitActions().getCloseEvent()).getCondition() != null) {
            super.copyForConditionalRuleEntity(closeEvent.getCondition(), model.getModelKeyOld(), model.getModelKey());
        }
    }

    @Override
    public BillTask clone() {
        BillTask clone = new BillTask();
        clone.setValues(this);
        return clone;
    }

    public void setValues(BillTask otherElement) {
        super.setValues(otherElement);
        if (otherElement.getBillTaskCallActivity() != null) {
            this.setBillTaskCallActivity(otherElement.getBillTaskCallActivity().clone());
        }
        this.setSourceBill(otherElement.getSourceBill());
        this.setSourceEntityNumber(otherElement.getSourceEntityNumber());
        if (otherElement.getBillCloseConfig() != null) {
            this.setBillCloseConfig(otherElement.getBillCloseConfig().clone());
        }
    }

    public BillTaskCallActivity getBillTaskCallActivity() {
        return this.billTaskCallActivity;
    }

    public void setBillTaskCallActivity(BillTaskCallActivity billTaskCallActivity) {
        this.billTaskCallActivity = billTaskCallActivity;
    }

    private void initCallActivity() {
        this.billTaskCallActivity.setEntityId(this.getEntityId());
        this.billTaskCallActivity.setEntityName(this.getEntityName());
        this.billTaskCallActivity.setEntityNumber(this.getEntityNumber());
        this.billTaskCallActivity.setInMsg(this.getInMsg());
        this.billTaskCallActivity.setOutMsg(this.getOutMsg());
        this.billTaskCallActivity.setBillTaskId(this.getId());
    }

    public CallActivity getCallActivity() {
        BillTaskCallActivity callActivity = null;
        if (this.billTaskCallActivity != null && this.billTaskCallActivity.isEnableCallActivity()) {
            this.initCallActivity();
            callActivity = this.billTaskCallActivity;
        }
        return callActivity;
    }

    public ObjectNode getEventParamsJson(ExecutionEntity execution) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        if (this.billCloseConfig == null || this.billCloseConfig.getWaitActions() == null || this.billCloseConfig.getWaitActions().getCloseEvent() == null) {
            return node;
        }
        List<EventParam> eventParams = this.billCloseConfig.getWaitActions().getCloseEvent().getParams();
        return WaitEventUtil.getEventParamsJson(execution, eventParams);
    }
}

