/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.EventDefinition;

public class BoundaryEvent
extends Event {
    @JsonIgnore
    protected Activity attachedToRef;
    protected String attachedToRefId;
    protected boolean cancelActivity = true;
    protected boolean compensateSavePoint = false;

    public Activity getAttachedToRef() {
        return this.attachedToRef;
    }

    public void setAttachedToRef(Activity attachedToRef) {
        this.attachedToRef = attachedToRef;
    }

    public String getAttachedToRefId() {
        return this.attachedToRefId;
    }

    public void setAttachedToRefId(String attachedToRefId) {
        this.attachedToRefId = attachedToRefId;
    }

    public boolean isCancelActivity() {
        return this.cancelActivity;
    }

    public void setCancelActivity(boolean cancelActivity) {
        this.cancelActivity = cancelActivity;
    }

    public boolean isCompensateSavePoint() {
        return this.compensateSavePoint;
    }

    public void setCompensateSavePoint(boolean compensateSavePoint) {
        this.compensateSavePoint = compensateSavePoint;
    }

    @Override
    public BoundaryEvent clone() {
        BoundaryEvent clone = new BoundaryEvent();
        clone.setValues(this);
        return clone;
    }

    public void setValues(BoundaryEvent otherEvent) {
        super.setValues(otherEvent);
        this.setAttachedToRefId(otherEvent.getAttachedToRefId());
        this.setAttachedToRef(otherEvent.getAttachedToRef());
        this.setCancelActivity(otherEvent.isCancelActivity());
        this.setCompensateSavePoint(otherEvent.isCompensateSavePoint());
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        BoundaryEvent event = (BoundaryEvent)super.copy(model);
        String attachedToRefId = this.getCopyValueForReplace(event.getAttachedToRefId(), model.getModelKeyOld(), model.getModelKey());
        event.setAttachedToRefId(attachedToRefId);
        if (event.getEventDefinitions() != null && !event.getEventDefinitions().isEmpty()) {
            for (EventDefinition eventDef : event.getEventDefinitions()) {
                eventDef.copy(model);
            }
        }
        return event;
    }
}

