/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.workflow.bpmn.model.Artifact;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.ItemDefinition;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.Message;
import kd.bos.workflow.bpmn.model.MessageFlow;
import kd.bos.workflow.bpmn.model.OrderedNodesInfo;
import kd.bos.workflow.bpmn.model.Pool;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Resource;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import org.apache.commons.lang.StringUtils;

public class BpmnModel {
    protected Map<String, List<ExtensionAttribute>> definitionsAttributes = new LinkedHashMap<String, List<ExtensionAttribute>>(16);
    protected List<Process> processes = new ArrayList<Process>(16);
    protected Map<String, GraphicInfo> locationMap = new LinkedHashMap<String, GraphicInfo>(16);
    protected Map<String, GraphicInfo> labelLocationMap = new LinkedHashMap<String, GraphicInfo>(16);
    protected GraphicInfo location;
    protected Map<String, List<GraphicInfo>> flowLocationMap = new LinkedHashMap<String, List<GraphicInfo>>(16);
    protected List<Signal> signals = new ArrayList<Signal>(16);
    protected Map<String, MessageFlow> messageFlowMap = new LinkedHashMap<String, MessageFlow>(16);
    protected Map<String, Message> messageMap = new LinkedHashMap<String, Message>(16);
    protected Map<String, String> errorMap = new LinkedHashMap<String, String>(16);
    protected Map<String, ItemDefinition> itemDefinitionMap = new LinkedHashMap<String, ItemDefinition>(16);
    protected List<Pool> pools = new ArrayList<Pool>(16);
    protected List<Artifact> globalArtifacts = new ArrayList<Artifact>(16);
    protected List<Resource> resources = new ArrayList<Resource>(16);
    protected Map<String, String> namespaceMap = new LinkedHashMap<String, String>(16);
    protected String targetNamespace;
    protected String sourceSystemId;
    protected List<String> userTaskFormTypes;
    protected List<String> startEventFormTypes;
    protected int nextFlowIdCounter = 1;
    protected Object eventSupport;
    protected OrderedNodesInfo orderedNodesInfo;
    protected Date lastDynamicUpdateTime;
    protected Boolean autoFlow = null;

    public Map<String, List<ExtensionAttribute>> getDefinitionsAttributes() {
        return this.definitionsAttributes;
    }

    public String getDefinitionsAttributeValue(String namespace, String name) {
        List<ExtensionAttribute> attributes = this.getDefinitionsAttributes().get(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (ExtensionAttribute attribute : attributes) {
                if (!namespace.equals(attribute.getNamespace())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public void addDefinitionsAttribute(ExtensionAttribute attribute) {
        if (attribute != null && StringUtils.isNotEmpty((String)attribute.getName())) {
            ArrayList attributeList = null;
            if (!this.definitionsAttributes.containsKey(attribute.getName())) {
                attributeList = new ArrayList();
                this.definitionsAttributes.put(attribute.getName(), attributeList);
            }
            this.definitionsAttributes.get(attribute.getName()).add(attribute);
        }
    }

    public void setDefinitionsAttributes(Map<String, List<ExtensionAttribute>> attributes) {
        this.definitionsAttributes = attributes;
    }

    public Process getMainProcess() {
        if (!this.getPools().isEmpty()) {
            return this.getProcess(this.getPools().get(0).getId());
        }
        return this.getProcess(null);
    }

    public Process getProcess(String poolRef) {
        for (Process process : this.processes) {
            boolean foundPool = false;
            for (Pool pool : this.pools) {
                if (!StringUtils.isNotEmpty((String)pool.getProcessRef()) || !pool.getProcessRef().equalsIgnoreCase(process.getId())) continue;
                if (poolRef != null) {
                    if (!pool.getId().equalsIgnoreCase(poolRef)) continue;
                    foundPool = true;
                    continue;
                }
                foundPool = true;
            }
            if ((poolRef != null || foundPool) && (poolRef == null || !foundPool)) continue;
            return process;
        }
        return null;
    }

    public Process getProcessById(String id) {
        for (Process process : this.processes) {
            if (!process.getId().equals(id)) continue;
            return process;
        }
        return null;
    }

    public List<Process> getProcesses() {
        return this.processes;
    }

    public void addProcess(Process process) {
        this.processes.add(process);
    }

    public Pool getPool(String id) {
        Pool foundPool = null;
        if (StringUtils.isNotEmpty((String)id)) {
            for (Pool pool : this.pools) {
                if (!id.equals(pool.getId())) continue;
                foundPool = pool;
                break;
            }
        }
        return foundPool;
    }

    public Lane getLane(String id) {
        Lane foundLane = null;
        if (StringUtils.isNotEmpty((String)id)) {
            for (Process process : this.processes) {
                for (Lane lane : process.getLanes()) {
                    if (!id.equals(lane.getId())) continue;
                    foundLane = lane;
                    break;
                }
                if (foundLane == null) continue;
                break;
            }
        }
        return foundLane;
    }

    public FlowElement getFlowElement(String id) {
        Process process2;
        FlowElement foundFlowElement = null;
        Iterator<Process> iterator = this.processes.iterator();
        while (iterator.hasNext() && (foundFlowElement = (process2 = iterator.next()).getFlowElement(id)) == null) {
        }
        if (foundFlowElement == null) {
            for (Process process2 : this.processes) {
                FlowElement flowElement;
                Iterator<SubProcess> iterator2 = process2.findFlowElementsOfType(SubProcess.class).iterator();
                while (iterator2.hasNext() && (foundFlowElement = this.getFlowElementInSubProcess(id, (SubProcess)(flowElement = (FlowElement)iterator2.next()))) == null) {
                }
                if (foundFlowElement == null) continue;
                break;
            }
        }
        return foundFlowElement;
    }

    protected FlowElement getFlowElementInSubProcess(String id, SubProcess subProcess) {
        FlowElement foundFlowElement;
        block1: {
            foundFlowElement = subProcess.getFlowElement(id);
            if (foundFlowElement != null) break block1;
            for (FlowElement flowElement : subProcess.getFlowElements()) {
                if (flowElement instanceof SubProcess && (foundFlowElement = this.getFlowElementInSubProcess(id, (SubProcess)flowElement)) != null) break;
            }
        }
        return foundFlowElement;
    }

    public Artifact getArtifact(String id) {
        Process process2;
        Artifact foundArtifact = null;
        Iterator<Process> iterator = this.processes.iterator();
        while (iterator.hasNext() && (foundArtifact = (process2 = iterator.next()).getArtifact(id)) == null) {
        }
        if (foundArtifact == null) {
            for (Process process2 : this.processes) {
                FlowElement flowElement;
                Iterator<SubProcess> iterator2 = process2.findFlowElementsOfType(SubProcess.class).iterator();
                while (iterator2.hasNext() && (foundArtifact = this.getArtifactInSubProcess(id, (SubProcess)(flowElement = (FlowElement)iterator2.next()))) == null) {
                }
                if (foundArtifact == null) continue;
                break;
            }
        }
        return foundArtifact;
    }

    protected Artifact getArtifactInSubProcess(String id, SubProcess subProcess) {
        Artifact foundArtifact;
        block1: {
            foundArtifact = subProcess.getArtifact(id);
            if (foundArtifact != null) break block1;
            for (FlowElement flowElement : subProcess.getFlowElements()) {
                if (flowElement instanceof SubProcess && (foundArtifact = this.getArtifactInSubProcess(id, (SubProcess)flowElement)) != null) break;
            }
        }
        return foundArtifact;
    }

    public void addGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.locationMap.put(key, graphicInfo);
    }

    public GraphicInfo getGraphicInfo(String key) {
        return this.locationMap.get(key);
    }

    public void removeGraphicInfo(String key) {
        this.locationMap.remove(key);
    }

    public List<GraphicInfo> getFlowLocationGraphicInfo(String key) {
        return this.flowLocationMap.get(key);
    }

    public void removeFlowGraphicInfoList(String key) {
        this.flowLocationMap.remove(key);
    }

    public Map<String, GraphicInfo> getLocationMap() {
        return this.locationMap;
    }

    public Map<String, List<GraphicInfo>> getFlowLocationMap() {
        return this.flowLocationMap;
    }

    public GraphicInfo getLabelGraphicInfo(String key) {
        return this.labelLocationMap.get(key);
    }

    public void addLabelGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.labelLocationMap.put(key, graphicInfo);
    }

    public void removeLabelGraphicInfo(String key) {
        this.labelLocationMap.remove(key);
    }

    public Map<String, GraphicInfo> getLabelLocationMap() {
        return this.labelLocationMap;
    }

    public GraphicInfo getLocation() {
        return this.location;
    }

    public void setLocation(GraphicInfo location) {
        this.location = location;
    }

    public void addFlowGraphicInfoList(String key, List<GraphicInfo> graphicInfoList) {
        this.flowLocationMap.put(key, graphicInfoList);
    }

    public Collection<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resourceList) {
        if (resourceList != null) {
            this.resources.clear();
            this.resources.addAll(resourceList);
        }
    }

    public void addResource(Resource resource) {
        if (resource != null) {
            this.resources.add(resource);
        }
    }

    public boolean containsResourceId(String resourceId) {
        return this.getResource(resourceId) != null;
    }

    public Resource getResource(String id) {
        for (Resource resource : this.resources) {
            if (!id.equals(resource.getId())) continue;
            return resource;
        }
        return null;
    }

    public Collection<Signal> getSignals() {
        return this.signals;
    }

    public void setSignals(Collection<Signal> signalList) {
        if (signalList != null) {
            this.signals.clear();
            this.signals.addAll(signalList);
        }
    }

    public void addSignal(Signal signal) {
        if (signal != null) {
            this.signals.add(signal);
        }
    }

    public boolean containsSignalId(String signalId) {
        return this.getSignal(signalId) != null;
    }

    public Signal getSignal(String id) {
        for (Signal signal : this.signals) {
            if (!id.equals(signal.getId())) continue;
            return signal;
        }
        return null;
    }

    public Map<String, MessageFlow> getMessageFlows() {
        return this.messageFlowMap;
    }

    public void setMessageFlows(Map<String, MessageFlow> messageFlows) {
        this.messageFlowMap = messageFlows;
    }

    public void addMessageFlow(MessageFlow messageFlow) {
        if (messageFlow != null && StringUtils.isNotEmpty((String)messageFlow.getId())) {
            this.messageFlowMap.put(messageFlow.getId(), messageFlow);
        }
    }

    public MessageFlow getMessageFlow(String id) {
        return this.messageFlowMap.get(id);
    }

    public boolean containsMessageFlowId(String messageFlowId) {
        return this.messageFlowMap.containsKey(messageFlowId);
    }

    public Collection<Message> getMessages() {
        return this.messageMap.values();
    }

    public void setMessages(Collection<Message> messageList) {
        if (messageList != null) {
            this.messageMap.clear();
            for (Message message : messageList) {
                this.addMessage(message);
            }
        }
    }

    public void addMessage(Message message) {
        if (message != null && StringUtils.isNotEmpty((String)message.getId())) {
            this.messageMap.put(message.getId(), message);
        }
    }

    public Message getMessage(String id) {
        int indexOfNS;
        Message result = this.messageMap.get(id);
        if (result == null && (indexOfNS = id.indexOf(58)) > 0) {
            String idNamespace = id.substring(0, indexOfNS);
            if (idNamespace.equalsIgnoreCase(this.getTargetNamespace())) {
                id = id.substring(indexOfNS + 1);
            }
            result = this.messageMap.get(id);
        }
        return result;
    }

    public boolean containsMessageId(String messageId) {
        return this.messageMap.containsKey(messageId);
    }

    public Map<String, String> getErrors() {
        return this.errorMap;
    }

    public void setErrors(Map<String, String> errorMap) {
        this.errorMap = errorMap;
    }

    public void addError(String errorRef, String errorCode) {
        if (StringUtils.isNotEmpty((String)errorRef)) {
            this.errorMap.put(errorRef, errorCode);
        }
    }

    public boolean containsErrorRef(String errorRef) {
        return this.errorMap.containsKey(errorRef);
    }

    public Map<String, ItemDefinition> getItemDefinitions() {
        return this.itemDefinitionMap;
    }

    public void setItemDefinitions(Map<String, ItemDefinition> itemDefinitionMap) {
        this.itemDefinitionMap = itemDefinitionMap;
    }

    public void addItemDefinition(String id, ItemDefinition item) {
        if (StringUtils.isNotEmpty((String)id)) {
            this.itemDefinitionMap.put(id, item);
        }
    }

    public boolean containsItemDefinitionId(String id) {
        return this.itemDefinitionMap.containsKey(id);
    }

    public List<Pool> getPools() {
        return this.pools;
    }

    public void setPools(List<Pool> pools) {
        this.pools = pools;
    }

    public List<Artifact> getGlobalArtifacts() {
        return this.globalArtifacts;
    }

    public void setGlobalArtifacts(List<Artifact> globalArtifacts) {
        this.globalArtifacts = globalArtifacts;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaceMap.put(prefix, uri);
    }

    public boolean containsNamespacePrefix(String prefix) {
        return this.namespaceMap.containsKey(prefix);
    }

    public String getNamespace(String prefix) {
        return this.namespaceMap.get(prefix);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaceMap;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public List<String> getUserTaskFormTypes() {
        return this.userTaskFormTypes;
    }

    public void setUserTaskFormTypes(List<String> userTaskFormTypes) {
        this.userTaskFormTypes = userTaskFormTypes;
    }

    public List<String> getStartEventFormTypes() {
        return this.startEventFormTypes;
    }

    public void setStartEventFormTypes(List<String> startEventFormTypes) {
        this.startEventFormTypes = startEventFormTypes;
    }

    @JsonIgnore
    public Object getEventSupport() {
        return this.eventSupport;
    }

    public void setEventSupport(Object eventSupport) {
        this.eventSupport = eventSupport;
    }

    public Set<String> getPreviousNodeIds(String nodeId) {
        if (this.orderedNodesInfo == null) {
            this.orderedNodesInfo = new OrderedNodesInfo(this);
        }
        return this.orderedNodesInfo.getPreviousNodeIds(this, nodeId);
    }

    public List<String> getFollowNodeIds(String nodeId) {
        if (this.orderedNodesInfo == null) {
            this.orderedNodesInfo = new OrderedNodesInfo(this);
        }
        Set<String> nodeIds = this.orderedNodesInfo.getFollowNodeIds(nodeId);
        ArrayList<String> ids = new ArrayList<String>(nodeIds.size());
        for (String id : nodeIds) {
            ids.add(id);
        }
        return ids;
    }

    public List<FlowElement> getPreviousNodes(String nodeId) {
        if (this.orderedNodesInfo == null) {
            this.orderedNodesInfo = new OrderedNodesInfo(this);
        }
        return this.orderedNodesInfo.getPreviousNodes(this, nodeId);
    }

    public List<FlowElement> getFollowNodes(String nodeId) {
        if (this.orderedNodesInfo == null) {
            this.orderedNodesInfo = new OrderedNodesInfo(this);
        }
        return this.orderedNodesInfo.getFollowNodes(this, nodeId);
    }

    public OrderedNodesInfo getOrderedNodesInfo() {
        return this.orderedNodesInfo;
    }

    public void setOrderedNodesInfo(OrderedNodesInfo orderedNodesInfo) {
        this.orderedNodesInfo = orderedNodesInfo;
    }

    public BpmnModel clone() {
        BpmnModel clone = new BpmnModel();
        this.setCloneInfoForProcess(clone);
        this.setCloneInfoForMap(clone);
        this.setCloneInfoForSignals(clone);
        this.setOtherCloneInfo(clone);
        return clone;
    }

    public int getNextFlowIdCounter() {
        return this.nextFlowIdCounter;
    }

    public void setNextFlowIdCounter(int nextFlowIdCounter) {
        this.nextFlowIdCounter = nextFlowIdCounter;
    }

    public Map<String, MessageFlow> getMessageFlowMap() {
        return this.messageFlowMap;
    }

    public void setMessageFlowMap(Map<String, MessageFlow> messageFlowMap) {
        this.messageFlowMap = messageFlowMap;
    }

    public Map<String, Message> getMessageMap() {
        return this.messageMap;
    }

    public void setMessageMap(Map<String, Message> messageMap) {
        this.messageMap = messageMap;
    }

    public Map<String, String> getErrorMap() {
        return this.errorMap;
    }

    public void setErrorMap(Map<String, String> errorMap) {
        this.errorMap = errorMap;
    }

    public Map<String, ItemDefinition> getItemDefinitionMap() {
        return this.itemDefinitionMap;
    }

    public void setItemDefinitionMap(Map<String, ItemDefinition> itemDefinitionMap) {
        this.itemDefinitionMap = itemDefinitionMap;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public void setProcesses(List<Process> processes) {
        this.processes = processes;
    }

    public void setLocationMap(Map<String, GraphicInfo> locationMap) {
        this.locationMap = locationMap;
    }

    public void setLabelLocationMap(Map<String, GraphicInfo> labelLocationMap) {
        this.labelLocationMap = labelLocationMap;
    }

    public void setFlowLocationMap(Map<String, List<GraphicInfo>> flowLocationMap) {
        this.flowLocationMap = flowLocationMap;
    }

    public void setSignals(List<Signal> signals) {
        this.signals = signals;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public Date getLastDynamicUpdateTime() {
        return this.lastDynamicUpdateTime;
    }

    public void setLastDynamicUpdateTime(Date lastDynamicUpdateTime) {
        this.lastDynamicUpdateTime = lastDynamicUpdateTime;
    }

    private void setCloneInfoForSignals(BpmnModel clone) {
        ArrayList<Signal> signals = new ArrayList<Signal>();
        if (this.getSignals() != null && !this.getSignals().isEmpty()) {
            for (Signal signal : this.getSignals()) {
                signals.add(signal.clone());
            }
        }
        clone.setSignals((List<Signal>)signals);
    }

    private void setCloneInfoForProcess(BpmnModel clone) {
        ArrayList<Process> processes = new ArrayList<Process>();
        if (this.getProcesses() != null && !this.getProcesses().isEmpty()) {
            for (Process process : this.getProcesses()) {
                processes.add(process.clone());
            }
        }
        clone.setProcesses(processes);
    }

    private void setCloneInfoForMap(BpmnModel clone) {
        LinkedHashMap<String, GraphicInfo> locationMap = new LinkedHashMap<String, GraphicInfo>(this.getLocationMap().size());
        for (String key : this.getLocationMap().keySet()) {
            GraphicInfo value = this.getLocationMap().get(key);
            locationMap.put(key, value.clone());
        }
        clone.setLocationMap(locationMap);
        LinkedHashMap<String, GraphicInfo> labelLocationMap = new LinkedHashMap<String, GraphicInfo>(this.getLabelLocationMap().size());
        for (String key : this.getLabelLocationMap().keySet()) {
            GraphicInfo value = this.getLabelLocationMap().get(key);
            labelLocationMap.put(key, value.clone());
        }
        clone.setLabelLocationMap(labelLocationMap);
        LinkedHashMap<String, List<GraphicInfo>> flowLocationMap = new LinkedHashMap<String, List<GraphicInfo>>(this.getFlowLocationMap().size());
        for (String key : this.getFlowLocationMap().keySet()) {
            List<GraphicInfo> srcValues = this.getFlowLocationMap().get(key);
            ArrayList<GraphicInfo> newValues = new ArrayList<GraphicInfo>();
            if (srcValues != null && !srcValues.isEmpty()) {
                for (GraphicInfo scrValue : srcValues) {
                    newValues.add(scrValue.clone());
                }
            }
            flowLocationMap.put(key, newValues);
        }
        clone.setFlowLocationMap(flowLocationMap);
    }

    private void setOtherCloneInfo(BpmnModel clone) {
        clone.setLocation(this.location);
        clone.setTargetNamespace(this.targetNamespace);
        clone.setSourceSystemId(this.sourceSystemId);
        clone.setEventSupport(this.eventSupport);
        clone.setNextFlowIdCounter(this.nextFlowIdCounter);
        clone.setOrderedNodesInfo(null);
        ArrayList<Pool> pools = new ArrayList<Pool>();
        if (this.getPools() != null && !this.getPools().isEmpty()) {
            for (Pool pool : this.getPools()) {
                pools.add(pool.clone());
            }
        }
        clone.setPools(pools);
        ArrayList<Artifact> globalArtifacts = new ArrayList<Artifact>();
        if (this.getGlobalArtifacts() != null && !this.getGlobalArtifacts().isEmpty()) {
            for (Artifact artifact : this.getGlobalArtifacts()) {
                globalArtifacts.add(artifact.clone());
            }
        }
        clone.setGlobalArtifacts(globalArtifacts);
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        if (this.getResources() != null && !this.getResources().isEmpty()) {
            for (Resource resource : this.getResources()) {
                arrayList.add((Resource)resource.clone());
            }
        }
        clone.setResources((List<Resource>)arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.getUserTaskFormTypes() != null && !this.getUserTaskFormTypes().isEmpty()) {
            for (String string : this.getUserTaskFormTypes()) {
                arrayList2.add(string);
            }
        }
        clone.setUserTaskFormTypes(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (this.getStartEventFormTypes() != null && !this.getStartEventFormTypes().isEmpty()) {
            for (String type : this.getStartEventFormTypes()) {
                arrayList3.add(type);
            }
        }
        clone.setStartEventFormTypes(arrayList3);
        LinkedHashMap<String, List<ExtensionAttribute>> linkedHashMap = new LinkedHashMap<String, List<ExtensionAttribute>>(this.getDefinitionsAttributes().size());
        for (String key : this.getDefinitionsAttributes().keySet()) {
            List<ExtensionAttribute> srcValues = this.getDefinitionsAttributes().get(key);
            ArrayList<ExtensionAttribute> newValues = new ArrayList<ExtensionAttribute>();
            if (srcValues != null && !srcValues.isEmpty()) {
                for (ExtensionAttribute scrValue : srcValues) {
                    newValues.add(scrValue.clone());
                }
            }
            linkedHashMap.put(key, newValues);
        }
        clone.setDefinitionsAttributes(linkedHashMap);
        LinkedHashMap<String, MessageFlow> messageFlowMap = new LinkedHashMap<String, MessageFlow>(this.getMessageFlowMap().size());
        for (String key : this.getMessageFlowMap().keySet()) {
            MessageFlow value = this.getMessageFlowMap().get(key);
            messageFlowMap.put(key, value.clone());
        }
        clone.setMessageFlowMap(messageFlowMap);
        LinkedHashMap<String, Message> messageMap = new LinkedHashMap<String, Message>(this.getMessageMap().size());
        for (String key : this.getMessageMap().keySet()) {
            Message value = this.getMessageMap().get(key);
            messageMap.put(key, value.clone());
        }
        clone.setMessageMap(messageMap);
        LinkedHashMap<String, String> errorMap = new LinkedHashMap<String, String>(this.getErrorMap().size());
        for (String key : this.getErrorMap().keySet()) {
            String value = this.getErrorMap().get(key);
            errorMap.put(key, value);
        }
        clone.setErrorMap(errorMap);
        LinkedHashMap<String, ItemDefinition> itemDefinitionMap = new LinkedHashMap<String, ItemDefinition>(this.getItemDefinitionMap().size());
        for (String key : this.getItemDefinitionMap().keySet()) {
            ItemDefinition value = this.getItemDefinitionMap().get(key);
            itemDefinitionMap.put(key, value.clone());
        }
        clone.setItemDefinitionMap(itemDefinitionMap);
        LinkedHashMap<String, String> namespaceMap = new LinkedHashMap<String, String>(this.getNamespaceMap().size());
        for (String key : this.getNamespaceMap().keySet()) {
            String value = this.getNamespaceMap().get(key);
            namespaceMap.put(key, value);
        }
        clone.setNamespaceMap(namespaceMap);
        clone.setLastDynamicUpdateTime(this.getLastDynamicUpdateTime());
    }

    public BpmnModel copy(DuplicateModel model) {
        BpmnModel copyBpmnModel = new BpmnModel();
        if (null != model) {
            this.copyForProcess(model, copyBpmnModel);
            this.copyForMap(model, copyBpmnModel);
            this.copyForSignals(model, copyBpmnModel);
            this.setOtherCloneInfo(copyBpmnModel);
        } else {
            copyBpmnModel = this.clone();
        }
        return copyBpmnModel;
    }

    private void copyForSignals(DuplicateModel model, BpmnModel copyBpmnModel) {
        ArrayList<Signal> signals = new ArrayList<Signal>();
        if (this.getSignals() != null && !this.getSignals().isEmpty()) {
            for (Signal signal : this.getSignals()) {
                signals.add((Signal)signal.copy(model));
            }
        }
        copyBpmnModel.setSignals((List<Signal>)signals);
    }

    private void copyForProcess(DuplicateModel model, BpmnModel copyBpmnModel) {
        ArrayList<Process> processes = new ArrayList<Process>();
        if (this.getProcesses() != null && !this.getProcesses().isEmpty()) {
            for (Process process : this.getProcesses()) {
                List<FlowElement> elements = process.getFlowElementList();
                if (null != elements && 0 != elements.size()) {
                    for (FlowElement flowElement : elements) {
                        flowElement.copy(model);
                    }
                }
                processes.add((Process)process.copy(model));
            }
        }
        copyBpmnModel.setProcesses(processes);
    }

    private void copyForMap(DuplicateModel model, BpmnModel copyBpmnModel) {
        String modelKeyOld = model.getModelKeyOld();
        String modelKey = model.getModelKey();
        this.copyForLocationMap(modelKeyOld, modelKey, copyBpmnModel);
        this.copyForLabelLocationMap(modelKeyOld, modelKey, copyBpmnModel);
        this.copyForFlowLocationMap(modelKeyOld, modelKey, copyBpmnModel);
    }

    private void copyForFlowLocationMap(String oldValue, String newValue, BpmnModel copyBpmnModel) {
        Map<String, List<GraphicInfo>> newMap = BpmnModelUtil.copyForMap(oldValue, newValue, this.getFlowLocationMap());
        if (null != newMap && 0 != newMap.size()) {
            copyBpmnModel.setFlowLocationMap(newMap);
        }
    }

    private void copyForLocationMap(String oldValue, String newValue, BpmnModel copyBpmnModel) {
        Map<String, GraphicInfo> newMap = BpmnModelUtil.copyForMap(oldValue, newValue, this.getLocationMap());
        if (null != newMap && 0 != newMap.size()) {
            copyBpmnModel.setLocationMap(newMap);
        }
    }

    private void copyForLabelLocationMap(String oldValue, String newValue, BpmnModel copyBpmnModel) {
        Map<String, GraphicInfo> newMap = BpmnModelUtil.copyForMap(oldValue, newValue, this.getLabelLocationMap());
        if (null != newMap && 0 != newMap.size()) {
            copyBpmnModel.setLabelLocationMap(newMap);
        }
    }

    public boolean isAutoFlow() {
        if (this.autoFlow == null) {
            int auditcount = 0;
            int usertaskcount = 0;
            List<FlowElement> flowelems = this.getMainProcess().getFlowElementList();
            for (FlowElement elem : flowelems) {
                if (BpmnModelUtil.instanceofUserTaskOnly(elem.getType())) {
                    ++usertaskcount;
                    continue;
                }
                if (!BpmnModelUtil.instanceofAuditTask(elem.getType())) continue;
                ++auditcount;
            }
            this.autoFlow = "AuditFlow".equalsIgnoreCase(this.getMainProcess().getProcessType()) && auditcount == 0 && usertaskcount == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.autoFlow == null ? Boolean.FALSE.booleanValue() : this.autoFlow.booleanValue();
    }
}

