/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.CompensateBackSet;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.EventDefinition;

public class CompensateEventDefinition
extends EventDefinition {
    protected String activityRef;
    protected boolean waitForCompletion = true;
    protected List<CompensateBackSet> backSet = new ArrayList<CompensateBackSet>();

    public String getActivityRef() {
        return this.activityRef;
    }

    public void setActivityRef(String activityRef) {
        this.activityRef = activityRef;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    @Override
    public CompensateEventDefinition clone() {
        CompensateEventDefinition clone = new CompensateEventDefinition();
        clone.setValues(this);
        return clone;
    }

    public List<CompensateBackSet> getBackSet() {
        return this.backSet;
    }

    public void setBackSet(List<CompensateBackSet> backSet) {
        this.backSet = backSet;
    }

    public void setValues(CompensateEventDefinition otherDefinition) {
        super.setValues(otherDefinition);
        this.setActivityRef(otherDefinition.getActivityRef());
        this.setWaitForCompletion(otherDefinition.isWaitForCompletion());
        List<CompensateBackSet> bs = otherDefinition.getBackSet();
        if (bs != null && !bs.isEmpty()) {
            ArrayList<CompensateBackSet> cbs = new ArrayList<CompensateBackSet>(bs.size());
            for (CompensateBackSet bsItem : bs) {
                if (bsItem == null) continue;
                cbs.add((CompensateBackSet)bsItem.clone());
            }
            this.setBackSet(cbs);
        }
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        CompensateEventDefinition def = (CompensateEventDefinition)super.copy(model);
        String actRefId = this.getCopyValueForReplace(def.getActivityRef(), model.getModelKeyOld(), model.getModelKey());
        def.setActivityRef(actRefId);
        if (def.getBackSet() != null && !def.getBackSet().isEmpty()) {
            for (CompensateBackSet bs : def.getBackSet()) {
                bs.setBackNode(this.getCopyValueForReplace(bs.getBackNode(), model.getModelKeyOld(), model.getModelKey()));
            }
        }
        return def;
    }
}

