/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DecisionOption
extends BaseElement {
    public static final String AUDIT_TYPE_APPROVE = "approve";
    public static final String AUDIT_TYPE_REJECT = "reject";
    public static final String AUDIT_TYPE_TERMINATE = "terminate";
    public static final String AUDIT_TYPE_FORCEREJECT = "forceReject";
    public static final String REJECT_TO_PRE_AUDIT_NODE = "rejectToPreAuditNode";
    public static final String REJECT_TO_EDIT_NODE = "rejectToEditNode";
    public static final String REJECT_TO_ALL_AUDIT_NODE = "rejectToAllAuditNode";
    public static final String REJECT_TO_PARENTPROC_EDIT_NODE = "rejectToParentProcEditNode";
    public static final String REJECT_TO_PARENTPROC_PRE_NODE = "rejectToParentProcPreNode";
    public static final String TERMINATE_MAINPROCESS = "terminateMainProcess";
    protected String name;
    protected String decisionScene;
    protected boolean defaultDecision;
    protected String auditType;
    protected List<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();

    @Override
    public DecisionOption clone() {
        DecisionOption clone = new DecisionOption();
        clone.setNumber(this.getNumber());
        clone.setName(this.getName());
        clone.setDefaultDecision(this.isDefaultDecision());
        clone.setAuditType(this.getAuditType());
        clone.setDecisionScene(this.getDecisionScene());
        ArrayList<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();
        if (this.getRejectOptions() != null && !this.getRejectOptions().isEmpty()) {
            for (SelectNodesModel rejectOption : this.getRejectOptions()) {
                SelectNodesModel option = new SelectNodesModel();
                option.setItemId(rejectOption.getItemId());
                option.setName(rejectOption.getName());
                option.setDocumentation(rejectOption.getDocumentation());
                rejectOptions.add(option);
            }
        }
        clone.setRejectOptions(rejectOptions);
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDefaultDecision() {
        return this.defaultDecision;
    }

    public void setDefaultDecision(boolean defaultDecision) {
        this.defaultDecision = defaultDecision;
    }

    public String getAuditType() {
        return this.auditType;
    }

    public void setAuditType(String auditType) {
        this.auditType = auditType;
    }

    public List<SelectNodesModel> getRejectOptions() {
        return this.rejectOptions;
    }

    public void setRejectOptions(List<SelectNodesModel> rejectOptions) {
        this.rejectOptions = rejectOptions;
    }

    public String getDecisionScene() {
        return this.decisionScene;
    }

    public void setDecisionScene(String decisionScene) {
        this.decisionScene = decisionScene;
    }

    public boolean isRejectPreNodeScene() {
        return this.decisionScene != null && this.decisionScene.equals(REJECT_TO_PRE_AUDIT_NODE);
    }

    public boolean isRejectToParentProcessScene() {
        return this.decisionScene != null && (this.decisionScene.equals(REJECT_TO_PARENTPROC_EDIT_NODE) || this.decisionScene.equals(REJECT_TO_PARENTPROC_PRE_NODE));
    }

    public boolean isTerminateMainProcessScene() {
        return this.decisionScene != null && this.decisionScene.equals(TERMINATE_MAINPROCESS);
    }
}

