/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.graph.model.GraphIcon;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.HasExecutionListeners;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class FlowElement
extends BaseElement
implements HasExecutionListeners {
    protected String name;
    protected String documentation;
    protected String style;
    protected GraphIcon icon;
    protected Map<String, Object> datas = new HashMap<String, Object>();
    protected List<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
    protected FlowElementsContainer parentContainer;
    protected boolean dynamic;
    protected String type;
    private String template;
    private Long templateId;
    private boolean addSign;

    public boolean isAddSign() {
        return this.addSign;
    }

    public void setAddSign(boolean addSign) {
        this.addSign = addSign;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Override
    public List<ActivitiListener> getExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public void setExecutionListeners(List<ActivitiListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    @JsonIgnore
    public FlowElementsContainer getParentContainer() {
        return this.parentContainer;
    }

    @JsonIgnore
    public SubProcess getSubProcess() {
        SubProcess subProcess = null;
        if (this.parentContainer instanceof SubProcess) {
            subProcess = (SubProcess)this.parentContainer;
        }
        return subProcess;
    }

    public void setParentContainer(FlowElementsContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public GraphIcon getIcon() {
        return this.icon;
    }

    public void setIcon(GraphIcon icon) {
        this.icon = icon;
    }

    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public void setDatas(Map<String, Object> datas) {
        this.datas = datas;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    @Override
    public abstract FlowElement clone();

    public void setValues(FlowElement otherElement) {
        super.setValues(otherElement);
        this.setName(otherElement.getName());
        this.setDocumentation(otherElement.getDocumentation());
        this.setStyle(otherElement.getStyle());
        this.setDynamic(otherElement.isDynamic());
        this.setType(otherElement.getType());
        this.setTemplate(otherElement.getTemplate());
        this.setTemplateId(otherElement.getTemplateId());
        this.setAddSign(otherElement.isAddSign());
        this.executionListeners = new ArrayList<ActivitiListener>();
        if (otherElement.getExecutionListeners() != null && !otherElement.getExecutionListeners().isEmpty()) {
            for (ActivitiListener listener : otherElement.getExecutionListeners()) {
                this.executionListeners.add(listener.clone());
            }
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        return super.copy(model);
    }
}

