/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IntermediateThrow;
import kd.bos.workflow.bpmn.model.NodeControlIntensity;
import kd.bos.workflow.bpmn.model.SequenceFlow;

public abstract class FlowNode
extends FlowElement
implements IntermediateThrow {
    public static final String OUTSET_LEAVEWHENALLMEET = "leavewhenallmeet";
    public static final String OUTSET_LEAVEWITHALLNOTJOIN = "leavewithallnotjoin";
    public static final String OUTSET_LEAVEWHENONLYONE = "leavewhenonlyone";
    public static final String OUTSET_LEAVEWHENFRISTONE = "leavewhenfristone";
    public static final String INSET_ENTERWHENALLARRIVE = "enterwhenallarrive";
    public static final String INSET_ENTERWHENFIRSTONE = "enterwhenfirstone";
    public static final String INSET_ENTERWHENANYARRIVE = "enterwhenanyarrive";
    public static final String PASSTYPEAFTERINNERREJECT_ALL = "all";
    public static final String PASSTYPEAFTERINNERREJECT_REJECT = "reject";
    protected String outSet = "leavewhenallmeet";
    protected String inSet = "enterwhenallarrive";
    protected Boolean fork;
    protected Boolean join;
    protected String passTypeAfterInnerReject;
    protected String defaultFlow;
    protected boolean asynchronous = true;
    protected boolean notExclusive;
    protected NodeControlIntensity controlIntensity;
    protected boolean triggerCompensation;
    protected String mapperThrowableCodes;
    protected String compensationStrategy = "onlyToSavePoint";
    public static final String STRATEGY_ALLTOSAVEPOINT = "allToSavePoint";
    public static final String STRATEGY_ONLYTOSAVEPOINT = "onlyToSavePoint";
    protected List<CustomParam> customParams = new ArrayList<CustomParam>();
    protected List<SequenceFlow> incomingFlows = new ArrayList<SequenceFlow>();
    protected List<SequenceFlow> outgoingFlows = new ArrayList<SequenceFlow>();
    @JsonIgnore
    protected Object behavior;

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = true;
    }

    public boolean isExclusive() {
        return !this.notExclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.notExclusive = !exclusive;
    }

    public boolean isNotExclusive() {
        return this.notExclusive;
    }

    public void setNotExclusive(boolean notExclusive) {
        this.notExclusive = notExclusive;
    }

    public Object getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Object behavior) {
        this.behavior = behavior;
    }

    public List<CustomParam> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(List<CustomParam> customParams) {
        this.customParams = customParams;
    }

    public List<SequenceFlow> getIncomingFlows() {
        return this.incomingFlows;
    }

    public void setIncomingFlows(List<SequenceFlow> incomingFlows) {
        this.incomingFlows = incomingFlows;
    }

    public List<SequenceFlow> getOutgoingFlows() {
        return this.outgoingFlows;
    }

    public void setOutgoingFlows(List<SequenceFlow> outgoingFlows) {
        this.outgoingFlows = outgoingFlows;
    }

    public String getDefaultFlow() {
        return this.defaultFlow;
    }

    public void setDefaultFlow(String defaultFlow) {
        this.defaultFlow = defaultFlow;
    }

    public String getOutSet() {
        return this.outSet;
    }

    public void setOutSet(String outSet) {
        this.outSet = outSet;
    }

    public Boolean getFork() {
        return this.fork;
    }

    public void setFork(Boolean fork) {
        this.fork = fork;
    }

    public Boolean getJoin() {
        return this.join;
    }

    public void setJoin(Boolean join) {
        this.join = join;
    }

    public String getInSet() {
        return this.inSet;
    }

    public void setInSet(String inSet) {
        this.inSet = inSet;
    }

    public String getPassTypeAfterInnerReject() {
        return this.passTypeAfterInnerReject;
    }

    public void setPassTypeAfterInnerReject(String passTypeAfterInnerReject) {
        this.passTypeAfterInnerReject = passTypeAfterInnerReject;
    }

    @Override
    public boolean isTriggerCompensation() {
        return this.triggerCompensation;
    }

    @Override
    public void setTriggerCompensation(boolean triggercompensation) {
        this.triggerCompensation = triggercompensation;
    }

    @Override
    public String getMapperThrowableCodes() {
        return this.mapperThrowableCodes;
    }

    @Override
    public void setMapperThrowableCodes(String mapperthrowablecodes) {
        this.mapperThrowableCodes = mapperthrowablecodes;
    }

    public NodeControlIntensity getControlIntensity() {
        return this.controlIntensity;
    }

    public void setControlIntensity(NodeControlIntensity controlIntensity) {
        this.controlIntensity = controlIntensity;
    }

    public String getCompensationStrategy() {
        return this.compensationStrategy;
    }

    public void setCompensationStrategy(String compensationStrategy) {
        this.compensationStrategy = compensationStrategy;
    }

    public void setValues(FlowNode otherNode) {
        super.setValues(otherNode);
        this.setAsynchronous(otherNode.isAsynchronous());
        this.setNotExclusive(otherNode.isNotExclusive());
        this.setBehavior(otherNode.getBehavior());
        this.setDefaultFlow(otherNode.getDefaultFlow());
        this.setOutSet(otherNode.getOutSet());
        this.setInSet(otherNode.getInSet());
        if (otherNode.getControlIntensity() != null) {
            this.setControlIntensity(otherNode.getControlIntensity().clone());
        }
        this.setPassTypeAfterInnerReject(otherNode.getPassTypeAfterInnerReject());
        if (otherNode.getJoin() != null) {
            this.setJoin(otherNode.getJoin());
        }
        if (otherNode.getFork() != null) {
            this.setFork(otherNode.getFork());
        }
        this.setCompensationStrategy(otherNode.getCompensationStrategy());
        this.incomingFlows = new ArrayList<SequenceFlow>();
        if (otherNode.getIncomingFlows() != null && !otherNode.getIncomingFlows().isEmpty()) {
            for (SequenceFlow sequenceFlow : otherNode.getIncomingFlows()) {
                this.incomingFlows.add(sequenceFlow.clone());
            }
        }
        this.outgoingFlows = new ArrayList<SequenceFlow>();
        if (otherNode.getOutgoingFlows() != null && !otherNode.getOutgoingFlows().isEmpty()) {
            for (SequenceFlow sequenceFlow : otherNode.getOutgoingFlows()) {
                this.outgoingFlows.add(sequenceFlow.clone());
            }
        }
        if (otherNode.getCustomParams() != null && !otherNode.getCustomParams().isEmpty()) {
            this.customParams = new ArrayList<CustomParam>(otherNode.getCustomParams().size());
            for (CustomParam customParam : otherNode.getCustomParams()) {
                this.customParams.add(customParam.clone());
            }
        }
    }
}

