/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class OrderedNodesInfo {
    private static final int MAXNUM = 10000;
    private Log log = LogFactory.getLog(this.getClass());
    private String startId = "";
    private int calNum = 0;
    private int timesLimit = 10000;
    private boolean enableLimit = false;
    private Map<String, Set<String>> previousNodesMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> followNodesMap = new HashMap<String, Set<String>>();

    public OrderedNodesInfo(BpmnModel bpmnModel) {
        this.initCirclePathTimesLimit();
        this.initPreviousNodesMap(bpmnModel);
        this.initFollowNodesMap(bpmnModel);
    }

    private void initCirclePathTimesLimit() {
        try {
            String limit;
            this.enableLimit = "true".equals(WfConfigurationUtil.getConfigCenterVal("workflow.config.enableFindCirclePathLimit"));
            if (!this.enableLimit) {
                return;
            }
            Object value = WfConfigurationUtil.getConfigCenterVal("workflow.config.findCirclePathTimesLimit");
            if (value instanceof String && (limit = (String)value).matches("\\d{1,9}")) {
                this.timesLimit = Integer.parseInt(limit);
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    public Set<String> getPreviousNodeIds(BpmnModel bpmnModel, String nodeId) {
        return this.getPreviousNodeIds(nodeId, new HashSet<String>());
    }

    private Set<String> getPreviousNodeIds(String nodeId, Set<String> ignoreNodeIds) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        this.addPreviousNodeIds(ids, nodeId, ignoreNodeIds);
        ids.remove(nodeId);
        return ids;
    }

    public List<FlowElement> getPreviousNodes(BpmnModel bpmnModel, String nodeId) {
        HashMap<String, List<String>> circlePaths;
        String pk = bpmnModel == null || bpmnModel.getMainProcess() == null ? "" : bpmnModel.getMainProcess().getId();
        boolean needControlLoop = WfConfigurationUtil.needControlCirthPathNum(pk, nodeId);
        boolean findCirclePathMethodControl = "true".equals(WfConfigurationUtil.getConfigCenterVal("workflow.config.findCirclePathMethodControl"));
        if (findCirclePathMethodControl) {
            circlePaths = this.getCirclePathsDFS(nodeId, needControlLoop);
        } else {
            circlePaths = new HashMap();
            this.initCirclePaths(circlePaths, this.startId, nodeId, needControlLoop);
        }
        if (this.calNum > this.timesLimit) {
            circlePaths.clear();
            this.log.debug(String.format("process is too complicate,please optimize process[%s].", nodeId));
        }
        Set<String> circleFollowIds = this.getCircleFollowIds(nodeId, circlePaths);
        circlePaths.clear();
        Set<String> ids = this.getPreviousNodeIds(nodeId, circleFollowIds);
        ArrayList<FlowElement> prevNodes = new ArrayList<FlowElement>(ids.size());
        if (bpmnModel != null && CollectionUtil.isNotEmpty(ids)) {
            for (String id : ids) {
                FlowElement node = bpmnModel.getFlowElement(id);
                if (node == null) {
                    this.log.debug(id + " not exist!");
                    continue;
                }
                prevNodes.add(node);
            }
        }
        return prevNodes;
    }

    private Set<String> getCircleFollowIds(String nodeId, Map<String, List<String>> circlePaths) {
        HashSet<String> circleFollowIds = new HashSet<String>(16);
        HashSet<String> circlePreviousIds = new HashSet<String>(16);
        for (List<String> paths : circlePaths.values()) {
            int i;
            int index = paths.indexOf(nodeId);
            if (index <= -1) continue;
            for (i = index + 1; i < paths.size(); ++i) {
                circleFollowIds.add(paths.get(i));
            }
            for (i = 0; i < index; ++i) {
                circlePreviousIds.add(paths.get(i));
            }
        }
        circleFollowIds.removeAll(circlePreviousIds);
        return circleFollowIds;
    }

    private Map<String, List<String>> getCirclePathsDFS(String curNodeId, boolean needControlLoop) {
        HashMap<String, List<String>> circlePaths = new HashMap<String, List<String>>(16);
        List<Object> pathRecords = new ArrayList<String>();
        Stack<String> dfsStack = new Stack<String>();
        LinkedList<ForkRecord> forkRecordQueue = new LinkedList<ForkRecord>();
        dfsStack.push(this.startId);
        this.calNum = 0;
        while (!(dfsStack.isEmpty() && forkRecordQueue.isEmpty() || (this.enableLimit || needControlLoop) && ++this.calNum > this.timesLimit)) {
            String nodeId = "";
            if (!dfsStack.isEmpty()) {
                nodeId = (String)dfsStack.pop();
            } else {
                ForkRecord forkRecord = (ForkRecord)forkRecordQueue.poll();
                nodeId = forkRecord.getNodeId();
                pathRecords = forkRecord.getPrePaths();
            }
            pathRecords.add(nodeId);
            Set<String> followNodes = this.followNodesMap.get(nodeId);
            for (String followNodeId : followNodes) {
                if (pathRecords.contains(followNodeId)) {
                    List<Object> paths = pathRecords.subList(pathRecords.indexOf(followNodeId), pathRecords.size());
                    if (!paths.contains(curNodeId)) continue;
                    ArrayList<Object> keys = new ArrayList<Object>(paths);
                    Collections.sort(keys);
                    String pathKey = String.valueOf(keys);
                    circlePaths.putIfAbsent(pathKey, new ArrayList<Object>(paths));
                    continue;
                }
                if (dfsStack.isEmpty()) {
                    dfsStack.push(followNodeId);
                    continue;
                }
                ForkRecord forkRecord = new ForkRecord(followNodeId, nodeId, new ArrayList<Object>(pathRecords));
                forkRecordQueue.offer(forkRecord);
            }
        }
        return circlePaths;
    }

    public Set<String> getFollowNodeIds(String nodeId) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        LinkedList<String> queue = new LinkedList<String>();
        queue.offer(nodeId);
        this.addFollowNodeIds(queue, ids, nodeId);
        return ids;
    }

    public List<FlowElement> getFollowNodes(BpmnModel bpmnModel, String nodeId) {
        Set<String> ids = this.getFollowNodeIds(nodeId);
        ArrayList<FlowElement> followNodes = new ArrayList<FlowElement>(ids.size());
        for (String id : ids) {
            followNodes.add(bpmnModel.getFlowElement(id));
        }
        return followNodes;
    }

    private void addFollowNodeIds(Queue<String> queue, Set<String> followNodeIds, String nodeId) {
        while (!queue.isEmpty()) {
            Set<String> nodeIds;
            String nid = queue.poll();
            if (followNodeIds.contains(nid)) {
                this.log.debug(String.format("nodeId %s in followNodesMap...", nid));
                continue;
            }
            if (!nodeId.equals(nid)) {
                followNodeIds.add(nid);
            }
            if ((nodeIds = this.followNodesMap.get(nid)) == null || nodeIds.isEmpty()) continue;
            for (String id : nodeIds) {
                if (queue.contains(id)) {
                    this.log.debug(String.format("nodeId %s in queue...", id));
                    continue;
                }
                queue.offer(id);
            }
        }
    }

    private void addPreviousNodeIds(Set<String> previousNodeIds, String nodeId, Set<String> ignoreNodeIds) {
        Set<String> nodeIds = this.previousNodesMap.get(nodeId);
        if (nodeIds != null && !nodeIds.isEmpty()) {
            for (String id : nodeIds) {
                if (ignoreNodeIds.contains(id) || !previousNodeIds.add(id)) continue;
                this.addPreviousNodeIds(previousNodeIds, id, ignoreNodeIds);
            }
        }
    }

    private void initFollowNodesMap(BpmnModel bpmnModel) {
        Process process = bpmnModel.getMainProcess();
        if (process != null) {
            List<StartEvent> events = process.findFlowElementsOfType(StartEvent.class);
            if (events.isEmpty()) {
                this.log.debug("no startevent!");
                return;
            }
            StartEvent start = events.get(0);
            this.startId = start.getId();
            this.initFollowNodes(start);
        }
    }

    private void initCirclePaths(Map<String, List<String>> circlePaths, String startId, String targetId, boolean needControlLoop) {
        this.calNum = 0;
        Stack<String> paths = new Stack<String>();
        this.findCirclePath(circlePaths, paths, startId, targetId, needControlLoop);
    }

    private void findCirclePath(Map<String, List<String>> circlePaths, Stack<String> paths, String nodeId, String targetId, boolean needControlLoop) {
        if (this.enableLimit ? ++this.calNum > this.timesLimit : needControlLoop && ++this.calNum > this.timesLimit) {
            return;
        }
        Set<String> followIds = this.followNodesMap.get(nodeId);
        if (followIds == null || followIds.isEmpty()) {
            return;
        }
        for (String id : followIds) {
            int index = paths.indexOf(id);
            if (index > -1) {
                if (!paths.contains(targetId)) continue;
                List temp = paths.subList(index, paths.size());
                ArrayList keys = new ArrayList(temp);
                Collections.sort(keys);
                String key = String.valueOf(keys);
                if (circlePaths.containsKey(key)) continue;
                circlePaths.put(key, new ArrayList(temp));
                continue;
            }
            paths.add(id);
            this.findCirclePath(circlePaths, paths, id, targetId, needControlLoop);
            paths.pop();
        }
    }

    private void initPreviousNodesMap(BpmnModel bpmnModel) {
        Process process = bpmnModel.getMainProcess();
        if (process != null) {
            List<EndEvent> events = process.findFlowElementsOfType(EndEvent.class);
            if (events.isEmpty()) {
                this.log.debug("no endevent!");
                return;
            }
            EndEvent end = events.get(0);
            this.initPreviousNodes(end);
        }
    }

    private void initFollowNodes(FlowNode node) {
        if (this.followNodesMap.containsKey(node.getId())) {
            return;
        }
        List<SequenceFlow> outgoingFlows = node.getOutgoingFlows();
        ArrayList<FlowElement> followNodes = new ArrayList<FlowElement>(outgoingFlows.size());
        LinkedHashSet<String> followNodeIds = new LinkedHashSet<String>(outgoingFlows.size());
        for (SequenceFlow flow : outgoingFlows) {
            if (flow.getTargetRef() == null) {
                this.log.debug(flow.getId() + "no target!");
                continue;
            }
            if (node.getId() == null || node.getId().equalsIgnoreCase(flow.getTargetRef())) continue;
            followNodes.add(flow.getTargetFlowElement());
            followNodeIds.add(flow.getTargetRef());
        }
        this.followNodesMap.put(node.getId(), followNodeIds);
        for (FlowElement element : followNodes) {
            if (!(element instanceof FlowNode)) continue;
            this.initFollowNodes((FlowNode)element);
        }
    }

    private void initPreviousNodes(FlowNode node) {
        if (this.previousNodesMap.containsKey(node.getId())) {
            return;
        }
        List<SequenceFlow> incomingFlows = node.getIncomingFlows();
        ArrayList<FlowElement> prevNodes = new ArrayList<FlowElement>(incomingFlows.size());
        LinkedHashSet<String> prevNodeIds = new LinkedHashSet<String>(incomingFlows.size());
        for (SequenceFlow flow : incomingFlows) {
            if (flow.getSourceRef() == null) {
                this.log.debug(flow.getId() + "no source!");
                continue;
            }
            if (node.getId() == null || node.getId().equalsIgnoreCase(flow.getSourceRef())) continue;
            prevNodes.add(flow.getSourceFlowElement());
            prevNodeIds.add(flow.getSourceRef());
        }
        this.previousNodesMap.put(node.getId(), prevNodeIds);
        for (FlowElement element : prevNodes) {
            if (!(element instanceof FlowNode)) continue;
            this.initPreviousNodes((FlowNode)element);
        }
    }

    private static final class ForkRecord {
        private String nodeId;
        private String preNodeId;
        private List<String> prePaths = new ArrayList<String>();

        public ForkRecord(String nodeId, String preNodeId, List<String> prePaths) {
            this.nodeId = nodeId;
            this.preNodeId = preNodeId;
            this.prePaths = prePaths;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getPreNodeId() {
            return this.preNodeId;
        }

        public void setPreNodeId(String preNodeId) {
            this.preNodeId = preNodeId;
        }

        public List<String> getPrePaths() {
            return this.prePaths;
        }

        public void setPrePaths(List<String> prePaths) {
            this.prePaths = prePaths;
        }
    }
}

