/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.converter.field.TransIgnore;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.AfterAuditModel;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.Artifact;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.EventListener;
import kd.bos.workflow.bpmn.model.EventStartItem;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.HasExecutionListeners;
import kd.bos.workflow.bpmn.model.IOSpecification;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.StartItem;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.bpmn.model.basedata.BaseDataRecord;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.lang.StringUtils;

public class Process
extends BaseElement
implements FlowElementsContainer,
HasExecutionListeners {
    public static final String PROCESSMODE_SKIP = "skip";
    public static final String PROCESSMODE_AUTO = "auto";
    public static final String PROCESSMODE_MANUAL = "manual";
    protected ILocaleString name;
    protected boolean executable = true;
    protected ILocaleString documentation;
    protected IOSpecification ioSpecification;
    protected List<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
    protected List<Lane> lanes = new ArrayList<Lane>();
    protected List<FlowElement> flowElementList = new ArrayList<FlowElement>();
    protected List<ValuedDataObject> dataObjects = new ArrayList<ValuedDataObject>();
    protected List<Artifact> artifactList = new ArrayList<Artifact>();
    protected List<EventListener> eventListeners = new ArrayList<EventListener>();
    protected Map<String, FlowElement> flowElementMap = new LinkedHashMap<String, FlowElement>();
    protected Map<String, List<DynamicModelPartial>> dynamicModelPartial = new HashMap<String, List<DynamicModelPartial>>();
    protected Map<String, List<ActivitiListener>> nodeListener = new HashMap<String, List<ActivitiListener>>();
    protected Map<String, List<BaseDataRecord>> baseData = new HashMap<String, List<BaseDataRecord>>();
    protected FlowElement initialFlowElement;
    protected String simpleName;
    protected String entraBillName;
    protected String entraBill;
    protected String entraBillId;
    protected long orgUnitId;
    protected boolean isSetNextAssignee;
    protected String processMode;
    protected String startType;
    protected String triggerMode;
    protected String processType = ModelType.AuditFlow.name();
    protected Boolean autoAuditWhenSamePerson = false;
    protected Boolean withdrawProcInAuditing = false;
    protected Boolean suspendRemindSubmitter = false;
    protected String resourceId;
    protected String version;
    protected String bosVersion;
    protected String businessId;
    protected boolean subProcess;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Macro> macros = new ArrayList<Macro>();
    protected ConditionalRuleEntity startupcondrule;
    protected List<StartItem> startItems = new ArrayList<StartItem>();
    protected List<EventStartItem> evtStartItems = new ArrayList<EventStartItem>();
    protected String flowRecordFormatter;
    private List<BillExceptionOp> billExceptionOp = new ArrayList<BillExceptionOp>();
    private Map<String, Set<String>> nodeAffectJoinNodeComeFlow = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, NodeForkJoinModel> forkJoinModels = new ConcurrentHashMap<String, NodeForkJoinModel>();
    private boolean forkJoinModelsInit = false;
    private Map<String, List<FlowNode>> boundaryNodes = new ConcurrentHashMap<String, List<FlowNode>>();
    private Set<String> nonBoundaryNodes = new HashSet<String>();
    private AllowNextPersonSettingModel allowNextPersonSettingModel;
    protected ConditionalRuleEntity closeCondition;
    private LinkedHashMap<String, BoundaryEvent> compensateBoundaryAttachedNodes = new LinkedHashMap();
    private LinkedHashMap<String, FlowNode> compensateNodeAttachedNodes = new LinkedHashMap();
    private AfterAuditModel afterAudit;
    private ReentrantLock lock = new ReentrantLock();

    public String getDocumentation() {
        String newDocumentation = "";
        if (this.documentation != null) {
            newDocumentation = this.documentation.getLocaleValue();
        }
        return newDocumentation;
    }

    public void setDocumentation(ILocaleString documentation) {
        this.documentation = documentation;
    }

    public ILocaleString getProcessDocumentation() {
        return this.documentation;
    }

    public String getName() {
        String newName = "";
        if (this.name != null) {
            newName = this.name.getLocaleValue();
        }
        return newName;
    }

    public ILocaleString getProcessName() {
        return this.name;
    }

    public void setName(ILocaleString name) {
        this.name = name;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    @Override
    public List<ActivitiListener> getExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public void setExecutionListeners(List<ActivitiListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public void setLanes(List<Lane> lanes) {
        this.lanes = lanes;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, FlowElement> getFlowElementMap() {
        return this.flowElementMap;
    }

    public void setFlowElementMap(Map<String, FlowElement> flowElementMap) {
        this.flowElementMap = flowElementMap;
    }

    public boolean containsFlowElementId(String id) {
        return this.flowElementMap.containsKey(id);
    }

    @Override
    public FlowElement getFlowElement(String flowElementId) {
        return this.getFlowElement(flowElementId, false);
    }

    public Boolean getSuspendRemindSubmitter() {
        return this.suspendRemindSubmitter;
    }

    public void setSuspendRemindSubmitter(Boolean suspendRemindSubmitter) {
        this.suspendRemindSubmitter = suspendRemindSubmitter;
    }

    public FlowElement getFlowElement(String flowElementId, boolean searchRecurive) {
        if (searchRecurive) {
            return this.flowElementMap.get(flowElementId);
        }
        return this.findFlowElementInList(flowElementId);
    }

    public FlowElementsContainer getFlowElementsContainer(String flowElementId) {
        return this.getFlowElementsContainer(this, flowElementId);
    }

    protected FlowElementsContainer getFlowElementsContainer(FlowElementsContainer flowElementsContainer, String flowElementId) {
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            FlowElementsContainer result;
            if (flowElement.getId() != null && flowElement.getId().equals(flowElementId)) {
                return flowElementsContainer;
            }
            if (!(flowElement instanceof FlowElementsContainer) || (result = this.getFlowElementsContainer((FlowElementsContainer)((Object)flowElement), flowElementId)) == null) continue;
            return result;
        }
        return null;
    }

    protected FlowElement findFlowElementInList(String flowElementId) {
        for (FlowElement f : this.flowElementList) {
            if (f.getId() == null || !f.getId().equals(flowElementId)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return this.flowElementList;
    }

    @Override
    public void addFlowElement(FlowElement element) {
        this.flowElementList.add(element);
        element.setParentContainer(this);
        if (StringUtils.isNotEmpty((String)element.getId())) {
            this.flowElementMap.put(element.getId(), element);
        }
    }

    @Override
    public void addFlowElementToMap(FlowElement element) {
        if (element != null && StringUtils.isNotEmpty((String)element.getId())) {
            this.flowElementMap.put(element.getId(), element);
        }
    }

    @Override
    public void removeFlowElement(String elementId) {
        FlowElement element = this.flowElementMap.get(elementId);
        if (element != null) {
            this.flowElementList.remove(element);
            this.flowElementMap.remove(element.getId());
        }
    }

    @Override
    public void removeFlowElementFromMap(String elementId) {
        if (StringUtils.isNotEmpty((String)elementId)) {
            this.flowElementMap.remove(elementId);
        }
    }

    @Override
    public Artifact getArtifact(String id) {
        Artifact foundArtifact = null;
        for (Artifact artifact : this.artifactList) {
            if (!id.equals(artifact.getId())) continue;
            foundArtifact = artifact;
            break;
        }
        return foundArtifact;
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return this.artifactList;
    }

    @Override
    public void addArtifact(Artifact artifact) {
        this.artifactList.add(artifact);
    }

    @Override
    public void removeArtifact(String artifactId) {
        Artifact artifact = this.getArtifact(artifactId);
        if (artifact != null) {
            this.artifactList.remove(artifact);
        }
    }

    public List<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List<EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public <FlowElementType extends FlowElement> FlowElementType findFlowElementsOfTypeAndId(Class<FlowElementType> type, String id, boolean goIntoSubprocesses) {
        ArrayList<SubProcess> processes = new ArrayList<SubProcess>();
        for (FlowElement flowElement : this.getFlowElements()) {
            if (type.isInstance(flowElement) && flowElement.getId().equals(id)) {
                return (FlowElementType)flowElement;
            }
            if (!goIntoSubprocesses || !(flowElement instanceof SubProcess)) continue;
            processes.add((SubProcess)flowElement);
        }
        if (goIntoSubprocesses && processes.size() > 0) {
            for (SubProcess process : processes) {
                for (FlowElement flowElement : process.getFlowElements()) {
                    if (!type.isInstance(flowElement) || !flowElement.getId().equals(id)) continue;
                    return (FlowElementType)flowElement;
                }
            }
        }
        return null;
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsOfType(Class<FlowElementType> type) {
        return this.findFlowElementsOfType(type, true);
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsOfType(Class<FlowElementType> type, boolean goIntoSubprocesses) {
        ArrayList<FlowElement> foundFlowElements = new ArrayList<FlowElement>();
        for (FlowElement flowElement : this.getFlowElements()) {
            if (type.isInstance(flowElement)) {
                foundFlowElements.add(flowElement);
            }
            if (!(flowElement instanceof SubProcess) || !goIntoSubprocesses) continue;
            foundFlowElements.addAll(this.findFlowElementsInSubProcessOfType((SubProcess)flowElement, type, goIntoSubprocesses));
        }
        return foundFlowElements;
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsInSubProcessOfType(SubProcess subProcess, Class<FlowElementType> type) {
        return this.findFlowElementsInSubProcessOfType(subProcess, type, true);
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsInSubProcessOfType(SubProcess subProcess, Class<FlowElementType> type, boolean goIntoSubprocesses) {
        ArrayList<FlowElement> foundFlowElements = new ArrayList<FlowElement>();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (type.isInstance(flowElement)) {
                foundFlowElements.add(flowElement);
            }
            if (!(flowElement instanceof SubProcess) || !goIntoSubprocesses) continue;
            foundFlowElements.addAll(this.findFlowElementsInSubProcessOfType((SubProcess)flowElement, type, goIntoSubprocesses));
        }
        return foundFlowElements;
    }

    public FlowElementsContainer findParent(FlowElement childElement) {
        return this.findParent(childElement, this);
    }

    public FlowElementsContainer findParent(FlowElement childElement, FlowElementsContainer flowElementsContainer) {
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            FlowElementsContainer result;
            if (childElement.getId() != null && childElement.getId().equals(flowElement.getId())) {
                return flowElementsContainer;
            }
            if (!(flowElement instanceof FlowElementsContainer) || (result = this.findParent(childElement, (FlowElementsContainer)((Object)flowElement))) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Process clone() {
        Process clone = new Process();
        this.cloneBasicProperties(clone, this);
        this.cloneflowElementsProperties(clone, this);
        return clone;
    }

    public void cloneBasicProperties(Process clone, Process process) {
        clone.setId(process.getId());
        clone.setName((ILocaleString)new LocaleString(process.getName()));
        clone.setNumber(process.getNumber());
        clone.setExecutable(process.isExecutable());
        clone.setDocumentation((ILocaleString)new LocaleString(process.getDocumentation()));
        clone.setSimpleName(process.getSimpleName());
        clone.setEntraBillName(process.getEntraBillName());
        clone.setEntraBill(process.getEntraBill());
        clone.setEntraBillId(process.getEntraBillId());
        clone.setOrgUnitId(process.getOrgUnitId());
        clone.setResourceId(process.getResourceId());
        clone.setVersion(process.getVersion());
        clone.setNextAssignee(process.isSetNextAssigneeValue());
        clone.setProcessMode(process.getProcessMode());
        clone.setProcessType(process.getProcessType());
        clone.setTriggerMode(process.getTriggerMode());
        clone.setStartType(process.getStartType());
        clone.setStartupcondrule(process.getStartupcondrule());
        clone.setFlowRecordFormatter(process.getFlowRecordFormatter());
        clone.setAutoAuditWhenSamePerson(process.getAutoAuditWhenSamePerson());
        clone.setBusinessId(process.getBusinessId());
        clone.setSubProcess(process.isSubProcess());
        if (this.getIoSpecification() != null) {
            clone.setIoSpecification(process.getIoSpecification().clone());
        }
        if (this.getInitialFlowElement() != null && process.getInitialFlowElement() != null) {
            clone.setInitialFlowElement(process.getInitialFlowElement().clone());
        }
        if (this.getStartItems() != null && !this.getStartItems().isEmpty()) {
            ArrayList<StartItem> items = new ArrayList<StartItem>(this.getStartItems().size());
            for (StartItem startItem : this.getStartItems()) {
                items.add(startItem.clone());
            }
            clone.setStartItems(items);
        }
        if (this.getEvtStartItems() != null && !this.getEvtStartItems().isEmpty()) {
            ArrayList<EventStartItem> eventItems = new ArrayList<EventStartItem>(this.getEvtStartItems().size());
            for (EventStartItem eventStartItem : this.getEvtStartItems()) {
                eventItems.add(eventStartItem);
            }
            clone.setEvtStartItems(eventItems);
        }
        ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
        if (this.getExecutionListeners() != null && !this.getExecutionListeners().isEmpty()) {
            for (ActivitiListener activitiListener : this.getExecutionListeners()) {
                executionListeners.add(activitiListener.clone());
            }
        }
        clone.setExecutionListeners(executionListeners);
        ArrayList<EventListener> eventListeners = new ArrayList<EventListener>();
        if (this.getEventListeners() != null && !process.getEventListeners().isEmpty()) {
            for (EventListener eventListener : process.getEventListeners()) {
                eventListeners.add(eventListener.clone());
            }
        }
        clone.setEventListeners(eventListeners);
        ArrayList<Lane> arrayList = new ArrayList<Lane>();
        if (process.getLanes() != null && !process.getLanes().isEmpty()) {
            for (Lane lane : process.getLanes()) {
                arrayList.add(lane.clone());
            }
        }
        clone.setLanes(arrayList);
        ArrayList<Variable> arrayList2 = new ArrayList<Variable>();
        if (this.getVariables() != null && !process.getVariables().isEmpty()) {
            for (Variable variable : process.getVariables()) {
                arrayList2.add(variable.clone());
            }
        }
        clone.setVariables(arrayList2);
        ArrayList<Macro> arrayList3 = new ArrayList<Macro>();
        if (this.getMacros() != null && !process.getMacros().isEmpty()) {
            for (Macro macro : process.getMacros()) {
                arrayList3.add(macro.clone());
            }
        }
        clone.setMacros(arrayList3);
        ArrayList<Artifact> arrayList4 = new ArrayList<Artifact>();
        if (this.getArtifactList() != null && !process.getArtifactList().isEmpty()) {
            for (Artifact artifact : process.getArtifactList()) {
                arrayList4.add(artifact.clone());
            }
        }
        clone.setArtifactList(arrayList4);
        for (ValuedDataObject valuedDataObject : this.getDataObjects()) {
            boolean exists = false;
            for (ValuedDataObject otherObject : process.getDataObjects()) {
                if (!valuedDataObject.getId().equals(otherObject.getId())) continue;
                exists = true;
            }
            if (exists) continue;
            this.removeFlowElement(valuedDataObject.getId());
        }
        ArrayList<ValuedDataObject> arrayList5 = new ArrayList<ValuedDataObject>();
        if (this.getDataObjects() != null && !process.getDataObjects().isEmpty()) {
            for (ValuedDataObject dataObject : process.getDataObjects()) {
                ValuedDataObject cloneObj = dataObject.clone();
                arrayList5.add(cloneObj);
            }
        }
        clone.setDataObjects(arrayList5);
        if (this.getBillExceptionOp() != null && process.getBillExceptionOp().size() > 0) {
            List<BillExceptionOp> list = process.getBillExceptionOp();
            ArrayList<BillExceptionOp> ops = new ArrayList<BillExceptionOp>(list.size());
            for (BillExceptionOp op : list) {
                ops.add(op.clone());
            }
            clone.setBillExceptionOp(ops);
        }
        if (null != this.allowNextPersonSettingModel) {
            clone.setAllowNextPersonSettingModel(this.allowNextPersonSettingModel.clone());
        }
        if (this.getAfterAudit() != null) {
            clone.setAfterAudit(process.getAfterAudit().clone());
        }
    }

    private void cloneflowElementsProperties(Process clone, Process process) {
        ArrayList<FlowElement> flowElementList = new ArrayList<FlowElement>();
        if (this.getFlowElementList() != null && !process.getFlowElementList().isEmpty()) {
            for (FlowElement flowElement : process.getFlowElementList()) {
                flowElementList.add(flowElement.clone());
            }
        }
        clone.setFlowElementList(flowElementList);
        if (process.getFlowElementMap() != null && !process.getFlowElementMap().isEmpty()) {
            LinkedHashMap<String, FlowElement> flowElementMap = new LinkedHashMap<String, FlowElement>(process.getFlowElementMap().size());
            for (String key : process.getFlowElementMap().keySet()) {
                FlowElement value = process.getFlowElementMap().get(key);
                flowElementMap.put(key, value.clone());
            }
            clone.setFlowElementMap(flowElementMap);
        }
        HashMap<String, List<DynamicModelPartial>> dynamicModelPartial = new HashMap<String, List<DynamicModelPartial>>(this.getDynamicModelPartial().size());
        for (String key : this.getDynamicModelPartial().keySet()) {
            List<DynamicModelPartial> srcValues = process.getDynamicModelPartial().get(key);
            ArrayList<DynamicModelPartial> newValues = new ArrayList<DynamicModelPartial>();
            if (srcValues != null && !srcValues.isEmpty()) {
                for (DynamicModelPartial scrValue : srcValues) {
                    newValues.add(scrValue.clone());
                }
            }
            dynamicModelPartial.put(key, newValues);
        }
        clone.setDynamicModelPartial(dynamicModelPartial);
    }

    public List<ValuedDataObject> getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(List<ValuedDataObject> dataObjects) {
        this.dataObjects = dataObjects;
    }

    public FlowElement getInitialFlowElement() {
        return this.initialFlowElement;
    }

    public void setInitialFlowElement(FlowElement initialFlowElement) {
        this.initialFlowElement = initialFlowElement;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getEntraBillName() {
        return this.entraBillName;
    }

    public void setEntraBillName(String entraBillName) {
        this.entraBillName = entraBillName;
    }

    public String getEntraBill() {
        return this.entraBill;
    }

    public void setEntraBill(String entraBill) {
        this.entraBill = entraBill;
    }

    public String getEntraBillId() {
        return this.entraBillId;
    }

    public void setEntraBillId(String entraBillId) {
        this.entraBillId = entraBillId;
    }

    public long getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(long orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public Map<String, List<DynamicModelPartial>> getDynamicModelPartial() {
        return this.dynamicModelPartial;
    }

    public void addDynamicModelPartial(DynamicModelPartial partial) {
        List<DynamicModelPartial> partials = this.dynamicModelPartial.get(partial.getPartial().getPartialType());
        if (partials == null) {
            partials = new ArrayList<DynamicModelPartial>();
        }
        partials.add(partial);
        this.dynamicModelPartial.put(partial.getPartial().getPartialType(), partials);
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    @TransIgnore
    public List<Macro> getMacros() {
        return this.macros;
    }

    public void setMacros(List<Macro> macros) {
        this.macros = macros;
    }

    public List<FlowElement> getFlowElementList() {
        return this.flowElementList;
    }

    public void setFlowElementList(List<FlowElement> flowElementList) {
        this.flowElementList = flowElementList;
    }

    public List<Artifact> getArtifactList() {
        return this.artifactList;
    }

    public void setArtifactList(List<Artifact> artifactList) {
        this.artifactList = artifactList;
    }

    public void setDynamicModelPartial(Map<String, List<DynamicModelPartial>> dynamicModelPartial) {
        this.dynamicModelPartial = dynamicModelPartial;
    }

    public boolean isSetNextAssigneeValue() {
        return this.isSetNextAssignee;
    }

    public void setNextAssignee(boolean setNextAssignee) {
        this.isSetNextAssignee = setNextAssignee;
    }

    public String getProcessMode() {
        return this.processMode;
    }

    public void setProcessMode(String processMode) {
        this.processMode = processMode;
    }

    public String getStartType() {
        return this.startType;
    }

    public void setStartType(String startType) {
        this.startType = startType;
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(String triggerMode) {
        this.triggerMode = triggerMode;
    }

    public ConditionalRuleEntity getStartupcondrule() {
        return this.startupcondrule;
    }

    public void setStartupcondrule(ConditionalRuleEntity startupcondrule) {
        this.startupcondrule = startupcondrule;
    }

    public List<StartItem> getStartItems() {
        return this.startItems;
    }

    public void setStartItems(List<StartItem> startItems) {
        this.startItems = startItems;
    }

    public List<EventStartItem> getEvtStartItems() {
        return this.evtStartItems;
    }

    public void setEvtStartItems(List<EventStartItem> evtStartItems) {
        this.evtStartItems = evtStartItems;
    }

    public String getFlowRecordFormatter() {
        return this.flowRecordFormatter;
    }

    public void setFlowRecordFormatter(String flowRecordFormatter) {
        this.flowRecordFormatter = flowRecordFormatter;
    }

    public Boolean getAutoAuditWhenSamePerson() {
        return this.autoAuditWhenSamePerson;
    }

    public void setAutoAuditWhenSamePerson(Boolean autoAuditWhenSamePerson) {
        this.autoAuditWhenSamePerson = autoAuditWhenSamePerson;
    }

    public Boolean getWithdrawProcInAuditing() {
        return this.withdrawProcInAuditing;
    }

    public void setWithdrawProcInAuditing(Boolean withdrawProcInAuditing) {
        this.withdrawProcInAuditing = withdrawProcInAuditing;
    }

    public List<BillExceptionOp> getBillExceptionOp() {
        return this.billExceptionOp;
    }

    public void setBillExceptionOp(List<BillExceptionOp> billExceptionOp) {
        this.billExceptionOp = billExceptionOp;
    }

    public String getBosVersion() {
        return this.bosVersion;
    }

    public void setBosVersion(String bosVersion) {
        this.bosVersion = bosVersion;
    }

    @TransIgnore
    @JsonIgnore
    public Map<String, List<ActivitiListener>> getNodeListener() {
        return this.nodeListener;
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        this.copyForName(model.getModelNameOld(), model.getModelName());
        this.copyForDocumentation(model.getModelDescriptionOld(), model.getModelDescription());
        this.copyForProcessId(model.getModelKeyOld(), model.getModelKey());
        this.copyForOrgUnitId(model.getModelOrgunitid());
        this.copyForBusinessId(model);
        this.copyForSubprocess(model);
        this.copyForMap(model);
        this.copyStartItems(model);
        this.copyEventStartItems(model);
        super.copyForConditionalRuleEntity(this.getStartupcondrule(), model.getModelKeyOld(), model.getModelKey());
        super.copyForConditionalRuleEntity(this.getCloseCondition(), model.getModelKeyOld(), model.getModelKey());
        this.copyForPersonSetting(model);
        return this;
    }

    private void copyForSubprocess(DuplicateModel model) {
        if (model != null && model.getSubprocess() != null) {
            this.setSubProcess(model.getSubprocess());
        }
    }

    private void copyForPersonSetting(DuplicateModel model) {
        if (this.allowNextPersonSettingModel != null) {
            this.allowNextPersonSettingModel.copy(model);
        }
    }

    private void copyStartItems(DuplicateModel model) {
        if (this.startItems != null && !this.startItems.isEmpty()) {
            for (StartItem item : this.startItems) {
                item.copy(model);
            }
        }
    }

    private void copyEventStartItems(DuplicateModel model) {
        if (this.evtStartItems != null && !this.evtStartItems.isEmpty()) {
            for (EventStartItem item : this.evtStartItems) {
                item.copy(model);
            }
        }
    }

    private void copyForMap(DuplicateModel model) {
        String modelKeyOld = model.getModelKeyOld();
        String modelKey = model.getModelKey();
        this.copyForFlowElementMap(modelKeyOld, modelKey);
        this.copyForDynamicModelPartial(modelKeyOld, modelKey);
        this.copyForNodeListener(modelKeyOld, modelKey);
    }

    private void copyForFlowElementMap(String oldValue, String newValue) {
        Map<String, FlowElement> newMap = BpmnModelUtil.copyForMap(oldValue, newValue, this.getFlowElementMap());
        if (null != newMap && 0 != newMap.size()) {
            this.setFlowElementMap(newMap);
        }
    }

    private void copyForDynamicModelPartial(String oldValue, String newValue) {
        Map<String, List<DynamicModelPartial>> newMap = BpmnModelUtil.copyForMap(oldValue, newValue, this.getDynamicModelPartial());
        if (null != newMap && 0 != newMap.size()) {
            this.setDynamicModelPartial(newMap);
        }
    }

    private void copyForNodeListener(String oldValue, String newValue) {
        Map<String, List<ActivitiListener>> newMap = BpmnModelUtil.copyForMap(oldValue, newValue, this.getNodeListener());
        if (null != newMap && 0 != newMap.size()) {
            this.nodeListener = newMap;
        }
    }

    private void copyForName(ILocaleString oldValue, ILocaleString newValue) {
        ILocaleString processName = this.getProcessName();
        WfUtils.replaceLocaleString(processName, oldValue, newValue);
    }

    private void copyForDocumentation(ILocaleString oldValue, ILocaleString newValue) {
        ILocaleString documentation = this.getProcessDocumentation();
        if (WfUtils.isEmpty(documentation)) {
            this.setDocumentation(newValue);
        } else {
            WfUtils.replaceLocaleString(documentation, oldValue, newValue);
        }
    }

    private void copyForProcessId(String oldValue, String newValue) {
        String id = super.getCopyValueForReplace(this.getId(), oldValue, newValue);
        if (WfUtils.isNotEmpty(id)) {
            this.setId(id);
        }
    }

    private void copyForOrgUnitId(Long newValue) {
        if (WfUtils.isNotEmpty(newValue)) {
            this.setOrgUnitId(newValue);
        }
    }

    private void copyForBusinessId(DuplicateModel model) {
        if (WfUtils.isNotEmpty(model.getModelBusinessId())) {
            this.setBusinessId(model.getModelBusinessId());
        }
    }

    public Map<String, NodeForkJoinModel> getForkJoinModels() {
        if (this.forkJoinModelsInit) {
            return this.forkJoinModels;
        }
        try {
            this.lock.lock();
            if (this.forkJoinModels.isEmpty()) {
                this.buildForkJoinModels();
                this.forkJoinModelsInit = true;
            }
        }
        catch (Exception e) {
            log.info("buildForkJoinModels error:" + WfUtils.getExceptionStacktrace(e));
        }
        finally {
            this.lock.unlock();
        }
        return this.forkJoinModels;
    }

    private void buildForkJoinModels() {
        StartEvent start;
        List<StartEvent> events = this.findFlowElementsOfType(StartEvent.class);
        if (events.isEmpty()) {
            log.debug("no startevent!");
            return;
        }
        StartEvent node = start = events.get(0);
        HashMap<String, String> structureMapForkAndJoin = new HashMap<String, String>();
        this.getForkModelSomeProps(node, this.forkJoinModels, structureMapForkAndJoin);
        HashMap<String, List> structureMapModels = new HashMap<String, List>(this.forkJoinModels.size());
        for (NodeForkJoinModel nodeForkJoinModel : this.forkJoinModels.values()) {
            String structure = nodeForkJoinModel.getForkStructure();
            List list = (List)structureMapModels.get(structure);
            list = list != null ? list : new ArrayList();
            list.add(nodeForkJoinModel);
            structureMapModels.put(structure, list);
        }
        for (Map.Entry entry : structureMapForkAndJoin.entrySet()) {
            String forkAndJoin = (String)structureMapForkAndJoin.get(entry.getKey());
            String[] fj = forkAndJoin.split("\\&");
            String forkNodeId = fj[0];
            String joinNodeId = fj[1];
            FlowNode forkNode = (FlowNode)this.getFlowElement(forkNodeId);
            List<SequenceFlow> outFlows = forkNode.getOutgoingFlows();
            String forkNodeStructure = this.forkJoinModels.get(forkNodeId).getForkStructure();
            for (SequenceFlow s : outFlows) {
                if (s.isDynamic()) continue;
                String forkNodeNextNodeId = s.getTargetFlowElement().getId();
                String nextNodeStructure = forkNodeStructure + "$" + forkNodeNextNodeId;
                List models = (List)structureMapModels.get(nextNodeStructure);
                if (models == null) continue;
                for (NodeForkJoinModel m : models) {
                    String nodeId = m.getNodeId();
                    NodeForkJoinModel model = this.forkJoinModels.get(nodeId);
                    model.setLatestForkNode(forkNodeId);
                    model.setLatestJoinNode(joinNodeId);
                }
            }
        }
    }

    private void getForkModelSomeProps(FlowNode node, Map<String, NodeForkJoinModel> fjModels, Map<String, String> structureMapForkAndJoin) {
        while (node != null && !fjModels.containsKey(node.getId())) {
            NodeForkJoinModel model = new NodeForkJoinModel();
            String nodeId = node.getId();
            model.setNodeId(nodeId);
            List<SequenceFlow> inComFlows = node.getIncomingFlows();
            ArrayList<SequenceFlow> inFlows = new ArrayList<SequenceFlow>();
            List<SequenceFlow> outFlows = node.getOutgoingFlows();
            if (node instanceof StartEvent) {
                model.setForkStructure("#M");
            } else {
                NodeForkJoinModel preNodeModel = null;
                for (SequenceFlow s : inComFlows) {
                    FlowNode sourceNode;
                    if (s.isDynamic()) continue;
                    inFlows.add(s);
                    if (node.getJoin() != null && node.getJoin().booleanValue() && "enterwhenallarrive".equals(node.getInSet()) && inComFlows.size() > 1 && (sourceNode = (FlowNode)s.getSourceFlowElement()).getFork() != null && sourceNode.getFork().booleanValue() && "leavewhenallmeet".equals(sourceNode.getOutSet()) || preNodeModel != null) continue;
                    preNodeModel = this.forkJoinModels.get(s.getSourceFlowElement().getId());
                }
                if (preNodeModel == null) {
                    throw new KDException(WFErrorCode.modelSaveError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u8ba1\u6709\u8bef\uff0c\u672a\u80fd\u8ba1\u7b97\u51faNodeForkJoinModel\uff0cnodeID\uff1a%1$s\u3002", (String)"Process_1", (String)"bos-wf-engine", (Object[])new Object[0]), nodeId)});
                }
                String forkStructure = preNodeModel.getForkStructure();
                if (node.getJoin() != null && node.getJoin().booleanValue() && "enterwhenallarrive".equals(node.getInSet()) && inFlows.size() > 1) {
                    model.setJoinNode(true);
                    String preNodeForkStructure = forkStructure;
                    String[] levelStructure = forkStructure.split("\\$");
                    int level = levelStructure.length;
                    String forkNextNodeId = levelStructure[level - 1];
                    FlowNode forkNextNode = (FlowNode)this.getFlowElement(forkNextNodeId);
                    if (forkNextNode == null) {
                        throw new KDException(WFErrorCode.getMainProcessFromBpmnModel(), new Object[]{String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u8ba1\u6709\u8bef\uff0c\u672a\u80fd\u8ba1\u7b97\u51faforkNextNode\uff0cnodeID\uff1a%1$s\u3002", (String)"Process_6", (String)"bos-wf-engine", (Object[])new Object[0]), nodeId)});
                    }
                    List<SequenceFlow> incomingFlows = forkNextNode.getIncomingFlows();
                    ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>(incomingFlows.size());
                    for (SequenceFlow s : incomingFlows) {
                        if (s.isDynamic()) continue;
                        flows.add(s);
                    }
                    String pairForkNodeId = "";
                    if (flows.size() != 1) {
                        if (forkNextNode.getJoin() != null && forkNextNode.getJoin().booleanValue() && "enterwhenallarrive".equals(forkNextNode.getInSet()) && inFlows.size() > 1) {
                            throw new KDException(WFErrorCode.modelSaveError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u8ba1\u6709\u8bef\uff0c\u5206\u652f\u540e\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u662f\u6c47\u805a\u8282\u70b9\uff0c\u8282\u70b9ID\uff1a%1$s\u3002", (String)"Process_2", (String)"bos-wf-engine", (Object[])new Object[0]), forkNextNodeId)});
                        }
                        for (SequenceFlow s : flows) {
                            FlowElement t = this.getFlowElement(s.getSourceFlowElement().getId());
                            if (!(t instanceof FlowNode) || ((FlowNode)t).getFork() == null || !((FlowNode)t).getFork().booleanValue() || !"leavewhenallmeet".equals(((FlowNode)t).getOutSet())) continue;
                            pairForkNodeId = t.getId();
                            break;
                        }
                        if (WfUtils.isEmpty(pairForkNodeId)) {
                            throw new KDException(WFErrorCode.modelSaveError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5206\u652f\u201c%1$s\u201d\u540e\u7b2c\u4e00\u4e2a\u8282\u70b9\u201c%2$s\u201d\u8ba1\u7b97\u5206\u652f\u6a21\u578b\u9519\u8bef\u3002", (String)"Process_3", (String)"bos-wf-engine", (Object[])new Object[0]), node.getId(), forkNextNodeId)});
                        }
                    } else {
                        pairForkNodeId = this.getFlowElement(((SequenceFlow)flows.get(0)).getSourceFlowElement().getId()).getId();
                    }
                    model.setPairForkNodeId(pairForkNodeId);
                    NodeForkJoinModel pairForkModel = fjModels.get(pairForkNodeId);
                    pairForkModel.setPairJoinNodeId(nodeId);
                    forkStructure = forkStructure.substring(0, forkStructure.lastIndexOf("$"));
                    structureMapForkAndJoin.put(preNodeForkStructure, pairForkNodeId + "&" + nodeId);
                }
                if (preNodeModel.isForkNode()) {
                    forkStructure = forkStructure + "$" + nodeId;
                }
                model.setForkStructure(forkStructure);
                ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>(outFlows.size());
                for (SequenceFlow s : outFlows) {
                    if (s.isDynamic()) continue;
                    flows.add(s);
                }
                if (node.getFork() != null && node.getFork().booleanValue() && ("leavewhenallmeet".equals(node.getOutSet()) || "leavewhenfristone".equals(node.getOutSet())) && flows.size() > 1) {
                    model.setForkNode(true);
                }
            }
            fjModels.put(model.getNodeId(), model);
            for (SequenceFlow out : outFlows) {
                if (out.isDynamic()) continue;
                node = (FlowNode)out.getTargetFlowElement();
                this.getForkModelSomeProps(node, fjModels, structureMapForkAndJoin);
            }
        }
    }

    public void setForkJoinModels(Map<String, NodeForkJoinModel> forkJoinModels) {
        this.forkJoinModels = forkJoinModels;
    }

    public Map<String, List<FlowNode>> getBoundaryNodes() {
        if (this.boundaryNodes.isEmpty()) {
            this.buildBoundaryNodes();
        }
        return this.boundaryNodes;
    }

    private void buildBoundaryNodes() {
        this.buildNonBoundaryNodes();
        List<FlowElement> elemnets = this.getFlowElementList();
        for (FlowElement element : elemnets) {
            if (!(element instanceof BoundaryEvent)) continue;
            BoundaryEvent boundary = (BoundaryEvent)element;
            String boundaryId = boundary.getId();
            ArrayList<FlowNode> nodes = this.boundaryNodes.get(boundaryId) == null ? new ArrayList<FlowNode>() : this.boundaryNodes.get(boundaryId);
            this.getBoundaryBrachNodes(boundary, nodes);
            this.boundaryNodes.put(boundaryId, nodes);
        }
    }

    private void getBoundaryBrachNodes(FlowNode boundary, List<FlowNode> nodes) {
        List<SequenceFlow> outFlows = boundary.getOutgoingFlows();
        for (SequenceFlow s : outFlows) {
            FlowNode targetNode;
            if (s.isDynamic() || this.nonBoundaryNodes.contains((targetNode = (FlowNode)s.getTargetFlowElement()).getId()) || nodes.contains(targetNode)) continue;
            nodes.add(targetNode);
            this.getBoundaryBrachNodes(targetNode, nodes);
        }
    }

    private Set<String> buildNonBoundaryNodes() {
        if (this.nonBoundaryNodes.isEmpty()) {
            StartEvent start;
            List<StartEvent> events = this.findFlowElementsOfType(StartEvent.class);
            if (events.isEmpty()) {
                log.debug("no startevent!");
                return this.nonBoundaryNodes;
            }
            StartEvent node = start = events.get(0);
            this.getNonBoundaryBrachNodes(node);
        }
        return this.nonBoundaryNodes;
    }

    private void getNonBoundaryBrachNodes(FlowNode node) {
        while (node != null && !this.nonBoundaryNodes.contains(node.getId())) {
            this.nonBoundaryNodes.add(node.getId());
            List<SequenceFlow> outFlows = node.getOutgoingFlows();
            for (SequenceFlow out : outFlows) {
                if (out.isDynamic()) continue;
                node = (FlowNode)out.getTargetFlowElement();
                this.getNonBoundaryBrachNodes(node);
            }
        }
    }

    public void setBoundaryNodes(Map<String, List<FlowNode>> boundaryNodes) {
        this.boundaryNodes = boundaryNodes;
    }

    public Set<String> getNonBoundaryNodes() {
        if (this.nonBoundaryNodes.isEmpty()) {
            this.buildNonBoundaryNodes();
        }
        return this.nonBoundaryNodes;
    }

    public void setNonBoundaryNodes(Set<String> nonBoundaryNodes) {
        this.nonBoundaryNodes = nonBoundaryNodes;
    }

    public String getBoundaryEventId(String nodeId) {
        this.getBoundaryNodes();
        String boundaryNodeId = null;
        for (Map.Entry<String, List<FlowNode>> entry : this.boundaryNodes.entrySet()) {
            String key = entry.getKey();
            for (FlowNode fn : this.boundaryNodes.get(key)) {
                if (!fn.getId().equals(nodeId)) continue;
                boundaryNodeId = key;
                break;
            }
            if (!WfUtils.isNotEmpty(boundaryNodeId)) continue;
            break;
        }
        return boundaryNodeId;
    }

    public Map<String, Set<String>> getNodeAffectJoinNodeComeFlow() {
        if (this.nodeAffectJoinNodeComeFlow.isEmpty()) {
            this.bulidNodeAffectJoinNodeComeFlow();
        }
        return this.nodeAffectJoinNodeComeFlow;
    }

    public void bulidNodeAffectJoinNodeComeFlow() {
        this.getForkJoinModels();
        HashMap<String, HashSet<String>> joinNodeComeFlowAffectNode = new HashMap<String, HashSet<String>>();
        for (Map.Entry<String, NodeForkJoinModel> entry : this.forkJoinModels.entrySet()) {
            NodeForkJoinModel m = this.forkJoinModels.get(entry.getKey());
            if (!m.isJoinNode()) continue;
            String forkNodeId = m.getPairForkNodeId();
            FlowNode joinNode = (FlowNode)this.getFlowElement(m.getNodeId());
            List<SequenceFlow> inFlows = joinNode.getIncomingFlows();
            for (SequenceFlow sequenceFlow : inFlows) {
                if (sequenceFlow.isDynamic()) continue;
                HashSet<String> affectNodes = new HashSet<String>();
                FlowNode pre = (FlowNode)sequenceFlow.getSourceFlowElement();
                this.getPreNodesForAffectFlow(forkNodeId, pre, affectNodes);
                joinNodeComeFlowAffectNode.put(sequenceFlow.getId(), affectNodes);
            }
        }
        HashMap joinInFlowsMap = new HashMap();
        for (Map.Entry<String, NodeForkJoinModel> entry : this.forkJoinModels.entrySet()) {
            NodeForkJoinModel m = this.forkJoinModels.get(entry.getKey());
            if (!WfUtils.isNotEmpty(m.getLatestForkNode()) || !WfUtils.isNotEmpty(m.getLatestJoinNode())) continue;
            String nodeId = m.getNodeId();
            FlowNode joinNode = (FlowNode)this.getFlowElement(m.getLatestJoinNode());
            HashSet<String> joinInFlows = (HashSet<String>)joinInFlowsMap.get(joinNode.getId());
            if (joinInFlows == null) {
                joinInFlows = new HashSet<String>(joinNode.getIncomingFlows().size());
                for (SequenceFlow f : joinNode.getIncomingFlows()) {
                    joinInFlows.add(f.getId());
                }
                joinInFlowsMap.put(joinNode.getId(), joinInFlows);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry nodeEntry : joinNodeComeFlowAffectNode.entrySet()) {
                String joinNodeIncomeFlow = (String)nodeEntry.getKey();
                if (!joinInFlows.contains(joinNodeIncomeFlow) || !((Set)joinNodeComeFlowAffectNode.get(joinNodeIncomeFlow)).contains(nodeId)) continue;
                hashSet.add(joinNodeIncomeFlow);
            }
            this.nodeAffectJoinNodeComeFlow.put(nodeId, hashSet);
        }
    }

    private void getPreNodesForAffectFlow(String forkNodeId, FlowNode pre, Set<String> affectNodes) {
        String preId;
        while (!(pre == null || pre instanceof StartEvent || affectNodes.contains(preId = pre.getId()) || forkNodeId.equals(preId))) {
            affectNodes.add(preId);
            List<SequenceFlow> inComes = pre.getIncomingFlows();
            for (SequenceFlow i : inComes) {
                if (i.isDynamic()) continue;
                FlowNode preNode = (FlowNode)i.getSourceFlowElement();
                this.getPreNodesForAffectFlow(forkNodeId, preNode, affectNodes);
            }
        }
    }

    public AllowNextPersonSettingModel getAllowNextPersonSettingModel() {
        return this.allowNextPersonSettingModel;
    }

    public void setAllowNextPersonSettingModel(AllowNextPersonSettingModel allowNextPersonSettingModel) {
        this.allowNextPersonSettingModel = allowNextPersonSettingModel;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public boolean isSubProcess() {
        return this.subProcess;
    }

    public void setSubProcess(boolean subProcess) {
        this.subProcess = subProcess;
    }

    public ConditionalRuleEntity getCloseCondition() {
        return this.closeCondition;
    }

    public void setCloseCondition(ConditionalRuleEntity closeCondition) {
        this.closeCondition = closeCondition;
    }

    public void addBaseDataRecord(BaseDataRecord baseDataRecord) {
        String baseDataType = baseDataRecord.getBaseData().getBaseDataType();
        List<BaseDataRecord> baseDataRecords = this.baseData.get(baseDataType);
        if (baseDataRecords == null) {
            baseDataRecords = new ArrayList<BaseDataRecord>();
        }
        baseDataRecords.add(baseDataRecord);
        this.baseData.put(baseDataType, baseDataRecords);
    }

    public Map<String, List<BaseDataRecord>> getBaseData() {
        return this.baseData;
    }

    public LinkedHashMap<String, BoundaryEvent> getCompensateBoundaryAttachedNodes() {
        if (this.compensateBoundaryAttachedNodes.isEmpty()) {
            this.buildCompensateInfos();
        }
        return this.compensateBoundaryAttachedNodes;
    }

    private void buildCompensateInfos() {
        List<BoundaryEvent> boundaryEvents = this.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
            String continueNodeId = boundaryEvent.getAttachedToRefId();
            this.compensateBoundaryAttachedNodes.put(continueNodeId, boundaryEvent);
            if (boundaryEvent.getOutgoingFlows().isEmpty()) continue;
            FlowElement compensateNode = boundaryEvent.getOutgoingFlows().get(0).getTargetFlowElement();
            this.compensateNodeAttachedNodes.put(continueNodeId, (FlowNode)compensateNode);
        }
    }

    public void setCompensateBoundaryAttachedNodes(LinkedHashMap<String, BoundaryEvent> compensateBoundaryAttachedNodes) {
        this.compensateBoundaryAttachedNodes = compensateBoundaryAttachedNodes;
    }

    public LinkedHashMap<String, FlowNode> getCompensateNodeAttachedNodes() {
        if (this.compensateNodeAttachedNodes.isEmpty()) {
            this.buildCompensateInfos();
        }
        return this.compensateNodeAttachedNodes;
    }

    public void setCompensateNodeAttachedNodes(LinkedHashMap<String, FlowNode> compensateNodeAttachedNodes) {
        this.compensateNodeAttachedNodes = compensateNodeAttachedNodes;
    }

    public AfterAuditModel getAfterAudit() {
        return this.afterAudit;
    }

    public void setAfterAudit(AfterAuditModel afterAudit) {
        this.afterAudit = afterAudit;
    }
}

