/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.LinkControlIntensity;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.TargetBillsFilterCondition;

public class SequenceFlow
extends FlowElement {
    public static final String AGGREGATIONTYPE_EXECUTIONAGGREGATE = "executionAggregate";
    public static final String AGGREGATIONTYPE_PLUGINAGGREGATE = "pluginAggregate";
    protected ConditionalRuleEntity conditionalRule;
    protected BillRelationshipModel billRelationshipModel;
    protected TargetBillsFilterCondition targetBillsFilterCondition;
    protected String sourceRef;
    protected String targetRef;
    protected String skipExpression;
    protected String aggregationType;
    protected String aggregationPlugin;
    protected boolean enableAggregation;
    protected boolean enableGenerateTarget;
    protected boolean enableTargetBillsFilter;
    protected LinkControlIntensity controlIntensity;
    @JsonIgnore
    protected FlowElement sourceFlowElement;
    @JsonIgnore
    protected FlowElement targetFlowElement;
    protected List<Integer> waypoints = new ArrayList<Integer>();
    protected String relationType;

    public SequenceFlow() {
    }

    public SequenceFlow(String sourceRef, String targetRef) {
        this.sourceRef = sourceRef;
        this.targetRef = targetRef;
    }

    public String getConditionExpression() {
        if (this.conditionalRule != null) {
            return this.conditionalRule.getExpression();
        }
        return null;
    }

    public void setConditionExpression(String conditionExpression) {
        if (conditionExpression != null && this.conditionalRule != null) {
            this.conditionalRule.setExpression(conditionExpression);
        }
    }

    public String getSourceRef() {
        return this.sourceRef;
    }

    public void setSourceRef(String sourceRef) {
        this.sourceRef = sourceRef;
    }

    public String getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(String targetRef) {
        this.targetRef = targetRef;
    }

    public String getSkipExpression() {
        return this.skipExpression;
    }

    public void setSkipExpression(String skipExpression) {
        this.skipExpression = skipExpression;
    }

    public FlowElement getSourceFlowElement() {
        return this.sourceFlowElement;
    }

    public void setSourceFlowElement(FlowElement sourceFlowElement) {
        this.sourceFlowElement = sourceFlowElement;
    }

    public FlowElement getTargetFlowElement() {
        return this.targetFlowElement;
    }

    public void setTargetFlowElement(FlowElement targetFlowElement) {
        this.targetFlowElement = targetFlowElement;
    }

    public List<Integer> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<Integer> waypoints) {
        this.waypoints = waypoints;
    }

    public ConditionalRuleEntity getConditionalRule() {
        return this.conditionalRule;
    }

    public void setConditionalRule(ConditionalRuleEntity conditionalRule) {
        this.conditionalRule = conditionalRule;
    }

    public String toString() {
        return this.sourceRef + " --> " + this.targetRef;
    }

    public BillRelationshipModel getBillRelationshipModel() {
        return this.billRelationshipModel;
    }

    public void setBillRelationshipModel(BillRelationshipModel billRelationshipModel) {
        this.billRelationshipModel = billRelationshipModel;
    }

    public TargetBillsFilterCondition getTargetBillsFilterCondition() {
        return this.targetBillsFilterCondition;
    }

    public void setTargetBillsFilterCondition(TargetBillsFilterCondition targetBillsFilterCondition) {
        this.targetBillsFilterCondition = targetBillsFilterCondition;
    }

    public String getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
    }

    public LinkControlIntensity getControlIntensity() {
        return this.controlIntensity;
    }

    public void setControlIntensity(LinkControlIntensity controlIntensity) {
        this.controlIntensity = controlIntensity;
    }

    @Override
    public SequenceFlow clone() {
        SequenceFlow clone = new SequenceFlow();
        clone.setValues(this);
        return clone;
    }

    public void setValues(SequenceFlow otherFlow) {
        super.setValues(otherFlow);
        this.setSourceRef(otherFlow.getSourceRef());
        this.setTargetRef(otherFlow.getTargetRef());
        this.setSkipExpression(otherFlow.getSkipExpression());
        this.setRelationType(otherFlow.getRelationType());
        this.setAggregationType(otherFlow.getAggregationType());
        this.setAggregationPlugin(otherFlow.getAggregationPlugin());
        this.setEnableAggregation(otherFlow.isEnableAggregation());
        this.setEnableTargetBillsFilter(otherFlow.isEnableTargetBillsFilter());
        this.setEnableGenerateTarget(otherFlow.isEnableGenerateTarget());
        if (otherFlow.getControlIntensity() != null) {
            this.setControlIntensity(otherFlow.getControlIntensity().clone());
        }
        if (otherFlow.getConditionalRule() != null) {
            this.setConditionalRule((ConditionalRuleEntity)otherFlow.getConditionalRule().clone());
        }
        if (otherFlow.getSourceFlowElement() != null) {
            this.setSourceFlowElement(otherFlow.getSourceFlowElement());
        }
        if (otherFlow.getTargetFlowElement() != null) {
            this.setTargetFlowElement(otherFlow.getTargetFlowElement());
        }
        if (otherFlow.getBillRelationshipModel() != null) {
            this.setBillRelationshipModel(otherFlow.getBillRelationshipModel().clone());
        }
        if (otherFlow.getTargetBillsFilterCondition() != null) {
            this.setTargetBillsFilterCondition(otherFlow.getTargetBillsFilterCondition().clone());
        }
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        String modelKeyOld = model.getModelKeyOld();
        String modelKey = model.getModelKey();
        super.copyForConditionalRuleEntity(this.getConditionalRule(), modelKeyOld, modelKey);
        this.copyForRef(modelKeyOld, modelKey);
        if (this.billRelationshipModel != null) {
            this.billRelationshipModel.copy(model);
        }
        return super.copy(model);
    }

    private void copyForRef(String modelKeyOld, String modelKey) {
        this.copyForRefSource(modelKeyOld, modelKey);
        this.copyForRefTarget(modelKeyOld, modelKey);
    }

    private void copyForRefSource(String oldValue, String newValue) {
        String sourceRef = super.getCopyValueForReplace(this.getSourceRef(), oldValue, newValue);
        if (WfUtils.isNotEmpty(sourceRef)) {
            this.setSourceRef(sourceRef);
        }
    }

    private void copyForRefTarget(String oldValue, String newValue) {
        String targetRef = super.getCopyValueForReplace(this.getTargetRef(), oldValue, newValue);
        if (WfUtils.isNotEmpty(targetRef)) {
            this.setTargetRef(targetRef);
        }
    }

    public void setOrignalExpression(String originalExpression) {
        if (WfUtils.isNotEmpty(originalExpression)) {
            this.addAttribute("originalExpression", originalExpression);
        }
    }

    public String getOrignalExpression() {
        return this.getAttributeValue("originalExpression");
    }

    public String getRelationType() {
        return this.relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getAggregationPlugin() {
        return this.aggregationPlugin;
    }

    public void setAggregationPlugin(String aggregationPlugin) {
        this.aggregationPlugin = aggregationPlugin;
    }

    public boolean isEnableAggregation() {
        return this.enableAggregation;
    }

    public void setEnableAggregation(boolean enableAggregation) {
        this.enableAggregation = enableAggregation;
    }

    public boolean isEnableTargetBillsFilter() {
        return this.enableTargetBillsFilter;
    }

    public void setEnableTargetBillsFilter(boolean enableTargetBillsFilter) {
        this.enableTargetBillsFilter = enableTargetBillsFilter;
    }

    public boolean isEnableGenerateTarget() {
        return this.enableGenerateTarget;
    }

    public void setEnableGenerateTarget(boolean enableGenerateTarget) {
        this.enableGenerateTarget = enableGenerateTarget;
    }
}

