/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class StartItem
extends BaseElement {
    private static final long serialVersionUID = -7692491477776574741L;
    private String nodeid;
    private String entitynumber;
    private String entityname;
    private ConditionalRuleEntity condition;
    private boolean allowstart;
    private String batchnumber;
    private String batchnumname;
    private String operation;

    public String getNodeid() {
        return this.nodeid;
    }

    public void setNodeid(String nodeid) {
        this.nodeid = nodeid;
    }

    public String getEntitynumber() {
        return this.entitynumber;
    }

    public void setEntitynumber(String entitynumber) {
        this.entitynumber = entitynumber;
    }

    public String getEntityname() {
        return this.entityname;
    }

    public void setEntityname(String entityname) {
        this.entityname = entityname;
    }

    public ConditionalRuleEntity getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionalRuleEntity condition) {
        this.condition = condition;
    }

    public boolean isAllowstart() {
        return this.allowstart;
    }

    public void setAllowstart(boolean allowstart) {
        this.allowstart = allowstart;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getBatchnumber() {
        return this.batchnumber;
    }

    public void setBatchnumber(String batchnumber) {
        this.batchnumber = batchnumber;
    }

    public String getBatchnumname() {
        return this.batchnumname;
    }

    public void setBatchnumname(String batchnumname) {
        this.batchnumname = batchnumname;
    }

    public String getOperationNumbers() {
        if (WfUtils.isNotEmpty(this.operation)) {
            JSONArray opers = JSON.parseArray((String)this.operation);
            StringBuilder sb = new StringBuilder();
            int size = opers.size();
            for (int i = 0; i < size; ++i) {
                JSONObject oper = opers.getJSONObject(i);
                sb.append(oper.getString("number"));
                if (i >= size - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public StartItem clone() {
        StartItem item = new StartItem();
        item.setEntitynumber(this.getEntitynumber());
        item.setEntityname(this.getEntityname());
        if (this.getCondition() != null) {
            item.setCondition((ConditionalRuleEntity)this.getCondition().clone());
        }
        item.setAllowstart(this.isAllowstart());
        item.setOperation(this.getOperation());
        item.setBatchnumber(this.getBatchnumber());
        item.setBatchnumname(this.getBatchnumname());
        return item;
    }

    @Override
    public StartItem copy(DuplicateModel model) {
        String oldValue = model.getModelKeyOld();
        String newValue = model.getModelKey();
        String nodeId = this.getNodeid();
        if (WfUtils.isNotEmpty(nodeId)) {
            this.setNodeid(BpmnModelUtil.getCopyValueForReplace(nodeId, oldValue, newValue));
        }
        return this;
    }
}

