/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.engine.WfUtils;

public abstract class Task
extends Activity {
    protected List<Variable> variables = new ArrayList<Variable>();

    public void setValues(Task otherElement) {
        super.setValues(otherElement);
        this.variables = new ArrayList<Variable>();
        if (otherElement.getVariables() != null && !otherElement.getVariables().isEmpty()) {
            for (Variable variable : otherElement.getVariables()) {
                this.variables.add(variable.clone());
            }
        }
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.variables.clear();
        for (Object obj : variables) {
            if (obj instanceof Variable) {
                Variable variable = (Variable)obj;
                if (WfUtils.isEmpty(variable.getId())) {
                    variable.setId(BpmnDiffUtil.getListElementId("variables"));
                }
                this.variables.add(variable);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            this.variables.add(this.convertMapToVariable((Map)obj));
        }
    }

    private Variable convertMapToVariable(Map<String, Object> map) {
        Variable variable = new Variable();
        if (WfUtils.isEmpty(variable.getId())) {
            variable.setId(BpmnDiffUtil.getListElementId("variables"));
        }
        variable.setName((String)map.get("name"));
        variable.setNumber((String)map.get("number"));
        variable.setType((String)map.get("type"));
        variable.setDefaultValue(map.get("defaultValue"));
        variable.setDescription((String)map.get("description"));
        Object builtIn = map.get("builtIn");
        variable.setBuiltIn(builtIn != null ? Boolean.parseBoolean(String.valueOf(builtIn)) : false);
        return variable;
    }

    protected void copyForMessage(List<MessageSendModel> msgs, String oldValue, String newValue) {
        if (WfUtils.isNotEmptyForCollection(msgs)) {
            DuplicateModel model = new DuplicateModel();
            model.setModelKeyOld(oldValue);
            model.setModelKey(newValue);
            for (MessageSendModel msg : msgs) {
                msg.copy(model);
            }
        }
    }
}

