/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;

public class TimingModel
extends BaseElement {
    private static final long serialVersionUID = -3572413545371011564L;
    private String type;
    private String duration;
    private String unit;
    private ConditionalRuleEntity condition;
    private String event;
    private String eventName;
    private String eventType;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public ConditionalRuleEntity getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionalRuleEntity condition) {
        this.condition = condition;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public int getCalendarUnit() {
        if (WfUtils.isNotEmpty(this.unit)) {
            switch (this.unit) {
                case "minute": {
                    return 12;
                }
                case "hour": {
                    return 10;
                }
                case "day": {
                    return 6;
                }
            }
        }
        return 10;
    }

    @Override
    public TimingModel clone() {
        TimingModel model = new TimingModel();
        model.setType(this.getType());
        model.setDuration(this.getDuration());
        model.setUnit(this.getUnit());
        model.setEvent(this.getEvent());
        model.setEventName(this.getEventName());
        model.setEventType(this.getEventType());
        if (this.getCondition() != null) {
            model.setCondition((ConditionalRuleEntity)this.getCondition().clone());
        }
        return model;
    }

    public String toString() {
        String rule;
        String string = rule = this.condition != null ? this.condition.getExpression() : "";
        if ("delay".equals(this.type) || "timing".equals(this.type)) {
            return String.format("{Type: %s, Duration: %s, Unit: %s, Condition: %s }", this.type, this.duration, this.unit, rule);
        }
        return String.format("{Type: %s, Event: %s, EventName: %s }", this.type, this.event, this.eventName);
    }
}

