/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model;

import java.util.List;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.IMessageSupport;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.TimingModel;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WaitTask
extends EventSupportTask
implements IMessageSupport,
IEntitySupport {
    private static final long serialVersionUID = -8954595768832310960L;
    private String entityNumber;
    private TimingModel timingModel;
    private Long eventId;
    private List<MessageSendModel> inMsg;
    private List<MessageSendModel> outMsg;

    public TimingModel getTimingModel() {
        return this.timingModel;
    }

    public void setTimingModel(TimingModel timingModel) {
        this.timingModel = timingModel;
    }

    @Override
    public List<MessageSendModel> getInMsg() {
        return this.inMsg;
    }

    @Override
    public void setInMsg(List<MessageSendModel> inMsg) {
        this.inMsg = inMsg;
    }

    @Override
    public List<MessageSendModel> getOutMsg() {
        return this.outMsg;
    }

    @Override
    public void setOutMsg(List<MessageSendModel> outMsg) {
        this.outMsg = outMsg;
    }

    public Long getEventId() {
        return this.eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    @Override
    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    @Override
    public WaitTask clone() {
        WaitTask task = new WaitTask();
        task.setValues(this);
        return task;
    }

    public void setValues(WaitTask otherElement) {
        super.setValues(otherElement);
        this.setEntityId(otherElement.getEntityId());
        this.setEventId(otherElement.getEventId());
        this.setEntityName(otherElement.getEntityName());
        this.setEntityNumber(otherElement.getEntityNumber());
        if (otherElement.timingModel != null) {
            this.setTimingModel(otherElement.timingModel.clone());
        }
        if (otherElement.inMsg != null && !otherElement.inMsg.isEmpty()) {
            this.setInMsg(BpmnModelUtil.getClonedMessageModel(otherElement.inMsg));
        }
        if (otherElement.outMsg != null && !otherElement.outMsg.isEmpty()) {
            this.setOutMsg(BpmnModelUtil.getClonedMessageModel(otherElement.outMsg));
        }
        this.cloneEventParams(otherElement);
    }

    @Override
    public BaseElement copy(DuplicateModel model) {
        this.copyForTimingModel(model);
        this.copyForMessage(model);
        return super.copy(model);
    }

    private void copyForTimingModel(DuplicateModel model) {
        ConditionalRuleEntity condition;
        TimingModel timingModel = this.getTimingModel();
        if (null != timingModel && null != (condition = timingModel.getCondition())) {
            super.copyForConditionalRuleEntity(condition, model.getModelKeyOld(), model.getModelKey());
        }
    }

    private void copyForMessage(DuplicateModel model) {
        String oldValue = model.getModelKeyOld();
        String newValue = model.getModelKey();
        super.copyForMessage(this.getInMsg(), oldValue, newValue);
        super.copyForMessage(this.getOutMsg(), oldValue, newValue);
    }
}

